/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.iterator;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.clustering.AbstractCluster;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.ClusteringTestUtils;
import org.apache.mahout.clustering.classify.ClusterClassifier;
import org.apache.mahout.clustering.fuzzykmeans.SoftCluster;
import org.apache.mahout.clustering.iterator.ClusterIterator;
import org.apache.mahout.clustering.iterator.ClusteringPolicy;
import org.apache.mahout.clustering.iterator.DistanceMeasureCluster;
import org.apache.mahout.clustering.iterator.FuzzyKMeansClusteringPolicy;
import org.apache.mahout.clustering.iterator.KMeansClusteringPolicy;
import org.apache.mahout.clustering.kmeans.Kluster;
import org.apache.mahout.clustering.kmeans.TestKmeansClustering;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.distance.CosineDistanceMeasure;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.ManhattanDistanceMeasure;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.junit.Test;

public final class TestClusterClassifier
extends MahoutTestCase {
    private static ClusterClassifier newDMClassifier() {
        ArrayList models = Lists.newArrayList();
        ManhattanDistanceMeasure measure = new ManhattanDistanceMeasure();
        models.add(new DistanceMeasureCluster(new DenseVector(2).assign(1.0), 0, (DistanceMeasure)measure));
        models.add(new DistanceMeasureCluster((Vector)new DenseVector(2), 1, (DistanceMeasure)measure));
        models.add(new DistanceMeasureCluster(new DenseVector(2).assign(-1.0), 2, (DistanceMeasure)measure));
        return new ClusterClassifier((List)models, (ClusteringPolicy)new KMeansClusteringPolicy());
    }

    private static ClusterClassifier newKlusterClassifier() {
        ArrayList models = Lists.newArrayList();
        ManhattanDistanceMeasure measure = new ManhattanDistanceMeasure();
        models.add(new Kluster(new DenseVector(2).assign(1.0), 0, (DistanceMeasure)measure));
        models.add(new Kluster((Vector)new DenseVector(2), 1, (DistanceMeasure)measure));
        models.add(new Kluster(new DenseVector(2).assign(-1.0), 2, (DistanceMeasure)measure));
        return new ClusterClassifier((List)models, (ClusteringPolicy)new KMeansClusteringPolicy());
    }

    private static ClusterClassifier newCosineKlusterClassifier() {
        ArrayList models = Lists.newArrayList();
        CosineDistanceMeasure measure = new CosineDistanceMeasure();
        models.add(new Kluster(new DenseVector(2).assign(1.0), 0, (DistanceMeasure)measure));
        models.add(new Kluster((Vector)new DenseVector(2), 1, (DistanceMeasure)measure));
        models.add(new Kluster(new DenseVector(2).assign(-1.0), 2, (DistanceMeasure)measure));
        return new ClusterClassifier((List)models, (ClusteringPolicy)new KMeansClusteringPolicy());
    }

    private static ClusterClassifier newSoftClusterClassifier() {
        ArrayList models = Lists.newArrayList();
        ManhattanDistanceMeasure measure = new ManhattanDistanceMeasure();
        models.add(new SoftCluster(new DenseVector(2).assign(1.0), 0, (DistanceMeasure)measure));
        models.add(new SoftCluster((Vector)new DenseVector(2), 1, (DistanceMeasure)measure));
        models.add(new SoftCluster(new DenseVector(2).assign(-1.0), 2, (DistanceMeasure)measure));
        return new ClusterClassifier((List)models, (ClusteringPolicy)new FuzzyKMeansClusteringPolicy());
    }

    private ClusterClassifier writeAndRead(ClusterClassifier classifier) throws IOException {
        Path path = new Path(this.getTestTempDirPath(), "output");
        classifier.writeToSeqFiles(path);
        ClusterClassifier newClassifier = new ClusterClassifier();
        newClassifier.readFromSeqFiles(this.getConfiguration(), path);
        return newClassifier;
    }

    @Test
    public void testDMClusterClassification() {
        ClusterClassifier classifier = TestClusterClassifier.newDMClassifier();
        Vector pdf = classifier.classify((Vector)new DenseVector(2));
        TestClusterClassifier.assertEquals((String)"[0,0]", (Object)"[0.2,0.6,0.2]", (Object)AbstractCluster.formatVector((Vector)pdf, null));
        pdf = classifier.classify(new DenseVector(2).assign(2.0));
        TestClusterClassifier.assertEquals((String)"[2,2]", (Object)"[0.493,0.296,0.211]", (Object)AbstractCluster.formatVector((Vector)pdf, null));
    }

    @Test
    public void testClusterClassification() {
        ClusterClassifier classifier = TestClusterClassifier.newKlusterClassifier();
        Vector pdf = classifier.classify((Vector)new DenseVector(2));
        TestClusterClassifier.assertEquals((String)"[0,0]", (Object)"[0.2,0.6,0.2]", (Object)AbstractCluster.formatVector((Vector)pdf, null));
        pdf = classifier.classify(new DenseVector(2).assign(2.0));
        TestClusterClassifier.assertEquals((String)"[2,2]", (Object)"[0.493,0.296,0.211]", (Object)AbstractCluster.formatVector((Vector)pdf, null));
    }

    @Test
    public void testSoftClusterClassification() {
        ClusterClassifier classifier = TestClusterClassifier.newSoftClusterClassifier();
        Vector pdf = classifier.classify((Vector)new DenseVector(2));
        TestClusterClassifier.assertEquals((String)"[0,0]", (Object)"[0.0,1.0,0.0]", (Object)AbstractCluster.formatVector((Vector)pdf, null));
        pdf = classifier.classify(new DenseVector(2).assign(2.0));
        TestClusterClassifier.assertEquals((String)"[2,2]", (Object)"[0.735,0.184,0.082]", (Object)AbstractCluster.formatVector((Vector)pdf, null));
    }

    @Test
    public void testDMClassifierSerialization() throws Exception {
        ClusterClassifier classifier = TestClusterClassifier.newDMClassifier();
        ClusterClassifier classifierOut = this.writeAndRead(classifier);
        TestClusterClassifier.assertEquals((long)classifier.getModels().size(), (long)classifierOut.getModels().size());
        TestClusterClassifier.assertEquals((Object)((Cluster)classifier.getModels().get(0)).getClass().getName(), (Object)((Cluster)classifierOut.getModels().get(0)).getClass().getName());
    }

    @Test
    public void testClusterClassifierSerialization() throws Exception {
        ClusterClassifier classifier = TestClusterClassifier.newKlusterClassifier();
        ClusterClassifier classifierOut = this.writeAndRead(classifier);
        TestClusterClassifier.assertEquals((long)classifier.getModels().size(), (long)classifierOut.getModels().size());
        TestClusterClassifier.assertEquals((Object)((Cluster)classifier.getModels().get(0)).getClass().getName(), (Object)((Cluster)classifierOut.getModels().get(0)).getClass().getName());
    }

    @Test
    public void testSoftClusterClassifierSerialization() throws Exception {
        ClusterClassifier classifier = TestClusterClassifier.newSoftClusterClassifier();
        ClusterClassifier classifierOut = this.writeAndRead(classifier);
        TestClusterClassifier.assertEquals((long)classifier.getModels().size(), (long)classifierOut.getModels().size());
        TestClusterClassifier.assertEquals((Object)((Cluster)classifier.getModels().get(0)).getClass().getName(), (Object)((Cluster)classifierOut.getModels().get(0)).getClass().getName());
    }

    @Test
    public void testClusterIteratorKMeans() {
        List<Vector> data = TestKmeansClustering.getPoints(TestKmeansClustering.REFERENCE);
        ClusterClassifier prior = TestClusterClassifier.newKlusterClassifier();
        ClusterClassifier posterior = ClusterIterator.iterate(data, (ClusterClassifier)prior, (int)5);
        TestClusterClassifier.assertEquals((long)3L, (long)posterior.getModels().size());
        for (Cluster cluster : posterior.getModels()) {
            System.out.println(cluster.asFormatString(null));
        }
    }

    @Test
    public void testClusterIteratorDirichlet() {
        List<Vector> data = TestKmeansClustering.getPoints(TestKmeansClustering.REFERENCE);
        ClusterClassifier prior = TestClusterClassifier.newKlusterClassifier();
        ClusterClassifier posterior = ClusterIterator.iterate(data, (ClusterClassifier)prior, (int)5);
        TestClusterClassifier.assertEquals((long)3L, (long)posterior.getModels().size());
        for (Cluster cluster : posterior.getModels()) {
            System.out.println(cluster.asFormatString(null));
        }
    }

    @Test
    public void testSeqFileClusterIteratorKMeans() throws IOException {
        Path pointsPath = this.getTestTempDirPath("points");
        Path priorPath = this.getTestTempDirPath("prior");
        Path outPath = this.getTestTempDirPath("output");
        Configuration conf = this.getConfiguration();
        FileSystem fs = FileSystem.get((URI)pointsPath.toUri(), (Configuration)conf);
        List<VectorWritable> points = TestKmeansClustering.getPointsWritable(TestKmeansClustering.REFERENCE);
        ClusteringTestUtils.writePointsToFile(points, new Path(pointsPath, "file1"), fs, conf);
        Path path = new Path(priorPath, "priorClassifier");
        ClusterClassifier prior = TestClusterClassifier.newKlusterClassifier();
        prior.writeToSeqFiles(path);
        TestClusterClassifier.assertEquals((long)3L, (long)prior.getModels().size());
        System.out.println("Prior");
        for (Cluster cluster : prior.getModels()) {
            System.out.println(cluster.asFormatString(null));
        }
        ClusterIterator.iterateSeq((Configuration)conf, (Path)pointsPath, (Path)path, (Path)outPath, (int)5);
        for (int i = 1; i <= 4; ++i) {
            System.out.println("Classifier-" + i);
            ClusterClassifier posterior = new ClusterClassifier();
            String name = i == 4 ? "clusters-4-final" : "clusters-" + i;
            posterior.readFromSeqFiles(conf, new Path(outPath, name));
            TestClusterClassifier.assertEquals((long)3L, (long)posterior.getModels().size());
            for (Cluster cluster : posterior.getModels()) {
                System.out.println(cluster.asFormatString(null));
            }
        }
    }

    @Test
    public void testMRFileClusterIteratorKMeans() throws Exception {
        Path pointsPath = this.getTestTempDirPath("points");
        Path priorPath = this.getTestTempDirPath("prior");
        Path outPath = this.getTestTempDirPath("output");
        Configuration conf = this.getConfiguration();
        FileSystem fs = FileSystem.get((URI)pointsPath.toUri(), (Configuration)conf);
        List<VectorWritable> points = TestKmeansClustering.getPointsWritable(TestKmeansClustering.REFERENCE);
        ClusteringTestUtils.writePointsToFile(points, new Path(pointsPath, "file1"), fs, conf);
        Path path = new Path(priorPath, "priorClassifier");
        ClusterClassifier prior = TestClusterClassifier.newKlusterClassifier();
        prior.writeToSeqFiles(path);
        KMeansClusteringPolicy policy = new KMeansClusteringPolicy();
        ClusterClassifier.writePolicy((ClusteringPolicy)policy, (Path)path);
        TestClusterClassifier.assertEquals((long)3L, (long)prior.getModels().size());
        System.out.println("Prior");
        for (Cluster cluster : prior.getModels()) {
            System.out.println(cluster.asFormatString(null));
        }
        ClusterIterator.iterateMR((Configuration)conf, (Path)pointsPath, (Path)path, (Path)outPath, (int)5);
        for (int i = 1; i <= 4; ++i) {
            System.out.println("Classifier-" + i);
            ClusterClassifier posterior = new ClusterClassifier();
            String name = i == 4 ? "clusters-4-final" : "clusters-" + i;
            posterior.readFromSeqFiles(conf, new Path(outPath, name));
            TestClusterClassifier.assertEquals((long)3L, (long)posterior.getModels().size());
            for (Cluster cluster : posterior.getModels()) {
                System.out.println(cluster.asFormatString(null));
            }
        }
    }

    @Test
    public void testCosineKlusterClassification() {
        ClusterClassifier classifier = TestClusterClassifier.newCosineKlusterClassifier();
        Vector pdf = classifier.classify((Vector)new DenseVector(2));
        TestClusterClassifier.assertEquals((String)"[0,0]", (Object)"[0.333,0.333,0.333]", (Object)AbstractCluster.formatVector((Vector)pdf, null));
        pdf = classifier.classify(new DenseVector(2).assign(2.0));
        TestClusterClassifier.assertEquals((String)"[2,2]", (Object)"[0.429,0.429,0.143]", (Object)AbstractCluster.formatVector((Vector)pdf, null));
    }
}

