/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.fuzzykmeans;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.clustering.ClusteringTestUtils;
import org.apache.mahout.clustering.fuzzykmeans.FuzzyKMeansDriver;
import org.apache.mahout.clustering.fuzzykmeans.SoftCluster;
import org.apache.mahout.clustering.kmeans.TestKmeansClustering;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.EuclideanDistanceMeasure;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.junit.Before;
import org.junit.Test;

public final class TestFuzzyKmeansClustering
extends MahoutTestCase {
    private FileSystem fs;
    private final DistanceMeasure measure = new EuclideanDistanceMeasure();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Configuration conf = this.getConfiguration();
        this.fs = FileSystem.get((Configuration)conf);
    }

    private static Vector tweakValue(Vector point) {
        return point.plus(0.1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFuzzyKMeansSeqJob() throws Exception {
        List<VectorWritable> points = TestKmeansClustering.getPointsWritable(TestKmeansClustering.REFERENCE);
        Path pointsPath = this.getTestTempDirPath("points");
        Path clustersPath = this.getTestTempDirPath("clusters");
        Configuration conf = this.getConfiguration();
        ClusteringTestUtils.writePointsToFile(points, new Path(pointsPath, "file1"), this.fs, conf);
        for (int k = 0; k < points.size(); ++k) {
            System.out.println("testKFuzzyKMeansMRJob k= " + k);
            SequenceFile.Writer writer = new SequenceFile.Writer(this.fs, conf, new Path(clustersPath, "part-00000"), Text.class, SoftCluster.class);
            try {
                for (int i = 0; i < k + 1; ++i) {
                    Vector vec = TestFuzzyKmeansClustering.tweakValue(points.get(i).get());
                    SoftCluster cluster = new SoftCluster(vec, i, this.measure);
                    cluster.observe(cluster.getCenter(), 1.0);
                    writer.append((Writable)new Text(cluster.getIdentifier()), (Writable)cluster);
                }
            }
            finally {
                Closeables.close((Closeable)writer, (boolean)false);
            }
            Path output = this.getTestTempDirPath("output" + k);
            String[] args = new String[]{TestFuzzyKmeansClustering.optKey("input"), pointsPath.toString(), TestFuzzyKmeansClustering.optKey("clusters"), clustersPath.toString(), TestFuzzyKmeansClustering.optKey("output"), output.toString(), TestFuzzyKmeansClustering.optKey("distanceMeasure"), EuclideanDistanceMeasure.class.getName(), TestFuzzyKmeansClustering.optKey("convergenceDelta"), "0.001", TestFuzzyKmeansClustering.optKey("maxIter"), "2", TestFuzzyKmeansClustering.optKey("m"), "2.0", TestFuzzyKmeansClustering.optKey("clustering"), TestFuzzyKmeansClustering.optKey("emitMostLikely"), TestFuzzyKmeansClustering.optKey("overwrite"), TestFuzzyKmeansClustering.optKey("method"), "sequential"};
            FuzzyKMeansDriver.main((String[])args);
            long count = HadoopUtil.countRecords((Path)new Path(output, "clusteredPoints/part-m-0"), (Configuration)conf);
            TestFuzzyKmeansClustering.assertTrue((count > 0L ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFuzzyKMeansMRJob() throws Exception {
        List<VectorWritable> points = TestKmeansClustering.getPointsWritable(TestKmeansClustering.REFERENCE);
        Path pointsPath = this.getTestTempDirPath("points");
        Path clustersPath = this.getTestTempDirPath("clusters");
        Configuration conf = this.getConfiguration();
        ClusteringTestUtils.writePointsToFile(points, new Path(pointsPath, "file1"), this.fs, conf);
        for (int k = 0; k < points.size(); ++k) {
            System.out.println("testKFuzzyKMeansMRJob k= " + k);
            SequenceFile.Writer writer = new SequenceFile.Writer(this.fs, conf, new Path(clustersPath, "part-00000"), Text.class, SoftCluster.class);
            try {
                for (int i = 0; i < k + 1; ++i) {
                    Vector vec = TestFuzzyKmeansClustering.tweakValue(points.get(i).get());
                    SoftCluster cluster = new SoftCluster(vec, i, this.measure);
                    cluster.observe(cluster.getCenter(), 1.0);
                    writer.append((Writable)new Text(cluster.getIdentifier()), (Writable)cluster);
                }
            }
            finally {
                Closeables.close((Closeable)writer, (boolean)false);
            }
            Path output = this.getTestTempDirPath("output" + k);
            String[] args = new String[]{TestFuzzyKmeansClustering.optKey("input"), pointsPath.toString(), TestFuzzyKmeansClustering.optKey("clusters"), clustersPath.toString(), TestFuzzyKmeansClustering.optKey("output"), output.toString(), TestFuzzyKmeansClustering.optKey("distanceMeasure"), EuclideanDistanceMeasure.class.getName(), TestFuzzyKmeansClustering.optKey("convergenceDelta"), "0.001", TestFuzzyKmeansClustering.optKey("maxIter"), "2", TestFuzzyKmeansClustering.optKey("m"), "2.0", TestFuzzyKmeansClustering.optKey("clustering"), TestFuzzyKmeansClustering.optKey("emitMostLikely"), TestFuzzyKmeansClustering.optKey("overwrite")};
            ToolRunner.run((Configuration)this.getConfiguration(), (Tool)new FuzzyKMeansDriver(), (String[])args);
            long count = HadoopUtil.countRecords((Path)new Path(output, "clusteredPoints/part-m-00000"), (Configuration)conf);
            TestFuzzyKmeansClustering.assertTrue((count > 0L ? 1 : 0) != 0);
        }
    }
}

