/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sgd;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.mahout.classifier.sgd.CsvRecordFactory;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.vectorizer.encoders.Dictionary;
import org.junit.Test;

public final class CsvRecordFactoryTest
extends MahoutTestCase {
    @Test
    public void testAddToVector() {
        CsvRecordFactory csv = new CsvRecordFactory("y", (Map)ImmutableMap.of((Object)"x1", (Object)"n", (Object)"x2", (Object)"w", (Object)"x3", (Object)"t"));
        csv.firstLine("z,x1,y,x2,x3,q");
        csv.maxTargetValue(2);
        DenseVector v = new DenseVector(2000);
        int t = csv.processLine("ignore,3.1,yes,tiger, \"this is text\",ignore", (Vector)v);
        CsvRecordFactoryTest.assertEquals((long)0L, (long)t);
        CsvRecordFactoryTest.assertEquals((double)9.0, (double)v.norm(0.0), (double)0.0);
        CsvRecordFactoryTest.assertEquals((double)3.1, (double)v.maxValue(), (double)0.0);
        v.set(v.maxValueIndex(), 0.0);
        CsvRecordFactoryTest.assertEquals((double)8.0, (double)v.norm(0.0), (double)0.0);
        CsvRecordFactoryTest.assertEquals((double)8.0, (double)v.norm(1.0), (double)0.0);
        CsvRecordFactoryTest.assertEquals((double)1.0, (double)v.maxValue(), (double)0.0);
        v.assign(0.0);
        t = csv.processLine("ignore,5.3,no,line, \"and more text and more\",ignore", (Vector)v);
        CsvRecordFactoryTest.assertEquals((long)1L, (long)t);
        CsvRecordFactoryTest.assertEquals((double)9.0, (double)v.norm(0.0), (double)0.0);
        CsvRecordFactoryTest.assertEquals((double)5.3, (double)v.maxValue(), (double)0.0);
        v.set(v.maxValueIndex(), 0.0);
        CsvRecordFactoryTest.assertEquals((double)8.0, (double)v.norm(0.0), (double)0.0);
        CsvRecordFactoryTest.assertEquals((double)10.339850002884626, (double)v.norm(1.0), (double)1.0E-6);
        CsvRecordFactoryTest.assertEquals((double)1.5849625007211563, (double)v.maxValue(), (double)1.0E-6);
        v.assign(0.0);
        t = csv.processLine("ignore,5.3,invalid,line, \"and more text and more\",ignore", (Vector)v);
        CsvRecordFactoryTest.assertEquals((long)1L, (long)t);
        CsvRecordFactoryTest.assertEquals((double)9.0, (double)v.norm(0.0), (double)0.0);
        CsvRecordFactoryTest.assertEquals((double)5.3, (double)v.maxValue(), (double)0.0);
        v.set(v.maxValueIndex(), 0.0);
        CsvRecordFactoryTest.assertEquals((double)8.0, (double)v.norm(0.0), (double)0.0);
        CsvRecordFactoryTest.assertEquals((double)10.339850002884626, (double)v.norm(1.0), (double)1.0E-6);
        CsvRecordFactoryTest.assertEquals((double)1.5849625007211563, (double)v.maxValue(), (double)1.0E-6);
    }

    @Test
    public void testDictionaryOrder() {
        Dictionary dict = new Dictionary();
        dict.intern("a");
        dict.intern("d");
        dict.intern("c");
        dict.intern("b");
        dict.intern("qrz");
        CsvRecordFactoryTest.assertEquals((Object)"[a, d, c, b, qrz]", (Object)dict.values().toString());
        Dictionary dict2 = Dictionary.fromList((Iterable)dict.values());
        CsvRecordFactoryTest.assertEquals((Object)"[a, d, c, b, qrz]", (Object)dict2.values().toString());
    }
}

