/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.mlp;

import java.io.File;
import org.apache.mahout.classifier.mlp.Datasets;
import org.apache.mahout.classifier.mlp.RunMultilayerPerceptron;
import org.apache.mahout.classifier.mlp.TrainMultilayerPerceptron;
import org.apache.mahout.common.MahoutTestCase;
import org.junit.Test;

public class RunMultilayerPerceptronTest
extends MahoutTestCase {
    @Test
    public void runMultilayerPerceptron() throws Exception {
        String modelFileName = "mlp.model";
        File modelFile = this.getTestTempFile(modelFileName);
        File irisDataset = this.getTestTempFile("iris.csv");
        RunMultilayerPerceptronTest.writeLines(irisDataset, Datasets.IRIS);
        String[] argsTrain = new String[]{"-i", irisDataset.getAbsolutePath(), "-sh", "-labels", "setosa", "versicolor", "virginica", "-mo", modelFile.getAbsolutePath(), "-u", "-ls", "4", "8", "3"};
        TrainMultilayerPerceptron.main((String[])argsTrain);
        RunMultilayerPerceptronTest.assertTrue((boolean)modelFile.exists());
        String outputFileName = "labelResult.txt";
        File outputFile = this.getTestTempFile(outputFileName);
        String[] argsLabeling = new String[]{"-i", irisDataset.getAbsolutePath(), "-sh", "-cr", "0", "3", "-mo", modelFile.getAbsolutePath(), "-o", outputFile.getAbsolutePath()};
        RunMultilayerPerceptron.main((String[])argsLabeling);
        RunMultilayerPerceptronTest.assertTrue((boolean)outputFile.exists());
    }
}

