/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.mapreduce.partial;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.mahout.classifier.df.builder.DefaultTreeBuilder;
import org.apache.mahout.classifier.df.builder.TreeBuilder;
import org.apache.mahout.classifier.df.mapreduce.MapredOutput;
import org.apache.mahout.classifier.df.mapreduce.partial.PartialBuilder;
import org.apache.mahout.classifier.df.mapreduce.partial.Step1Mapper;
import org.apache.mahout.classifier.df.mapreduce.partial.TreeID;
import org.apache.mahout.classifier.df.node.Leaf;
import org.apache.mahout.classifier.df.node.Node;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.junit.Assert;
import org.junit.Test;

public final class PartialBuilderTest
extends MahoutTestCase {
    private static final int NUM_MAPS = 5;
    private static final int NUM_TREES = 32;
    private static final int NUM_INSTANCES = 20;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessOutput() throws Exception {
        Configuration conf = this.getConfiguration();
        conf.setInt("mapred.map.tasks", 5);
        RandomWrapper rng = RandomUtils.getRandom();
        Object[] keys = new TreeID[32];
        MapredOutput[] values = new MapredOutput[32];
        int[] firstIds = new int[5];
        PartialBuilderTest.randomKeyValues((Random)rng, (TreeID[])keys, values, firstIds);
        Path base = this.getTestTempDirPath("testdata");
        FileSystem fs = base.getFileSystem(conf);
        Path outputFile = new Path(base, "PartialBuilderTest.seq");
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)outputFile, TreeID.class, MapredOutput.class);
        try {
            for (int index = 0; index < 32; ++index) {
                writer.append((Writable)keys[index], (Writable)values[index]);
            }
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
        Object[] newKeys = new TreeID[32];
        Node[] newTrees = new Node[32];
        PartialBuilder.processOutput((JobContext)new Job(conf), (Path)base, (TreeID[])newKeys, (Node[])newTrees);
        for (int tree = 0; tree < 32; ++tree) {
            PartialBuilderTest.assertEquals((Object)values[tree].getTree(), (Object)newTrees[tree]);
        }
        PartialBuilderTest.assertTrue((String)"keys not equal", (boolean)Arrays.deepEquals(keys, newKeys));
    }

    @Test
    public void testConfigure() {
        DefaultTreeBuilder treeBuilder = new DefaultTreeBuilder();
        Path dataPath = new Path("notUsedDataPath");
        Path datasetPath = new Path("notUsedDatasetPath");
        Long seed = 5L;
        new PartialBuilderChecker((TreeBuilder)treeBuilder, dataPath, datasetPath, seed);
    }

    private static void randomKeyValues(Random rng, TreeID[] keys, MapredOutput[] values, int[] firstIds) {
        int index = 0;
        int firstId = 0;
        ArrayList partitions = Lists.newArrayList();
        for (int p = 0; p < 5; ++p) {
            int partition;
            while (partitions.contains(partition = rng.nextInt(5))) {
            }
            partitions.add(partition);
            int nbTrees = Step1Mapper.nbTrees((int)5, (int)32, (int)partition);
            for (int treeId = 0; treeId < nbTrees; ++treeId) {
                Leaf tree = new Leaf((double)rng.nextInt(100));
                keys[index] = new TreeID(partition, treeId);
                values[index] = new MapredOutput((Node)tree, PartialBuilderTest.nextIntArray(rng, 20));
                ++index;
            }
            firstIds[p] = firstId;
            firstId += 20;
        }
    }

    private static int[] nextIntArray(Random rng, int size) {
        int[] array = new int[size];
        for (int index = 0; index < size; ++index) {
            array[index] = rng.nextInt(101) - 1;
        }
        return array;
    }

    static class PartialBuilderChecker
    extends PartialBuilder {
        private final Long seed;
        private final TreeBuilder treeBuilder;
        private final Path datasetPath;

        PartialBuilderChecker(TreeBuilder treeBuilder, Path dataPath, Path datasetPath, Long seed) {
            super(treeBuilder, dataPath, datasetPath, seed);
            this.seed = seed;
            this.treeBuilder = treeBuilder;
            this.datasetPath = datasetPath;
        }

        protected boolean runJob(Job job) throws IOException {
            Configuration conf = job.getConfiguration();
            Assert.assertEquals((Object)this.seed, (Object)PartialBuilderChecker.getRandomSeed((Configuration)conf));
            Assert.assertEquals((long)1L, (long)conf.getInt("mapred.map.tasks", -1));
            Assert.assertEquals((long)32L, (long)PartialBuilderChecker.getNbTrees((Configuration)conf));
            Assert.assertFalse((boolean)PartialBuilderChecker.isOutput((Configuration)conf));
            Assert.assertEquals((Object)this.treeBuilder, (Object)PartialBuilderChecker.getTreeBuilder((Configuration)conf));
            Assert.assertEquals((Object)this.datasetPath, (Object)PartialBuilderChecker.getDistributedCacheFile((Configuration)conf, (int)0));
            return true;
        }
    }
}

