/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.mapreduce.inmem;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.mahout.classifier.df.mapreduce.Builder;
import org.apache.mahout.classifier.df.mapreduce.inmem.InMemInputFormat;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.junit.Test;

public final class InMemInputFormatTest
extends MahoutTestCase {
    @Test
    public void testSplits() throws Exception {
        int n = 1;
        int maxNumSplits = 100;
        int maxNbTrees = 1000;
        RandomWrapper rng = RandomUtils.getRandom();
        for (int nloop = 0; nloop < n; ++nloop) {
            int numSplits = rng.nextInt(maxNumSplits) + 1;
            int nbTrees = rng.nextInt(maxNbTrees) + 1;
            Configuration conf = this.getConfiguration();
            Builder.setNbTrees((Configuration)conf, (int)nbTrees);
            InMemInputFormat inputFormat = new InMemInputFormat();
            List splits = inputFormat.getSplits(conf, numSplits);
            InMemInputFormatTest.assertEquals((long)numSplits, (long)splits.size());
            int nbTreesPerSplit = nbTrees / numSplits;
            int totalTrees = 0;
            int expectedId = 0;
            for (int index = 0; index < numSplits; ++index) {
                InMemInputFormatTest.assertTrue((boolean)(splits.get(index) instanceof InMemInputFormat.InMemInputSplit));
                InMemInputFormat.InMemInputSplit split = (InMemInputFormat.InMemInputSplit)splits.get(index);
                InMemInputFormatTest.assertEquals((long)expectedId, (long)split.getFirstId());
                if (index < numSplits - 1) {
                    InMemInputFormatTest.assertEquals((long)nbTreesPerSplit, (long)split.getNbTrees());
                } else {
                    InMemInputFormatTest.assertEquals((long)(nbTrees - totalTrees), (long)split.getNbTrees());
                }
                totalTrees += split.getNbTrees();
                expectedId += split.getNbTrees();
            }
        }
    }

    @Test
    public void testRecordReader() throws Exception {
        int n = 1;
        int maxNumSplits = 100;
        int maxNbTrees = 1000;
        RandomWrapper rng = RandomUtils.getRandom();
        for (int nloop = 0; nloop < n; ++nloop) {
            int numSplits = rng.nextInt(maxNumSplits) + 1;
            int nbTrees = rng.nextInt(maxNbTrees) + 1;
            Configuration conf = this.getConfiguration();
            Builder.setNbTrees((Configuration)conf, (int)nbTrees);
            InMemInputFormat inputFormat = new InMemInputFormat();
            List splits = inputFormat.getSplits(conf, numSplits);
            for (int index = 0; index < numSplits; ++index) {
                InMemInputFormat.InMemInputSplit split = (InMemInputFormat.InMemInputSplit)splits.get(index);
                InMemInputFormat.InMemRecordReader reader = new InMemInputFormat.InMemRecordReader(split);
                reader.initialize((InputSplit)split, null);
                for (int tree = 0; tree < split.getNbTrees(); ++tree) {
                    InMemInputFormatTest.assertEquals((Object)(tree < split.getNbTrees() ? 1 : 0), (Object)reader.nextKeyValue());
                    InMemInputFormatTest.assertEquals((long)(split.getFirstId() + tree), (long)reader.getCurrentKey().get());
                }
            }
        }
    }
}

