/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import java.util.Collections;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.model.GenericPreference;
import org.apache.mahout.cf.taste.impl.model.GenericUserPreferenceArray;
import org.apache.mahout.cf.taste.impl.recommender.AllUnknownItemsCandidateItemsStrategy;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.easymock.EasyMock;
import org.junit.Test;

public final class AllUnknownItemsCandidateItemsStrategyTest
extends TasteTestCase {
    @Test
    public void testStrategy() throws TasteException {
        FastIDSet allItemIDs = new FastIDSet();
        allItemIDs.addAll(new long[]{1L, 2L, 3L});
        FastIDSet preferredItemIDs = new FastIDSet(1);
        preferredItemIDs.add(2L);
        DataModel dataModel = (DataModel)EasyMock.createMock(DataModel.class);
        EasyMock.expect((Object)dataModel.getNumItems()).andReturn((Object)3);
        EasyMock.expect((Object)dataModel.getItemIDs()).andReturn((Object)allItemIDs.iterator());
        GenericUserPreferenceArray prefArrayOfUser123 = new GenericUserPreferenceArray(Collections.singletonList(new GenericPreference(123L, 2L, 1.0f)));
        AllUnknownItemsCandidateItemsStrategy strategy = new AllUnknownItemsCandidateItemsStrategy();
        EasyMock.replay((Object[])new Object[]{dataModel});
        FastIDSet candidateItems = strategy.getCandidateItems(123L, (PreferenceArray)prefArrayOfUser123, dataModel, false);
        AllUnknownItemsCandidateItemsStrategyTest.assertEquals((long)2L, (long)candidateItems.size());
        AllUnknownItemsCandidateItemsStrategyTest.assertTrue((boolean)candidateItems.contains(1L));
        AllUnknownItemsCandidateItemsStrategyTest.assertTrue((boolean)candidateItems.contains(3L));
        EasyMock.verify((Object[])new Object[]{dataModel});
    }
}

