/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.eval;

import java.io.File;
import org.apache.mahout.cf.taste.impl.eval.LoadEvaluator;
import org.apache.mahout.cf.taste.impl.eval.LoadStatistics;
import org.apache.mahout.cf.taste.impl.model.file.FileDataModel;
import org.apache.mahout.cf.taste.impl.neighborhood.NearestNUserNeighborhood;
import org.apache.mahout.cf.taste.impl.recommender.GenericItemBasedRecommender;
import org.apache.mahout.cf.taste.impl.recommender.GenericUserBasedRecommender;
import org.apache.mahout.cf.taste.impl.similarity.EuclideanDistanceSimilarity;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.neighborhood.UserNeighborhood;
import org.apache.mahout.cf.taste.recommender.Recommender;
import org.apache.mahout.cf.taste.similarity.ItemSimilarity;
import org.apache.mahout.cf.taste.similarity.UserSimilarity;

public final class LoadEvaluationRunner {
    private static final int LOOPS = 10;

    private LoadEvaluationRunner() {
    }

    public static void main(String[] args) throws Exception {
        FileDataModel model = new FileDataModel(new File(args[0]));
        int howMany = 10;
        if (args.length > 1) {
            howMany = Integer.parseInt(args[1]);
        }
        System.out.println("Run Items");
        EuclideanDistanceSimilarity similarity = new EuclideanDistanceSimilarity((DataModel)model);
        GenericItemBasedRecommender recommender = new GenericItemBasedRecommender((DataModel)model, (ItemSimilarity)similarity);
        for (int i = 0; i < 10; ++i) {
            LoadStatistics loadStats = LoadEvaluator.runLoad((Recommender)recommender, (int)howMany);
            System.out.println(loadStats);
        }
        System.out.println("Run Users");
        EuclideanDistanceSimilarity userSim = new EuclideanDistanceSimilarity((DataModel)model);
        NearestNUserNeighborhood neighborhood = new NearestNUserNeighborhood(10, (UserSimilarity)userSim, (DataModel)model);
        recommender = new GenericUserBasedRecommender((DataModel)model, (UserNeighborhood)neighborhood, (UserSimilarity)userSim);
        for (int i = 0; i < 10; ++i) {
            LoadStatistics loadStats = LoadEvaluator.runLoad((Recommender)recommender, (int)howMany);
            System.out.println(loadStats);
        }
    }
}

