/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.eval;

import org.apache.mahout.cf.taste.eval.DataModelBuilder;
import org.apache.mahout.cf.taste.eval.IRStatistics;
import org.apache.mahout.cf.taste.eval.RecommenderBuilder;
import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.eval.GenericRecommenderIRStatsEvaluator;
import org.apache.mahout.cf.taste.impl.eval.IRStatisticsImpl;
import org.apache.mahout.cf.taste.impl.model.GenericBooleanPrefDataModel;
import org.apache.mahout.cf.taste.impl.recommender.GenericBooleanPrefItemBasedRecommender;
import org.apache.mahout.cf.taste.impl.similarity.LogLikelihoodSimilarity;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.recommender.Recommender;
import org.apache.mahout.cf.taste.similarity.ItemSimilarity;
import org.junit.Test;

public final class GenericRecommenderIRStatsEvaluatorImplTest
extends TasteTestCase {
    @Test
    public void testBoolean() throws Exception {
        DataModel model = GenericRecommenderIRStatsEvaluatorImplTest.getBooleanDataModel();
        RecommenderBuilder builder = new RecommenderBuilder(){

            public Recommender buildRecommender(DataModel dataModel) {
                return new GenericBooleanPrefItemBasedRecommender(dataModel, (ItemSimilarity)new LogLikelihoodSimilarity(dataModel));
            }
        };
        DataModelBuilder dataModelBuilder = new DataModelBuilder(){

            public DataModel buildDataModel(FastByIDMap<PreferenceArray> trainingData) {
                return new GenericBooleanPrefDataModel(GenericBooleanPrefDataModel.toDataMap(trainingData));
            }
        };
        GenericRecommenderIRStatsEvaluator evaluator = new GenericRecommenderIRStatsEvaluator();
        IRStatistics stats = evaluator.evaluate(builder, dataModelBuilder, model, null, 1, Double.NaN, 1.0);
        GenericRecommenderIRStatsEvaluatorImplTest.assertNotNull((Object)stats);
        GenericRecommenderIRStatsEvaluatorImplTest.assertEquals((double)0.666666666, (double)stats.getPrecision(), (double)1.0E-6);
        GenericRecommenderIRStatsEvaluatorImplTest.assertEquals((double)0.666666666, (double)stats.getRecall(), (double)1.0E-6);
        GenericRecommenderIRStatsEvaluatorImplTest.assertEquals((double)0.666666666, (double)stats.getF1Measure(), (double)1.0E-6);
        GenericRecommenderIRStatsEvaluatorImplTest.assertEquals((double)0.666666666, (double)stats.getFNMeasure(2.0), (double)1.0E-6);
        GenericRecommenderIRStatsEvaluatorImplTest.assertEquals((double)0.666666666, (double)stats.getNormalizedDiscountedCumulativeGain(), (double)1.0E-6);
    }

    @Test
    public void testIRStats() {
        IRStatisticsImpl stats = new IRStatisticsImpl(0.3, 0.1, 0.2, 0.05, 0.15);
        GenericRecommenderIRStatsEvaluatorImplTest.assertEquals((double)0.3, (double)stats.getPrecision(), (double)1.0E-6);
        GenericRecommenderIRStatsEvaluatorImplTest.assertEquals((double)0.1, (double)stats.getRecall(), (double)1.0E-6);
        GenericRecommenderIRStatsEvaluatorImplTest.assertEquals((double)0.15, (double)stats.getF1Measure(), (double)1.0E-6);
        GenericRecommenderIRStatsEvaluatorImplTest.assertEquals((double)0.11538461538462, (double)stats.getFNMeasure(2.0), (double)1.0E-6);
        GenericRecommenderIRStatsEvaluatorImplTest.assertEquals((double)0.05, (double)stats.getNormalizedDiscountedCumulativeGain(), (double)1.0E-6);
    }
}

