/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.common;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.common.FastMap;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.junit.Test;

public final class FastMapTest
extends TasteTestCase {
    @Test
    public void testPutAndGet() {
        FastMap map = new FastMap();
        FastMapTest.assertNull(map.get("foo"));
        map.put("foo", "bar");
        FastMapTest.assertEquals((Object)"bar", map.get("foo"));
    }

    @Test
    public void testRemove() {
        FastMap map = new FastMap();
        map.put("foo", "bar");
        map.remove("foo");
        FastMapTest.assertEquals((long)0L, (long)map.size());
        FastMapTest.assertTrue((boolean)map.isEmpty());
        FastMapTest.assertNull(map.get("foo"));
    }

    @Test
    public void testClear() {
        FastMap map = new FastMap();
        map.put("foo", "bar");
        map.clear();
        FastMapTest.assertEquals((long)0L, (long)map.size());
        FastMapTest.assertTrue((boolean)map.isEmpty());
        FastMapTest.assertNull(map.get("foo"));
    }

    @Test
    public void testSizeEmpty() {
        FastMap map = new FastMap();
        FastMapTest.assertEquals((long)0L, (long)map.size());
        FastMapTest.assertTrue((boolean)map.isEmpty());
        map.put("foo", "bar");
        FastMapTest.assertEquals((long)1L, (long)map.size());
        FastMapTest.assertFalse((boolean)map.isEmpty());
        map.remove("foo");
        FastMapTest.assertEquals((long)0L, (long)map.size());
        FastMapTest.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testContains() {
        FastMap<String, String> map = FastMapTest.buildTestFastMap();
        FastMapTest.assertTrue((boolean)map.containsKey((Object)"foo"));
        FastMapTest.assertTrue((boolean)map.containsKey((Object)"baz"));
        FastMapTest.assertTrue((boolean)map.containsKey((Object)"alpha"));
        FastMapTest.assertTrue((boolean)map.containsValue((Object)"bar"));
        FastMapTest.assertTrue((boolean)map.containsValue((Object)"bang"));
        FastMapTest.assertTrue((boolean)map.containsValue((Object)"beta"));
        FastMapTest.assertFalse((boolean)map.containsKey((Object)"something"));
        FastMapTest.assertFalse((boolean)map.containsValue((Object)"something"));
    }

    @Test(expected=NullPointerException.class)
    public void testNull1() {
        FastMap map = new FastMap();
        FastMapTest.assertNull(map.get(null));
        map.put(null, "bar");
    }

    @Test(expected=NullPointerException.class)
    public void testNull2() {
        FastMap map = new FastMap();
        map.put("foo", null);
    }

    @Test
    public void testRehash() {
        FastMap<String, String> map = FastMapTest.buildTestFastMap();
        map.remove((Object)"foo");
        map.rehash();
        FastMapTest.assertNull((Object)map.get((Object)"foo"));
        FastMapTest.assertEquals((Object)"bang", (Object)map.get((Object)"baz"));
    }

    @Test
    public void testGrow() {
        FastMap map = new FastMap(1, Integer.MAX_VALUE);
        map.put("foo", "bar");
        map.put("baz", "bang");
        FastMapTest.assertEquals((Object)"bar", map.get("foo"));
        FastMapTest.assertEquals((Object)"bang", map.get("baz"));
    }

    @Test
    public void testKeySet() {
        FastMap<String, String> map = FastMapTest.buildTestFastMap();
        HashSet expected = Sets.newHashSetWithExpectedSize((int)3);
        expected.add("foo");
        expected.add("baz");
        expected.add("alpha");
        Set actual = map.keySet();
        FastMapTest.assertTrue((boolean)expected.containsAll(actual));
        FastMapTest.assertTrue((boolean)actual.containsAll(expected));
        Iterator it = actual.iterator();
        while (it.hasNext()) {
            String value = (String)it.next();
            if ("baz".equals(value)) continue;
            it.remove();
        }
        FastMapTest.assertTrue((boolean)map.containsKey((Object)"baz"));
        FastMapTest.assertFalse((boolean)map.containsKey((Object)"foo"));
        FastMapTest.assertFalse((boolean)map.containsKey((Object)"alpha"));
    }

    @Test
    public void testValues() {
        FastMap<String, String> map = FastMapTest.buildTestFastMap();
        HashSet expected = Sets.newHashSetWithExpectedSize((int)3);
        expected.add("bar");
        expected.add("bang");
        expected.add("beta");
        Collection actual = map.values();
        FastMapTest.assertTrue((boolean)expected.containsAll(actual));
        FastMapTest.assertTrue((boolean)actual.containsAll(expected));
        Iterator it = actual.iterator();
        while (it.hasNext()) {
            String value = (String)it.next();
            if ("bang".equals(value)) continue;
            it.remove();
        }
        FastMapTest.assertTrue((boolean)map.containsValue((Object)"bang"));
        FastMapTest.assertFalse((boolean)map.containsValue((Object)"bar"));
        FastMapTest.assertFalse((boolean)map.containsValue((Object)"beta"));
    }

    @Test
    public void testEntrySet() {
        FastMap<String, String> map = FastMapTest.buildTestFastMap();
        Set actual = map.entrySet();
        HashSet expectedKeys = Sets.newHashSetWithExpectedSize((int)3);
        expectedKeys.add("foo");
        expectedKeys.add("baz");
        expectedKeys.add("alpha");
        HashSet expectedValues = Sets.newHashSetWithExpectedSize((int)3);
        expectedValues.add("bar");
        expectedValues.add("bang");
        expectedValues.add("beta");
        FastMapTest.assertEquals((long)3L, (long)actual.size());
        for (Map.Entry entry : actual) {
            expectedKeys.remove(entry.getKey());
            expectedValues.remove(entry.getValue());
        }
        FastMapTest.assertEquals((long)0L, (long)expectedKeys.size());
        FastMapTest.assertEquals((long)0L, (long)expectedValues.size());
    }

    @Test
    public void testVersusHashMap() {
        FastMap actual = new FastMap(1, 1000000);
        HashMap expected = Maps.newHashMapWithExpectedSize((int)1000000);
        RandomWrapper r = RandomUtils.getRandom();
        for (int i = 0; i < 1000000; ++i) {
            double d = r.nextDouble();
            Integer key = r.nextInt(100);
            if (d < 0.4) {
                FastMapTest.assertEquals(expected.get(key), actual.get(key));
                continue;
            }
            if (d < 0.7) {
                FastMapTest.assertEquals((Object)expected.put(key, "foo"), (Object)actual.put(key, "foo"));
            } else {
                FastMapTest.assertEquals(expected.remove(key), actual.remove(key));
            }
            FastMapTest.assertEquals((long)expected.size(), (long)actual.size());
            FastMapTest.assertEquals((Object)expected.isEmpty(), (Object)actual.isEmpty());
        }
    }

    @Test
    public void testMaxSize() {
        FastMap map = new FastMap(1, 1);
        map.put("foo", "bar");
        FastMapTest.assertEquals((long)1L, (long)map.size());
        map.put("baz", "bang");
        FastMapTest.assertEquals((long)1L, (long)map.size());
        FastMapTest.assertNull(map.get("foo"));
        map.put("baz", "buzz");
        FastMapTest.assertEquals((long)1L, (long)map.size());
        FastMapTest.assertEquals((Object)"buzz", map.get("baz"));
    }

    private static FastMap<String, String> buildTestFastMap() {
        FastMap map = new FastMap();
        map.put((Object)"foo", (Object)"bar");
        map.put((Object)"baz", (Object)"bang");
        map.put((Object)"alpha", (Object)"beta");
        return map;
    }
}

