/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.common;

import com.google.common.collect.Maps;
import java.util.HashMap;
import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.junit.Test;

public final class FastByIDMapTest
extends TasteTestCase {
    @Test
    public void testPutAndGet() {
        FastByIDMap map = new FastByIDMap();
        FastByIDMapTest.assertNull((Object)map.get(500000L));
        map.put(500000L, (Object)2L);
        FastByIDMapTest.assertEquals((long)2L, (long)((Long)map.get(500000L)));
    }

    @Test
    public void testRemove() {
        FastByIDMap map = new FastByIDMap();
        map.put(500000L, (Object)2L);
        map.remove(500000L);
        FastByIDMapTest.assertEquals((long)0L, (long)map.size());
        FastByIDMapTest.assertTrue((boolean)map.isEmpty());
        FastByIDMapTest.assertNull((Object)map.get(500000L));
    }

    @Test
    public void testClear() {
        FastByIDMap map = new FastByIDMap();
        map.put(500000L, (Object)2L);
        map.clear();
        FastByIDMapTest.assertEquals((long)0L, (long)map.size());
        FastByIDMapTest.assertTrue((boolean)map.isEmpty());
        FastByIDMapTest.assertNull((Object)map.get(500000L));
    }

    @Test
    public void testSizeEmpty() {
        FastByIDMap map = new FastByIDMap();
        FastByIDMapTest.assertEquals((long)0L, (long)map.size());
        FastByIDMapTest.assertTrue((boolean)map.isEmpty());
        map.put(500000L, (Object)2L);
        FastByIDMapTest.assertEquals((long)1L, (long)map.size());
        FastByIDMapTest.assertFalse((boolean)map.isEmpty());
        map.remove(500000L);
        FastByIDMapTest.assertEquals((long)0L, (long)map.size());
        FastByIDMapTest.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testContains() {
        FastByIDMap<String> map = FastByIDMapTest.buildTestFastMap();
        FastByIDMapTest.assertTrue((boolean)map.containsKey(500000L));
        FastByIDMapTest.assertTrue((boolean)map.containsKey(47L));
        FastByIDMapTest.assertTrue((boolean)map.containsKey(2L));
        FastByIDMapTest.assertTrue((boolean)map.containsValue((Object)"alpha"));
        FastByIDMapTest.assertTrue((boolean)map.containsValue((Object)"bang"));
        FastByIDMapTest.assertTrue((boolean)map.containsValue((Object)"beta"));
        FastByIDMapTest.assertFalse((boolean)map.containsKey(999L));
        FastByIDMapTest.assertFalse((boolean)map.containsValue((Object)"something"));
    }

    @Test
    public void testRehash() {
        FastByIDMap<String> map = FastByIDMapTest.buildTestFastMap();
        map.remove(500000L);
        map.rehash();
        FastByIDMapTest.assertNull((Object)map.get(500000L));
        FastByIDMapTest.assertEquals((Object)"bang", (Object)map.get(47L));
    }

    @Test
    public void testGrow() {
        FastByIDMap map = new FastByIDMap(1, 1);
        map.put(500000L, (Object)"alpha");
        map.put(47L, (Object)"bang");
        FastByIDMapTest.assertNull((Object)map.get(500000L));
        FastByIDMapTest.assertEquals((Object)"bang", (Object)map.get(47L));
    }

    @Test
    public void testVersusHashMap() {
        FastByIDMap actual = new FastByIDMap();
        HashMap expected = Maps.newHashMapWithExpectedSize((int)1000000);
        RandomWrapper r = RandomUtils.getRandom();
        for (int i = 0; i < 1000000; ++i) {
            double d = r.nextDouble();
            Long key = r.nextInt(100);
            if (d < 0.4) {
                FastByIDMapTest.assertEquals(expected.get(key), (Object)actual.get(key.longValue()));
                continue;
            }
            if (d < 0.7) {
                FastByIDMapTest.assertEquals((Object)expected.put(key, "bang"), (Object)actual.put(key.longValue(), (Object)"bang"));
            } else {
                FastByIDMapTest.assertEquals(expected.remove(key), (Object)actual.remove(key.longValue()));
            }
            FastByIDMapTest.assertEquals((long)expected.size(), (long)actual.size());
            FastByIDMapTest.assertEquals((Object)expected.isEmpty(), (Object)actual.isEmpty());
        }
    }

    @Test
    public void testMaxSize() {
        FastByIDMap map = new FastByIDMap();
        map.put(4L, (Object)"bang");
        FastByIDMapTest.assertEquals((long)1L, (long)map.size());
        map.put(47L, (Object)"bang");
        FastByIDMapTest.assertEquals((long)2L, (long)map.size());
        FastByIDMapTest.assertNull((Object)map.get(500000L));
        map.put(47L, (Object)"buzz");
        FastByIDMapTest.assertEquals((long)2L, (long)map.size());
        FastByIDMapTest.assertEquals((Object)"buzz", (Object)map.get(47L));
    }

    private static FastByIDMap<String> buildTestFastMap() {
        FastByIDMap map = new FastByIDMap();
        map.put(500000L, (Object)"alpha");
        map.put(47L, (Object)"bang");
        map.put(2L, (Object)"beta");
        return map;
    }
}

