/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.item;

import java.util.Arrays;
import java.util.Collections;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.cf.taste.hadoop.TasteHadoopUtils;
import org.apache.mahout.cf.taste.hadoop.item.ToUserVectorsReducer;
import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.math.VarLongWritable;
import org.apache.mahout.math.hadoop.MathHelper;
import org.easymock.EasyMock;
import org.junit.Test;

public class ToUserVectorsReducerTest
extends TasteTestCase {
    @Test
    public void testToUsersReducerMinPreferencesUserIgnored() throws Exception {
        Reducer.Context context = (Reducer.Context)EasyMock.createMock(Reducer.Context.class);
        ToUserVectorsReducer reducer = new ToUserVectorsReducer();
        ToUserVectorsReducerTest.setField(reducer, "minPreferences", 2);
        EasyMock.replay((Object[])new Object[]{context});
        reducer.reduce(new VarLongWritable(123L), Collections.singletonList(new VarLongWritable(456L)), context);
        EasyMock.verify((Object[])new Object[]{context});
    }

    @Test
    public void testToUsersReducerMinPreferencesUserPasses() throws Exception {
        Reducer.Context context = (Reducer.Context)EasyMock.createMock(Reducer.Context.class);
        Counter userCounters = (Counter)EasyMock.createMock(Counter.class);
        ToUserVectorsReducer reducer = new ToUserVectorsReducer();
        ToUserVectorsReducerTest.setField(reducer, "minPreferences", 2);
        EasyMock.expect((Object)context.getCounter((Enum)ToUserVectorsReducer.Counters.USERS)).andReturn((Object)userCounters);
        userCounters.increment(1L);
        context.write(EasyMock.eq((Object)new VarLongWritable(123L)), (Object)MathHelper.vectorMatches(MathHelper.elem(TasteHadoopUtils.idToIndex((long)456L), 1.0), MathHelper.elem(TasteHadoopUtils.idToIndex((long)789L), 1.0)));
        EasyMock.replay((Object[])new Object[]{context, userCounters});
        reducer.reduce(new VarLongWritable(123L), Arrays.asList(new VarLongWritable(456L), new VarLongWritable(789L)), context);
        EasyMock.verify((Object[])new Object[]{context, userCounters});
    }
}

