/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.item;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.cf.taste.hadoop.EntityPrefWritable;
import org.apache.mahout.cf.taste.hadoop.MutableRecommendedItem;
import org.apache.mahout.cf.taste.hadoop.RecommendedItemsWritable;
import org.apache.mahout.cf.taste.hadoop.TasteHadoopUtils;
import org.apache.mahout.cf.taste.hadoop.ToItemPrefsMapper;
import org.apache.mahout.cf.taste.hadoop.item.AggregateAndRecommendReducer;
import org.apache.mahout.cf.taste.hadoop.item.ItemFilterAsVectorAndPrefsReducer;
import org.apache.mahout.cf.taste.hadoop.item.ItemFilterMapper;
import org.apache.mahout.cf.taste.hadoop.item.ItemIDIndexMapper;
import org.apache.mahout.cf.taste.hadoop.item.ItemIDIndexReducer;
import org.apache.mahout.cf.taste.hadoop.item.PartialMultiplyMapper;
import org.apache.mahout.cf.taste.hadoop.item.PrefAndSimilarityColumnWritable;
import org.apache.mahout.cf.taste.hadoop.item.RecommenderJob;
import org.apache.mahout.cf.taste.hadoop.item.SimilarityMatrixRowWrapperMapper;
import org.apache.mahout.cf.taste.hadoop.item.ToUserVectorsReducer;
import org.apache.mahout.cf.taste.hadoop.item.ToVectorAndPrefReducer;
import org.apache.mahout.cf.taste.hadoop.item.UserVectorSplitterMapper;
import org.apache.mahout.cf.taste.hadoop.item.VectorAndPrefsWritable;
import org.apache.mahout.cf.taste.hadoop.item.VectorOrPrefWritable;
import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.recommender.GenericRecommendedItem;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.FileLineIterable;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.VarIntWritable;
import org.apache.mahout.math.VarLongWritable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.MathHelper;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.measures.CooccurrenceCountSimilarity;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.measures.TanimotoCoefficientSimilarity;
import org.apache.mahout.math.map.OpenIntLongHashMap;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.junit.Test;

public class RecommenderJobTest
extends TasteTestCase {
    @Test
    public void testItemIDIndexMapper() throws Exception {
        Mapper.Context context = (Mapper.Context)EasyMock.createMock(Mapper.Context.class);
        context.write((Object)new VarIntWritable(TasteHadoopUtils.idToIndex((long)789L)), (Object)new VarLongWritable(789L));
        EasyMock.replay((Object[])new Object[]{context});
        new ItemIDIndexMapper().map(new LongWritable(123L), new Text("456,789,5.0"), context);
        EasyMock.verify((Object[])new Object[]{context});
    }

    @Test
    public void testItemIDIndexReducer() throws Exception {
        Reducer.Context context = (Reducer.Context)EasyMock.createMock(Reducer.Context.class);
        context.write((Object)new VarIntWritable(123), (Object)new VarLongWritable(45L));
        EasyMock.replay((Object[])new Object[]{context});
        new ItemIDIndexReducer().reduce(new VarIntWritable(123), Arrays.asList(new VarLongWritable(67L), new VarLongWritable(89L), new VarLongWritable(45L)), context);
        EasyMock.verify((Object[])new Object[]{context});
    }

    @Test
    public void testToItemPrefsMapper() throws Exception {
        Mapper.Context context = (Mapper.Context)EasyMock.createMock(Mapper.Context.class);
        context.write((Object)new VarLongWritable(12L), (Object)new EntityPrefWritable(34L, 1.0f));
        context.write((Object)new VarLongWritable(56L), (Object)new EntityPrefWritable(78L, 2.0f));
        EasyMock.replay((Object[])new Object[]{context});
        ToItemPrefsMapper mapper = new ToItemPrefsMapper();
        mapper.map(new LongWritable(123L), new Text("12,34,1"), context);
        mapper.map(new LongWritable(456L), new Text("56,78,2"), context);
        EasyMock.verify((Object[])new Object[]{context});
    }

    @Test
    public void testToItemPrefsMapperBooleanData() throws Exception {
        Mapper.Context context = (Mapper.Context)EasyMock.createMock(Mapper.Context.class);
        context.write((Object)new VarLongWritable(12L), (Object)new VarLongWritable(34L));
        context.write((Object)new VarLongWritable(56L), (Object)new VarLongWritable(78L));
        EasyMock.replay((Object[])new Object[]{context});
        ToItemPrefsMapper mapper = new ToItemPrefsMapper();
        RecommenderJobTest.setField(mapper, "booleanData", true);
        mapper.map(new LongWritable(123L), new Text("12,34"), context);
        mapper.map(new LongWritable(456L), new Text("56,78"), context);
        EasyMock.verify((Object[])new Object[]{context});
    }

    @Test
    public void testToUserVectorReducer() throws Exception {
        Reducer.Context context = (Reducer.Context)EasyMock.createMock(Reducer.Context.class);
        Counter userCounters = (Counter)EasyMock.createMock(Counter.class);
        EasyMock.expect((Object)context.getCounter((Enum)ToUserVectorsReducer.Counters.USERS)).andReturn((Object)userCounters);
        userCounters.increment(1L);
        context.write(EasyMock.eq((Object)new VarLongWritable(12L)), (Object)MathHelper.vectorMatches(MathHelper.elem(TasteHadoopUtils.idToIndex((long)34L), 1.0), MathHelper.elem(TasteHadoopUtils.idToIndex((long)56L), 2.0)));
        EasyMock.replay((Object[])new Object[]{context, userCounters});
        LinkedList varLongWritables = Lists.newLinkedList();
        varLongWritables.add(new EntityPrefWritable(34L, 1.0f));
        varLongWritables.add(new EntityPrefWritable(56L, 2.0f));
        new ToUserVectorsReducer().reduce(new VarLongWritable(12L), (Iterable)varLongWritables, context);
        EasyMock.verify((Object[])new Object[]{context, userCounters});
    }

    @Test
    public void testToUserVectorReducerWithBooleanData() throws Exception {
        Reducer.Context context = (Reducer.Context)EasyMock.createMock(Reducer.Context.class);
        Counter userCounters = (Counter)EasyMock.createMock(Counter.class);
        EasyMock.expect((Object)context.getCounter((Enum)ToUserVectorsReducer.Counters.USERS)).andReturn((Object)userCounters);
        userCounters.increment(1L);
        context.write(EasyMock.eq((Object)new VarLongWritable(12L)), (Object)MathHelper.vectorMatches(MathHelper.elem(TasteHadoopUtils.idToIndex((long)34L), 1.0), MathHelper.elem(TasteHadoopUtils.idToIndex((long)56L), 1.0)));
        EasyMock.replay((Object[])new Object[]{context, userCounters});
        new ToUserVectorsReducer().reduce(new VarLongWritable(12L), Arrays.asList(new VarLongWritable(34L), new VarLongWritable(56L)), context);
        EasyMock.verify((Object[])new Object[]{context, userCounters});
    }

    @Test
    public void testSimilarityMatrixRowWrapperMapper() throws Exception {
        Mapper.Context context = (Mapper.Context)EasyMock.createMock(Mapper.Context.class);
        context.write(EasyMock.eq((Object)new VarIntWritable(12)), (Object)RecommenderJobTest.vectorOfVectorOrPrefWritableMatches(MathHelper.elem(34, 0.5), MathHelper.elem(56, 0.7)));
        EasyMock.replay((Object[])new Object[]{context});
        RandomAccessSparseVector vector = new RandomAccessSparseVector(Integer.MAX_VALUE, 100);
        vector.set(12, 1.0);
        vector.set(34, 0.5);
        vector.set(56, 0.7);
        new SimilarityMatrixRowWrapperMapper().map(new IntWritable(12), new VectorWritable((Vector)vector), context);
        EasyMock.verify((Object[])new Object[]{context});
    }

    private static VectorOrPrefWritable vectorOfVectorOrPrefWritableMatches(final Vector.Element ... elements) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public boolean matches(Object argument) {
                if (argument instanceof VectorOrPrefWritable) {
                    Vector v = ((VectorOrPrefWritable)argument).getVector();
                    return MathHelper.consistsOf(v, elements);
                }
                return false;
            }

            public void appendTo(StringBuffer buffer) {
            }
        });
        return null;
    }

    @Test
    public void testUserVectorSplitterMapper() throws Exception {
        Mapper.Context context = (Mapper.Context)EasyMock.createMock(Mapper.Context.class);
        context.write(EasyMock.eq((Object)new VarIntWritable(34)), (Object)RecommenderJobTest.prefOfVectorOrPrefWritableMatches(123L, 0.5f));
        context.write(EasyMock.eq((Object)new VarIntWritable(56)), (Object)RecommenderJobTest.prefOfVectorOrPrefWritableMatches(123L, 0.7f));
        EasyMock.replay((Object[])new Object[]{context});
        UserVectorSplitterMapper mapper = new UserVectorSplitterMapper();
        RecommenderJobTest.setField(mapper, "maxPrefsPerUserConsidered", 10);
        RandomAccessSparseVector vector = new RandomAccessSparseVector(Integer.MAX_VALUE, 100);
        vector.set(34, 0.5);
        vector.set(56, 0.7);
        mapper.map(new VarLongWritable(123L), new VectorWritable((Vector)vector), context);
        EasyMock.verify((Object[])new Object[]{context});
    }

    private static VectorOrPrefWritable prefOfVectorOrPrefWritableMatches(final long userID, final float prefValue) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public boolean matches(Object argument) {
                if (argument instanceof VectorOrPrefWritable) {
                    VectorOrPrefWritable pref = (VectorOrPrefWritable)argument;
                    return pref.getUserID() == userID && pref.getValue() == prefValue;
                }
                return false;
            }

            public void appendTo(StringBuffer buffer) {
            }
        });
        return null;
    }

    @Test
    public void testUserVectorSplitterMapperUserExclusion() throws Exception {
        Mapper.Context context = (Mapper.Context)EasyMock.createMock(Mapper.Context.class);
        context.write(EasyMock.eq((Object)new VarIntWritable(34)), (Object)RecommenderJobTest.prefOfVectorOrPrefWritableMatches(123L, 0.5f));
        context.write(EasyMock.eq((Object)new VarIntWritable(56)), (Object)RecommenderJobTest.prefOfVectorOrPrefWritableMatches(123L, 0.7f));
        EasyMock.replay((Object[])new Object[]{context});
        FastIDSet usersToRecommendFor = new FastIDSet();
        usersToRecommendFor.add(123L);
        UserVectorSplitterMapper mapper = new UserVectorSplitterMapper();
        RecommenderJobTest.setField(mapper, "maxPrefsPerUserConsidered", 10);
        RecommenderJobTest.setField(mapper, "usersToRecommendFor", usersToRecommendFor);
        RandomAccessSparseVector vector = new RandomAccessSparseVector(Integer.MAX_VALUE, 100);
        vector.set(34, 0.5);
        vector.set(56, 0.7);
        mapper.map(new VarLongWritable(123L), new VectorWritable((Vector)vector), context);
        mapper.map(new VarLongWritable(456L), new VectorWritable((Vector)vector), context);
        EasyMock.verify((Object[])new Object[]{context});
    }

    @Test
    public void testUserVectorSplitterMapperOnlySomePrefsConsidered() throws Exception {
        Mapper.Context context = (Mapper.Context)EasyMock.createMock(Mapper.Context.class);
        context.write(EasyMock.eq((Object)new VarIntWritable(34)), (Object)RecommenderJobTest.prefOfVectorOrPrefWritableMatchesNaN(123L));
        context.write(EasyMock.eq((Object)new VarIntWritable(56)), (Object)RecommenderJobTest.prefOfVectorOrPrefWritableMatches(123L, 0.7f));
        EasyMock.replay((Object[])new Object[]{context});
        UserVectorSplitterMapper mapper = new UserVectorSplitterMapper();
        RecommenderJobTest.setField(mapper, "maxPrefsPerUserConsidered", 1);
        RandomAccessSparseVector vector = new RandomAccessSparseVector(Integer.MAX_VALUE, 100);
        vector.set(34, 0.5);
        vector.set(56, 0.7);
        mapper.map(new VarLongWritable(123L), new VectorWritable((Vector)vector), context);
        EasyMock.verify((Object[])new Object[]{context});
    }

    private static VectorOrPrefWritable prefOfVectorOrPrefWritableMatchesNaN(final long userID) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public boolean matches(Object argument) {
                if (argument instanceof VectorOrPrefWritable) {
                    VectorOrPrefWritable pref = (VectorOrPrefWritable)argument;
                    return pref.getUserID() == userID && Float.isNaN(pref.getValue());
                }
                return false;
            }

            public void appendTo(StringBuffer buffer) {
            }
        });
        return null;
    }

    @Test
    public void testToVectorAndPrefReducer() throws Exception {
        Reducer.Context context = (Reducer.Context)EasyMock.createMock(Reducer.Context.class);
        context.write(EasyMock.eq((Object)new VarIntWritable(1)), (Object)RecommenderJobTest.vectorAndPrefsWritableMatches(Arrays.asList(123L, 456L), Arrays.asList(Float.valueOf(1.0f), Float.valueOf(2.0f)), MathHelper.elem(3, 0.5), MathHelper.elem(7, 0.8)));
        EasyMock.replay((Object[])new Object[]{context});
        RandomAccessSparseVector similarityColumn = new RandomAccessSparseVector(Integer.MAX_VALUE, 100);
        similarityColumn.set(3, 0.5);
        similarityColumn.set(7, 0.8);
        VectorOrPrefWritable itemPref1 = new VectorOrPrefWritable(123L, 1.0f);
        VectorOrPrefWritable itemPref2 = new VectorOrPrefWritable(456L, 2.0f);
        VectorOrPrefWritable similarities = new VectorOrPrefWritable((Vector)similarityColumn);
        new ToVectorAndPrefReducer().reduce(new VarIntWritable(1), Arrays.asList(itemPref1, itemPref2, similarities), context);
        EasyMock.verify((Object[])new Object[]{context});
    }

    private static VectorAndPrefsWritable vectorAndPrefsWritableMatches(final List<Long> userIDs, final List<Float> prefValues, final Vector.Element ... elements) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public boolean matches(Object argument) {
                if (argument instanceof VectorAndPrefsWritable) {
                    VectorAndPrefsWritable vectorAndPrefs = (VectorAndPrefsWritable)argument;
                    if (!vectorAndPrefs.getUserIDs().equals(userIDs)) {
                        return false;
                    }
                    if (!vectorAndPrefs.getValues().equals(prefValues)) {
                        return false;
                    }
                    return MathHelper.consistsOf(vectorAndPrefs.getVector(), elements);
                }
                return false;
            }

            public void appendTo(StringBuffer buffer) {
            }
        });
        return null;
    }

    @Test
    public void testToVectorAndPrefReducerExceptionOn2Vectors() throws Exception {
        Reducer.Context context = (Reducer.Context)EasyMock.createMock(Reducer.Context.class);
        EasyMock.replay((Object[])new Object[]{context});
        RandomAccessSparseVector similarityColumn1 = new RandomAccessSparseVector(Integer.MAX_VALUE, 100);
        RandomAccessSparseVector similarityColumn2 = new RandomAccessSparseVector(Integer.MAX_VALUE, 100);
        VectorOrPrefWritable similarities1 = new VectorOrPrefWritable((Vector)similarityColumn1);
        VectorOrPrefWritable similarities2 = new VectorOrPrefWritable((Vector)similarityColumn2);
        try {
            new ToVectorAndPrefReducer().reduce(new VarIntWritable(1), Arrays.asList(similarities1, similarities2), context);
            RecommenderJobTest.fail();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{context});
    }

    @Test
    public void testItemFilterMapper() throws Exception {
        Mapper.Context context = (Mapper.Context)EasyMock.createMock(Mapper.Context.class);
        context.write((Object)new VarLongWritable(34L), (Object)new VarLongWritable(12L));
        context.write((Object)new VarLongWritable(78L), (Object)new VarLongWritable(56L));
        EasyMock.replay((Object[])new Object[]{context});
        ItemFilterMapper mapper = new ItemFilterMapper();
        mapper.map(null, new Text("12,34"), context);
        mapper.map(null, new Text("56,78"), context);
        EasyMock.verify((Object[])new Object[]{context});
    }

    @Test
    public void testItemFilterAsVectorAndPrefsReducer() throws Exception {
        Reducer.Context context = (Reducer.Context)EasyMock.createMock(Reducer.Context.class);
        int itemIDIndex = TasteHadoopUtils.idToIndex((long)123L);
        context.write(EasyMock.eq((Object)new VarIntWritable(itemIDIndex)), (Object)RecommenderJobTest.vectorAndPrefsForFilteringMatches(123L, 456L, 789L));
        EasyMock.replay((Object[])new Object[]{context});
        new ItemFilterAsVectorAndPrefsReducer().reduce(new VarLongWritable(123L), Arrays.asList(new VarLongWritable(456L), new VarLongWritable(789L)), context);
        EasyMock.verify((Object[])new Object[]{context});
    }

    static VectorAndPrefsWritable vectorAndPrefsForFilteringMatches(final long itemID, final long ... userIDs) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public boolean matches(Object argument) {
                if (argument instanceof VectorAndPrefsWritable) {
                    VectorAndPrefsWritable vectorAndPrefs = (VectorAndPrefsWritable)argument;
                    Vector vector = vectorAndPrefs.getVector();
                    if (vector.getNumNondefaultElements() != 1) {
                        return false;
                    }
                    if (!Double.isNaN(vector.get(TasteHadoopUtils.idToIndex((long)itemID)))) {
                        return false;
                    }
                    if (userIDs.length != vectorAndPrefs.getUserIDs().size()) {
                        return false;
                    }
                    for (long userID : userIDs) {
                        if (vectorAndPrefs.getUserIDs().contains(userID)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }

            public void appendTo(StringBuffer buffer) {
            }
        });
        return null;
    }

    @Test
    public void testPartialMultiplyMapper() throws Exception {
        RandomAccessSparseVector similarityColumn = new RandomAccessSparseVector(Integer.MAX_VALUE, 100);
        similarityColumn.set(3, 0.5);
        similarityColumn.set(7, 0.8);
        Mapper.Context context = (Mapper.Context)EasyMock.createMock(Mapper.Context.class);
        PrefAndSimilarityColumnWritable one = new PrefAndSimilarityColumnWritable();
        PrefAndSimilarityColumnWritable two = new PrefAndSimilarityColumnWritable();
        one.set(1.0f, (Vector)similarityColumn);
        two.set(3.0f, (Vector)similarityColumn);
        context.write(EasyMock.eq((Object)new VarLongWritable(123L)), EasyMock.eq((Object)one));
        context.write(EasyMock.eq((Object)new VarLongWritable(456L)), EasyMock.eq((Object)two));
        EasyMock.replay((Object[])new Object[]{context});
        VectorAndPrefsWritable vectorAndPrefs = new VectorAndPrefsWritable((Vector)similarityColumn, Arrays.asList(123L, 456L), Arrays.asList(Float.valueOf(1.0f), Float.valueOf(3.0f)));
        new PartialMultiplyMapper().map(new VarIntWritable(1), vectorAndPrefs, context);
        EasyMock.verify((Object[])new Object[]{context});
    }

    @Test
    public void testAggregateAndRecommendReducer() throws Exception {
        Reducer.Context context = (Reducer.Context)EasyMock.createMock(Reducer.Context.class);
        context.write(EasyMock.eq((Object)new VarLongWritable(123L)), (Object)RecommenderJobTest.recommendationsMatch(new RecommendedItem[]{new MutableRecommendedItem(1L, 2.8f), new MutableRecommendedItem(2L, 2.0f)}));
        EasyMock.replay((Object[])new Object[]{context});
        RandomAccessSparseVector similarityColumnOne = new RandomAccessSparseVector(Integer.MAX_VALUE, 100);
        similarityColumnOne.set(1, 0.1);
        similarityColumnOne.set(2, 0.5);
        RandomAccessSparseVector similarityColumnTwo = new RandomAccessSparseVector(Integer.MAX_VALUE, 100);
        similarityColumnTwo.set(1, 0.9);
        similarityColumnTwo.set(2, 0.5);
        List<PrefAndSimilarityColumnWritable> values = Arrays.asList(new PrefAndSimilarityColumnWritable(1.0f, (Vector)similarityColumnOne), new PrefAndSimilarityColumnWritable(3.0f, (Vector)similarityColumnTwo));
        OpenIntLongHashMap indexItemIDMap = new OpenIntLongHashMap();
        indexItemIDMap.put(1, 1L);
        indexItemIDMap.put(2, 2L);
        AggregateAndRecommendReducer reducer = new AggregateAndRecommendReducer();
        RecommenderJobTest.setField(reducer, "indexItemIDMap", indexItemIDMap);
        RecommenderJobTest.setField(reducer, "recommendationsPerUser", 3);
        reducer.reduce(new VarLongWritable(123L), values, context);
        EasyMock.verify((Object[])new Object[]{context});
    }

    @Test
    public void testAggregateAndRecommendReducerExcludeRecommendationsBasedOnOneItem() throws Exception {
        Reducer.Context context = (Reducer.Context)EasyMock.createMock(Reducer.Context.class);
        context.write(EasyMock.eq((Object)new VarLongWritable(123L)), (Object)RecommenderJobTest.recommendationsMatch(new RecommendedItem[]{new MutableRecommendedItem(1L, 2.8f)}));
        EasyMock.replay((Object[])new Object[]{context});
        RandomAccessSparseVector similarityColumnOne = new RandomAccessSparseVector(Integer.MAX_VALUE, 100);
        similarityColumnOne.set(1, 0.1);
        RandomAccessSparseVector similarityColumnTwo = new RandomAccessSparseVector(Integer.MAX_VALUE, 100);
        similarityColumnTwo.set(1, 0.9);
        similarityColumnTwo.set(2, 0.5);
        List<PrefAndSimilarityColumnWritable> values = Arrays.asList(new PrefAndSimilarityColumnWritable(1.0f, (Vector)similarityColumnOne), new PrefAndSimilarityColumnWritable(3.0f, (Vector)similarityColumnTwo));
        OpenIntLongHashMap indexItemIDMap = new OpenIntLongHashMap();
        indexItemIDMap.put(1, 1L);
        indexItemIDMap.put(2, 2L);
        AggregateAndRecommendReducer reducer = new AggregateAndRecommendReducer();
        RecommenderJobTest.setField(reducer, "indexItemIDMap", indexItemIDMap);
        RecommenderJobTest.setField(reducer, "recommendationsPerUser", 3);
        reducer.reduce(new VarLongWritable(123L), values, context);
        EasyMock.verify((Object[])new Object[]{context});
    }

    @Test
    public void testAggregateAndRecommendReducerLimitNumberOfRecommendations() throws Exception {
        Reducer.Context context = (Reducer.Context)EasyMock.createMock(Reducer.Context.class);
        context.write(EasyMock.eq((Object)new VarLongWritable(123L)), (Object)RecommenderJobTest.recommendationsMatch(new RecommendedItem[]{new MutableRecommendedItem(1L, 2.8f)}));
        EasyMock.replay((Object[])new Object[]{context});
        RandomAccessSparseVector similarityColumnOne = new RandomAccessSparseVector(Integer.MAX_VALUE, 100);
        similarityColumnOne.set(1, 0.1);
        similarityColumnOne.set(2, 0.5);
        RandomAccessSparseVector similarityColumnTwo = new RandomAccessSparseVector(Integer.MAX_VALUE, 100);
        similarityColumnTwo.set(1, 0.9);
        similarityColumnTwo.set(2, 0.5);
        List<PrefAndSimilarityColumnWritable> values = Arrays.asList(new PrefAndSimilarityColumnWritable(1.0f, (Vector)similarityColumnOne), new PrefAndSimilarityColumnWritable(3.0f, (Vector)similarityColumnTwo));
        OpenIntLongHashMap indexItemIDMap = new OpenIntLongHashMap();
        indexItemIDMap.put(1, 1L);
        indexItemIDMap.put(2, 2L);
        AggregateAndRecommendReducer reducer = new AggregateAndRecommendReducer();
        RecommenderJobTest.setField(reducer, "indexItemIDMap", indexItemIDMap);
        RecommenderJobTest.setField(reducer, "recommendationsPerUser", 1);
        reducer.reduce(new VarLongWritable(123L), values, context);
        EasyMock.verify((Object[])new Object[]{context});
    }

    static RecommendedItemsWritable recommendationsMatch(final RecommendedItem ... items) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public boolean matches(Object argument) {
                if (argument instanceof RecommendedItemsWritable) {
                    RecommendedItemsWritable recommendedItemsWritable = (RecommendedItemsWritable)argument;
                    List<RecommendedItem> expectedItems = Arrays.asList(items);
                    return expectedItems.equals(recommendedItemsWritable.getRecommendedItems());
                }
                return false;
            }

            public void appendTo(StringBuffer buffer) {
            }
        });
        return null;
    }

    @Test
    public void testCompleteJob() throws Exception {
        File inputFile = this.getTestTempFile("prefs.txt");
        File outputDir = this.getTestTempDir("output");
        outputDir.delete();
        File similaritiesOutputDir = this.getTestTempDir("outputSimilarities");
        similaritiesOutputDir.delete();
        File tmpDir = this.getTestTempDir("tmp");
        RecommenderJobTest.writeLines(inputFile, "1,1,5", "1,2,5", "1,3,2", "2,1,2", "2,3,3", "2,4,5", "3,2,5", "3,4,3", "4,1,3", "4,4,5");
        RecommenderJob recommenderJob = new RecommenderJob();
        Configuration conf = this.getConfiguration();
        conf.set("mapred.input.dir", inputFile.getAbsolutePath());
        conf.set("mapred.output.dir", outputDir.getAbsolutePath());
        conf.setBoolean("mapred.output.compress", false);
        recommenderJob.setConf(conf);
        recommenderJob.run(new String[]{"--tempDir", tmpDir.getAbsolutePath(), "--similarityClassname", TanimotoCoefficientSimilarity.class.getName(), "--numRecommendations", "4", "--outputPathForSimilarityMatrix", similaritiesOutputDir.getAbsolutePath()});
        Map<Long, List<RecommendedItem>> recommendations = RecommenderJobTest.readRecommendations(new File(outputDir, "part-r-00000"));
        RecommenderJobTest.assertEquals((long)4L, (long)recommendations.size());
        for (Map.Entry<Long, List<RecommendedItem>> entry : recommendations.entrySet()) {
            RecommendedItem item2;
            long userID = entry.getKey();
            List<RecommendedItem> items = entry.getValue();
            RecommenderJobTest.assertNotNull(items);
            RecommendedItem item1 = items.get(0);
            if (userID == 1L) {
                RecommenderJobTest.assertEquals((long)1L, (long)items.size());
                RecommenderJobTest.assertEquals((long)4L, (long)item1.getItemID());
                RecommenderJobTest.assertEquals((double)4.3, (double)item1.getValue(), (double)0.05);
            }
            if (userID == 2L) {
                RecommenderJobTest.assertEquals((long)1L, (long)items.size());
                RecommenderJobTest.assertEquals((long)2L, (long)item1.getItemID());
                RecommenderJobTest.assertEquals((double)3.3, (double)item1.getValue(), (double)0.05);
            }
            if (userID == 3L) {
                RecommenderJobTest.assertEquals((long)2L, (long)items.size());
                RecommenderJobTest.assertEquals((long)3L, (long)item1.getItemID());
                RecommenderJobTest.assertEquals((double)4.1, (double)item1.getValue(), (double)0.05);
                item2 = items.get(1);
                RecommenderJobTest.assertEquals((long)1L, (long)item2.getItemID());
                RecommenderJobTest.assertEquals((double)3.7, (double)item2.getValue(), (double)0.05);
            }
            if (userID != 4L) continue;
            RecommenderJobTest.assertEquals((long)2L, (long)items.size());
            RecommenderJobTest.assertEquals((long)2L, (long)item1.getItemID());
            RecommenderJobTest.assertEquals((double)4.0, (double)item1.getValue(), (double)0.05);
            item2 = items.get(1);
            RecommenderJobTest.assertEquals((long)3L, (long)item2.getItemID());
            RecommenderJobTest.assertEquals((double)3.5, (double)item2.getValue(), (double)0.05);
        }
        Map<Pair<Long, Long>, Double> similarities = RecommenderJobTest.readSimilarities(new File(similaritiesOutputDir, "part-r-00000"));
        RecommenderJobTest.assertEquals((long)6L, (long)similarities.size());
        RecommenderJobTest.assertEquals((double)0.25, (double)similarities.get(new Pair((Object)1L, (Object)2L)), (double)1.0E-6);
        RecommenderJobTest.assertEquals((double)0.6666666666666666, (double)similarities.get(new Pair((Object)1L, (Object)3L)), (double)1.0E-6);
        RecommenderJobTest.assertEquals((double)0.5, (double)similarities.get(new Pair((Object)1L, (Object)4L)), (double)1.0E-6);
        RecommenderJobTest.assertEquals((double)0.3333333333333333, (double)similarities.get(new Pair((Object)2L, (Object)3L)), (double)1.0E-6);
        RecommenderJobTest.assertEquals((double)0.25, (double)similarities.get(new Pair((Object)2L, (Object)4L)), (double)1.0E-6);
        RecommenderJobTest.assertEquals((double)0.25, (double)similarities.get(new Pair((Object)3L, (Object)4L)), (double)1.0E-6);
    }

    @Test
    public void testCompleteJobBoolean() throws Exception {
        File inputFile = this.getTestTempFile("prefs.txt");
        File outputDir = this.getTestTempDir("output");
        outputDir.delete();
        File tmpDir = this.getTestTempDir("tmp");
        File usersFile = this.getTestTempFile("users.txt");
        RecommenderJobTest.writeLines(usersFile, "3");
        RecommenderJobTest.writeLines(inputFile, "1,1", "1,2", "1,3", "2,1", "2,3", "2,4", "3,2", "3,4", "4,1", "4,4");
        RecommenderJob recommenderJob = new RecommenderJob();
        Configuration conf = this.getConfiguration();
        conf.set("mapred.input.dir", inputFile.getAbsolutePath());
        conf.set("mapred.output.dir", outputDir.getAbsolutePath());
        conf.setBoolean("mapred.output.compress", false);
        recommenderJob.setConf(conf);
        recommenderJob.run(new String[]{"--tempDir", tmpDir.getAbsolutePath(), "--similarityClassname", CooccurrenceCountSimilarity.class.getName(), "--booleanData", "true", "--usersFile", usersFile.getAbsolutePath()});
        Map<Long, List<RecommendedItem>> recommendations = RecommenderJobTest.readRecommendations(new File(outputDir, "part-r-00000"));
        List<RecommendedItem> recommendedToCow = recommendations.get(3L);
        RecommenderJobTest.assertEquals((long)2L, (long)recommendedToCow.size());
        RecommendedItem item1 = recommendedToCow.get(0);
        RecommendedItem item2 = recommendedToCow.get(1);
        RecommenderJobTest.assertEquals((long)1L, (long)item1.getItemID());
        RecommenderJobTest.assertEquals((long)3L, (long)item2.getItemID());
        RecommenderJobTest.assertEquals((double)3.0, (double)item1.getValue(), (double)0.05);
        RecommenderJobTest.assertEquals((double)2.0, (double)item2.getValue(), (double)0.05);
    }

    @Test
    public void testCompleteJobWithFiltering() throws Exception {
        File inputFile = this.getTestTempFile("prefs.txt");
        File userFile = this.getTestTempFile("users.txt");
        File filterFile = this.getTestTempFile("filter.txt");
        File outputDir = this.getTestTempDir("output");
        outputDir.delete();
        File tmpDir = this.getTestTempDir("tmp");
        RecommenderJobTest.writeLines(inputFile, "1,1,5", "1,2,5", "1,3,2", "2,1,2", "2,3,3", "2,4,5", "3,2,5", "3,4,3", "4,1,3", "4,4,5");
        RecommenderJobTest.writeLines(userFile, "4");
        RecommenderJobTest.writeLines(filterFile, "4,2");
        RecommenderJob recommenderJob = new RecommenderJob();
        Configuration conf = this.getConfiguration();
        conf.set("mapred.input.dir", inputFile.getAbsolutePath());
        conf.set("mapred.output.dir", outputDir.getAbsolutePath());
        conf.setBoolean("mapred.output.compress", false);
        recommenderJob.setConf(conf);
        recommenderJob.run(new String[]{"--tempDir", tmpDir.getAbsolutePath(), "--similarityClassname", TanimotoCoefficientSimilarity.class.getName(), "--numRecommendations", "1", "--usersFile", userFile.getAbsolutePath(), "--filterFile", filterFile.getAbsolutePath()});
        Map<Long, List<RecommendedItem>> recommendations = RecommenderJobTest.readRecommendations(new File(outputDir, "part-r-00000"));
        RecommenderJobTest.assertEquals((long)1L, (long)recommendations.size());
        RecommenderJobTest.assertTrue((boolean)recommendations.containsKey(4L));
        RecommenderJobTest.assertEquals((long)1L, (long)recommendations.get(4L).size());
        RecommendedItem recommendedItem = recommendations.get(4L).get(0);
        RecommenderJobTest.assertEquals((long)3L, (long)recommendedItem.getItemID());
        RecommenderJobTest.assertEquals((double)3.5, (double)recommendedItem.getValue(), (double)0.05);
    }

    static Map<Pair<Long, Long>, Double> readSimilarities(File file) throws IOException {
        HashMap similarities = Maps.newHashMap();
        for (String line : new FileLineIterable(file)) {
            String[] parts = line.split("\t");
            similarities.put(new Pair((Object)Long.parseLong(parts[0]), (Object)Long.parseLong(parts[1])), Double.parseDouble(parts[2]));
        }
        return similarities;
    }

    static Map<Long, List<RecommendedItem>> readRecommendations(File file) throws IOException {
        HashMap recommendations = Maps.newHashMap();
        for (String line : new FileLineIterable(file)) {
            String[] keyValue = line.split("\t");
            long userID = Long.parseLong(keyValue[0]);
            String[] tokens = keyValue[1].replaceAll("\\[", "").replaceAll("\\]", "").split(",");
            LinkedList items = Lists.newLinkedList();
            for (String token : tokens) {
                String[] itemTokens = token.split(":");
                long itemID = Long.parseLong(itemTokens[0]);
                float value = Float.parseFloat(itemTokens[1]);
                items.add(new GenericRecommendedItem(itemID, value));
            }
            recommendations.put(userID, items);
        }
        return recommendations;
    }
}

