/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.stats;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.jet.random.AbstractContinousDistribution;
import org.apache.mahout.math.jet.random.Gamma;
import org.apache.mahout.math.jet.random.Normal;
import org.apache.mahout.math.jet.random.Uniform;
import org.apache.mahout.math.stats.TDigest;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TDigestTest {
    private static PrintWriter sizeDump;
    private static PrintWriter errorDump;
    private static PrintWriter deviationDump;

    @BeforeClass
    public static void setup() throws IOException {
        sizeDump = new PrintWriter(new FileWriter("sizes.csv"));
        sizeDump.printf("tag\ti\tq\tk\tactual\n", new Object[0]);
        errorDump = new PrintWriter(new FileWriter("errors.csv"));
        errorDump.printf("dist\ttag\tx\tQ\terror\n", new Object[0]);
        deviationDump = new PrintWriter(new FileWriter("deviation.csv"));
        deviationDump.printf("tag\tQ\tk\tx\tmean\tleft\tright\tdeviation\n", new Object[0]);
    }

    @AfterClass
    public static void teardown() {
        sizeDump.close();
        errorDump.close();
        deviationDump.close();
    }

    @After
    public void flush() {
        sizeDump.flush();
        errorDump.flush();
        deviationDump.flush();
    }

    @Test
    public void testUniform() {
        RandomWrapper gen = RandomUtils.getRandom();
        for (int i = 0; i < 5; ++i) {
            this.runTest((AbstractContinousDistribution)new Uniform(0.0, 1.0, (Random)gen), 100.0, new double[]{0.001, 0.01, 0.1, 0.5, 0.9, 0.99, 0.999}, "uniform", true);
        }
    }

    @Test
    public void testGamma() {
        RandomWrapper gen = RandomUtils.getRandom();
        for (int i = 0; i < 5; ++i) {
            this.runTest((AbstractContinousDistribution)new Gamma(0.1, 0.1, (Random)gen), 100.0, new double[]{0.001, 0.01, 0.1, 0.5, 0.9, 0.99, 0.999}, "gamma", true);
        }
    }

    @Test
    public void testNarrowNormal() {
        final RandomWrapper gen = RandomUtils.getRandom();
        AbstractContinousDistribution mix = new AbstractContinousDistribution(){
            AbstractContinousDistribution normal;
            AbstractContinousDistribution uniform;
            {
                this.normal = new Normal(0.0, 1.0E-5, (Random)gen);
                this.uniform = new Uniform(-1.0, 1.0, (Random)gen);
            }

            public double nextDouble() {
                double x = gen.nextDouble() < 0.5 ? this.uniform.nextDouble() : this.normal.nextDouble();
                return x;
            }
        };
        for (int i = 0; i < 5; ++i) {
            this.runTest(mix, 100.0, new double[]{0.001, 0.01, 0.1, 0.3, 0.5, 0.7, 0.9, 0.99, 0.999}, "mixture", false);
        }
    }

    @Test
    public void testRepeatedValues() {
        final RandomWrapper gen = RandomUtils.getRandom();
        AbstractContinousDistribution mix = new AbstractContinousDistribution(){

            public double nextDouble() {
                return Math.rint(gen.nextDouble() * 10.0) / 10.0;
            }
        };
        TDigest dist = new TDigest(1000.0);
        long t0 = System.nanoTime();
        HashMultiset data = HashMultiset.create();
        for (int i1 = 0; i1 < 100000; ++i1) {
            double x = mix.nextDouble();
            data.add((Object)x);
            dist.add(x);
        }
        System.out.printf("# %fus per point\n", (double)(System.nanoTime() - t0) * 0.001 / 100000.0);
        System.out.printf("# %d centroids\n", dist.centroidCount());
        Assert.assertTrue((String)"Summary is too large", ((double)dist.centroidCount() < 10000.0 ? 1 : 0) != 0);
        for (int i = 0; i < 10; ++i) {
            double z = (double)i / 10.0;
            for (double q = z + 0.002; q < z + 0.09; q += 0.005) {
                double cdf = dist.cdf(q);
                Assert.assertEquals((String)String.format("z=%.1f, q = %.3f, cdf = %.3f", z, q, cdf), (double)(z + 0.05), (double)cdf, (double)0.005);
                double estimate = dist.quantile(q);
                Assert.assertEquals((String)String.format("z=%.1f, q = %.3f, cdf = %.3f, estimate = %.3f", z, q, cdf, estimate), (double)(Math.rint(q * 10.0) / 10.0), (double)estimate, (double)0.001);
            }
        }
    }

    @Test
    public void testSequentialPoints() {
        for (int i = 0; i < 5; ++i) {
            this.runTest(new AbstractContinousDistribution(){
                double base = 0.0;

                public double nextDouble() {
                    this.base += 3.1415926535897935E-5;
                    return this.base;
                }
            }, 100.0, new double[]{0.001, 0.01, 0.1, 0.5, 0.9, 0.99, 0.999}, "sequential", true);
        }
    }

    @Test
    public void testSerialization() {
        RandomWrapper gen = RandomUtils.getRandom();
        TDigest dist = new TDigest(100.0);
        for (int i = 0; i < 100000; ++i) {
            double x = gen.nextDouble();
            dist.add(x);
        }
        dist.compress();
        ByteBuffer buf = ByteBuffer.allocate(20000);
        dist.asBytes(buf);
        Assert.assertTrue((buf.position() < 11000 ? 1 : 0) != 0);
        Assert.assertEquals((long)buf.position(), (long)dist.byteSize());
        buf.clear();
        dist.asSmallBytes(buf);
        Assert.assertTrue((buf.position() < 6000 ? 1 : 0) != 0);
        Assert.assertEquals((long)buf.position(), (long)dist.smallByteSize());
        System.out.printf("# big %d bytes\n", buf.position());
        buf.flip();
        TDigest dist2 = TDigest.fromBytes((ByteBuffer)buf);
        Assert.assertEquals((long)dist.centroidCount(), (long)dist2.centroidCount());
        Assert.assertEquals((double)dist.compression(), (double)dist2.compression(), (double)0.0);
        Assert.assertEquals((long)dist.size(), (long)dist2.size());
        for (double q = 0.0; q < 1.0; q += 0.01) {
            Assert.assertEquals((double)dist.quantile(q), (double)dist2.quantile(q), (double)1.0E-8);
        }
        Iterator ix = dist2.centroids().iterator();
        for (TDigest.Group group : dist.centroids()) {
            Assert.assertTrue((boolean)ix.hasNext());
            Assert.assertEquals((long)group.count(), (long)((TDigest.Group)ix.next()).count());
        }
        Assert.assertFalse((boolean)ix.hasNext());
        buf.flip();
        dist.asSmallBytes(buf);
        Assert.assertTrue((buf.position() < 6000 ? 1 : 0) != 0);
        System.out.printf("# small %d bytes\n", buf.position());
        buf.flip();
        dist2 = TDigest.fromBytes((ByteBuffer)buf);
        Assert.assertEquals((long)dist.centroidCount(), (long)dist2.centroidCount());
        Assert.assertEquals((double)dist.compression(), (double)dist2.compression(), (double)0.0);
        Assert.assertEquals((long)dist.size(), (long)dist2.size());
        for (double q = 0.0; q < 1.0; q += 0.01) {
            Assert.assertEquals((double)dist.quantile(q), (double)dist2.quantile(q), (double)1.0E-6);
        }
        ix = dist2.centroids().iterator();
        for (TDigest.Group group : dist.centroids()) {
            Assert.assertTrue((boolean)ix.hasNext());
            Assert.assertEquals((long)group.count(), (long)((TDigest.Group)ix.next()).count());
        }
        Assert.assertFalse((boolean)ix.hasNext());
    }

    @Test
    public void testIntEncoding() {
        int n;
        int i;
        RandomWrapper gen = RandomUtils.getRandom();
        ByteBuffer buf = ByteBuffer.allocate(10000);
        ArrayList ref = Lists.newArrayList();
        for (i = 0; i < 3000; ++i) {
            n = gen.nextInt();
            ref.add(n >>>= i / 100);
            TDigest.encode((ByteBuffer)buf, (int)n);
        }
        buf.flip();
        for (i = 0; i < 3000; ++i) {
            n = TDigest.decode((ByteBuffer)buf);
            Assert.assertEquals((String)String.format("%d:", i), (long)((Integer)ref.get(i)).intValue(), (long)n);
        }
    }

    public void testSizeControl() {
        RandomWrapper gen = RandomUtils.getRandom();
        System.out.printf("k\tsamples\tcompression\tsize1\tsize2\n", new Object[0]);
        for (int k = 0; k < 40; ++k) {
            for (int size : new int[]{10, 100, 1000, 10000}) {
                for (double compression : new double[]{2.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 500.0, 1000.0}) {
                    TDigest dist = new TDigest(compression);
                    for (int i = 0; i < size * 1000; ++i) {
                        dist.add(gen.nextDouble());
                    }
                    System.out.printf("%d\t%d\t%.0f\t%d\t%d\n", k, size, compression, dist.smallByteSize(), dist.byteSize());
                }
            }
        }
        System.out.printf("\n", new Object[0]);
    }

    @Test
    public void testScaling() {
        RandomWrapper gen = RandomUtils.getRandom();
        System.out.printf("pass\tcompression\tq\terror\tsize\n", new Object[0]);
        for (int k = 0; k < 3; ++k) {
            ArrayList data = Lists.newArrayList();
            for (int i = 0; i < 100000; ++i) {
                data.add(gen.nextDouble());
            }
            Collections.sort(data);
            for (double compression : new double[]{2.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 500.0, 1000.0}) {
                TDigest dist = new TDigest(compression);
                for (Double x : data) {
                    dist.add(x.doubleValue());
                }
                dist.compress();
                for (double q : new double[]{0.001, 0.01, 0.1, 0.5}) {
                    double estimate = dist.quantile(q);
                    double actual = (Double)data.get((int)(q * (double)data.size()));
                    System.out.printf("%d\t%.0f\t%.3f\t%.9f\t%d\n", k, compression, q, estimate - actual, dist.byteSize());
                }
            }
        }
    }

    private void runTest(AbstractContinousDistribution gen, double sizeGuide, double[] qValues, String tag, boolean recordAllData) {
        TDigest dist = new TDigest(sizeGuide);
        if (recordAllData) {
            dist.recordAllData();
        }
        long t0 = System.nanoTime();
        ArrayList data = Lists.newArrayList();
        for (int i = 0; i < 100000; ++i) {
            double x = gen.nextDouble();
            data.add(x);
            dist.add(x);
        }
        dist.compress();
        Collections.sort(data);
        double[] xValues = (double[])qValues.clone();
        for (int i = 0; i < qValues.length; ++i) {
            double ix = (double)data.size() * qValues[i] - 0.5;
            int index = (int)Math.floor(ix);
            double p = ix - (double)index;
            xValues[i] = (Double)data.get(index) * (1.0 - p) + (Double)data.get(index + 1) * p;
        }
        double qz = 0.0;
        int iz = 0;
        for (TDigest.Group group : dist.centroids()) {
            double q = (qz + (double)group.count() / 2.0) / (double)dist.size();
            sizeDump.printf("%s\t%d\t%.6f\t%.3f\t%d\n", tag, iz, q, 4.0 * q * (1.0 - q) * (double)dist.size() / dist.compression(), group.count());
            qz += (double)group.count();
            ++iz;
        }
        System.out.printf("# %fus per point\n", (double)(System.nanoTime() - t0) * 0.001 / 100000.0);
        System.out.printf("# %d centroids\n", dist.centroidCount());
        Assert.assertTrue((String)"Summary is too large", ((double)dist.centroidCount() < 10.0 * sizeGuide ? 1 : 0) != 0);
        for (int i = 0; i < xValues.length; ++i) {
            double x = xValues[i];
            double q = qValues[i];
            double estimate = dist.cdf(x);
            errorDump.printf("%s\t%s\t%.8g\t%.8f\t%.8f\n", tag, "cdf", x, q, estimate - q);
            Assert.assertEquals((double)q, (double)estimate, (double)0.006);
            estimate = this.cdf(dist.quantile(q), data);
            errorDump.printf("%s\t%s\t%.8g\t%.8f\t%.8f\n", tag, "quantile", x, q, estimate - q);
            Assert.assertEquals((double)q, (double)estimate, (double)0.006);
        }
        if (recordAllData) {
            Iterator ix = dist.centroids().iterator();
            TDigest.Group b = (TDigest.Group)ix.next();
            TDigest.Group c = (TDigest.Group)ix.next();
            qz = b.count();
            while (ix.hasNext()) {
                TDigest.Group a = b;
                b = c;
                c = (TDigest.Group)ix.next();
                double left = (b.mean() - a.mean()) / 2.0;
                double right = (c.mean() - b.mean()) / 2.0;
                double q = (qz + (double)b.count() / 2.0) / (double)dist.size();
                for (Double x : b.data()) {
                    deviationDump.printf("%s\t%.5f\t%d\t%.5g\t%.5g\t%.5g\t%.5g\t%.5f\n", tag, q, b.count(), x, b.mean(), left, right, (x - b.mean()) / (right + left));
                }
                qz += (double)a.count();
            }
        }
    }

    @Test
    public void testMerge() {
        RandomWrapper gen = RandomUtils.getRandom();
        for (int parts : new int[]{2, 5, 10, 20, 50, 100}) {
            double e2;
            double e1;
            double z;
            int i;
            ArrayList data = Lists.newArrayList();
            TDigest dist = new TDigest(100.0);
            dist.recordAllData();
            ArrayList many = Lists.newArrayList();
            for (int i2 = 0; i2 < 100; ++i2) {
                many.add(new TDigest(100.0).recordAllData());
            }
            ArrayList subs = Lists.newArrayList();
            for (i = 0; i < parts; ++i) {
                subs.add(new TDigest(50.0).recordAllData());
            }
            for (i = 0; i < 100000; ++i) {
                double x = gen.nextDouble();
                data.add(x);
                dist.add(x);
                ((TDigest)subs.get(i % parts)).add(x);
            }
            dist.compress();
            Collections.sort(data);
            ArrayList data2 = Lists.newArrayList();
            for (TDigest digest : subs) {
                for (TDigest.Group group : digest.centroids()) {
                    Iterables.addAll((Collection)data2, (Iterable)group.data());
                }
            }
            Collections.sort(data2);
            Assert.assertEquals((long)data.size(), (long)data2.size());
            Iterator ix = data.iterator();
            for (Double x : data2) {
                Assert.assertEquals(ix.next(), (Object)x);
            }
            TDigest dist2 = TDigest.merge((double)50.0, (Iterable)subs);
            for (double q : new double[]{0.001, 0.01, 0.1, 0.2, 0.3, 0.5}) {
                z = this.quantile(q, data);
                e1 = dist.quantile(q) - z;
                e2 = dist2.quantile(q) - z;
                System.out.printf("quantile\t%d\t%.6f\t%.6f\t%.6f\t%.6f\t%.6f\n", parts, q, z - q, e1, e2, Math.abs(e2) / q);
                Assert.assertTrue((String)String.format("parts=%d, q=%.4f, e1=%.5f, e2=%.5f, rel=%.4f", parts, q, e1, e2, Math.abs(e2) / q), (Math.abs(e2) / q < 0.1 && Math.abs(e2) < 0.01 ? 1 : 0) != 0);
            }
            for (double x : new double[]{0.001, 0.01, 0.1, 0.2, 0.3, 0.5}) {
                z = this.cdf(x, data);
                e1 = dist.cdf(x) - z;
                e2 = dist2.cdf(x) - z;
                System.out.printf("cdf\t%d\t%.6f\t%.6f\t%.6f\t%.6f\t%.6f\n", parts, x, z - x, e1, e2, Math.abs(e2) / x);
                Assert.assertTrue((String)String.format("parts=%d, x=%.4f, e1=%.5f, e2=%.5f", parts, x, e1, e2), (Math.abs(e2) / x < 0.1 && Math.abs(e2) < 0.01 ? 1 : 0) != 0);
            }
        }
    }

    private double cdf(double x, List<Double> data) {
        int n1 = 0;
        int n2 = 0;
        for (Double v : data) {
            n1 += v < x ? 1 : 0;
            n2 += v <= x ? 1 : 0;
        }
        return (double)(n1 + n2) / 2.0 / (double)data.size();
    }

    private double quantile(double q, List<Double> data) {
        return data.get((int)Math.floor((double)data.size() * q));
    }

    @Before
    public void setUp() {
        RandomUtils.useTestSeed();
    }
}

