/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.stats;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.stats.GroupTree;
import org.apache.mahout.math.stats.TDigest;
import org.junit.Assert;
import org.junit.Test;

public class GroupTreeTest {
    @Test
    public void testSimpleAdds() {
        GroupTree x = new GroupTree();
        Assert.assertNull((Object)x.floor(new TDigest.Group(34.0)));
        Assert.assertNull((Object)x.ceiling(new TDigest.Group(34.0)));
        Assert.assertEquals((long)0L, (long)x.size());
        Assert.assertEquals((long)0L, (long)x.sum());
        x.add(new TDigest.Group(1.0));
        TDigest.Group group = new TDigest.Group(2.0);
        group.add(3.0, 1);
        group.add(4.0, 1);
        x.add(group);
        Assert.assertEquals((long)2L, (long)x.size());
        Assert.assertEquals((long)4L, (long)x.sum());
    }

    @Test
    public void testBalancing() {
        GroupTree x = new GroupTree();
        for (int i = 0; i < 101; ++i) {
            x.add(new TDigest.Group((double)i));
        }
        Assert.assertEquals((long)101L, (long)x.sum());
        Assert.assertEquals((long)101L, (long)x.size());
        x.checkBalance();
    }

    @Test
    public void testIterators() {
        TDigest.Group v;
        int i;
        GroupTree x = new GroupTree();
        for (int i2 = 0; i2 < 101; ++i2) {
            x.add(new TDigest.Group((double)(i2 / 2)));
        }
        Assert.assertEquals((double)0.0, (double)x.first().mean(), (double)0.0);
        Assert.assertEquals((double)50.0, (double)x.last().mean(), (double)0.0);
        Iterator ix = x.iterator();
        for (int i3 = 0; i3 < 101; ++i3) {
            Assert.assertTrue((boolean)ix.hasNext());
            TDigest.Group z = (TDigest.Group)ix.next();
            Assert.assertEquals((double)(i3 / 2), (double)z.mean(), (double)0.0);
        }
        Assert.assertFalse((boolean)ix.hasNext());
        Iterable z = x.tailSet(new TDigest.Group(34.0, 0));
        ix = z.iterator();
        for (i = 68; i < 101; ++i) {
            Assert.assertTrue((boolean)ix.hasNext());
            v = (TDigest.Group)ix.next();
            Assert.assertEquals((double)(i / 2), (double)v.mean(), (double)0.0);
        }
        Assert.assertFalse((boolean)ix.hasNext());
        ix = z.iterator();
        for (i = 68; i < 101; ++i) {
            v = (TDigest.Group)ix.next();
            Assert.assertEquals((double)(i / 2), (double)v.mean(), (double)0.0);
        }
        z = x.tailSet(new TDigest.Group(33.0, 0));
        ix = z.iterator();
        for (i = 66; i < 101; ++i) {
            Assert.assertTrue((boolean)ix.hasNext());
            v = (TDigest.Group)ix.next();
            Assert.assertEquals((double)(i / 2), (double)v.mean(), (double)0.0);
        }
        Assert.assertFalse((boolean)ix.hasNext());
        z = x.tailSet(x.ceiling(new TDigest.Group(34.0, 0)));
        ix = z.iterator();
        for (i = 68; i < 101; ++i) {
            Assert.assertTrue((boolean)ix.hasNext());
            v = (TDigest.Group)ix.next();
            Assert.assertEquals((double)(i / 2), (double)v.mean(), (double)0.0);
        }
        Assert.assertFalse((boolean)ix.hasNext());
        z = x.tailSet(x.floor(new TDigest.Group(34.0, 0)));
        ix = z.iterator();
        for (i = 67; i < 101; ++i) {
            Assert.assertTrue((boolean)ix.hasNext());
            v = (TDigest.Group)ix.next();
            Assert.assertEquals((double)(i / 2), (double)v.mean(), (double)0.0);
        }
        Assert.assertFalse((boolean)ix.hasNext());
    }

    @Test
    public void testFloor() {
        GroupTree x = new GroupTree();
        for (int i = 0; i < 101; ++i) {
            x.add(new TDigest.Group((double)(i / 2)));
        }
        Assert.assertNull((Object)x.floor(new TDigest.Group(-30.0)));
    }

    @Test
    public void testRemoveAndSums() {
        GroupTree x = new GroupTree();
        for (int i = 0; i < 101; ++i) {
            x.add(new TDigest.Group((double)(i / 2)));
        }
        TDigest.Group g = x.ceiling(new TDigest.Group(2.0, 0));
        x.remove(g);
        g.add(3.0, 1);
        x.add(g);
        Assert.assertEquals((long)0L, (long)x.headCount(new TDigest.Group(-1.0)));
        Assert.assertEquals((long)0L, (long)x.headSum(new TDigest.Group(-1.0)));
        Assert.assertEquals((long)0L, (long)x.headCount(new TDigest.Group(0.0, 0)));
        Assert.assertEquals((long)0L, (long)x.headSum(new TDigest.Group(0.0, 0)));
        Assert.assertEquals((long)0L, (long)x.headCount(x.ceiling(new TDigest.Group(0.0, 0))));
        Assert.assertEquals((long)0L, (long)x.headSum(x.ceiling(new TDigest.Group(0.0, 0))));
        Assert.assertEquals((long)2L, (long)x.headCount(new TDigest.Group(1.0, 0)));
        Assert.assertEquals((long)2L, (long)x.headSum(new TDigest.Group(1.0, 0)));
        g = (TDigest.Group)x.tailSet(new TDigest.Group(2.1)).iterator().next();
        Assert.assertEquals((double)2.5, (double)g.mean(), (double)1.0E-9);
        int i = 0;
        for (TDigest.Group gx : x) {
            if (i > 10) break;
            System.out.printf("%d:%.1f(%d)\t", i++, gx.mean(), gx.count());
        }
        Assert.assertEquals((long)5L, (long)x.headCount(new TDigest.Group(2.1, 0)));
        Assert.assertEquals((long)5L, (long)x.headSum(new TDigest.Group(2.1, 0)));
        Assert.assertEquals((long)6L, (long)x.headCount(new TDigest.Group(2.7, 0)));
        Assert.assertEquals((long)7L, (long)x.headSum(new TDigest.Group(2.7, 0)));
        Assert.assertEquals((long)101L, (long)x.headCount(new TDigest.Group(200.0)));
        Assert.assertEquals((long)102L, (long)x.headSum(new TDigest.Group(200.0)));
    }

    @Test
    public void testRandomRebalance() {
        RandomUtils.useTestSeed();
        RandomWrapper gen = RandomUtils.getRandom();
        GroupTree x = new GroupTree();
        ArrayList y = Lists.newArrayList();
        for (int i = 0; i < 1000; ++i) {
            double v = gen.nextDouble();
            x.add(new TDigest.Group(v));
            y.add(v);
            x.checkBalance();
        }
        Collections.sort(y);
        Iterator i = y.iterator();
        for (TDigest.Group group : x) {
            Assert.assertEquals((double)((Double)i.next()), (double)group.mean(), (double)0.0);
        }
        for (int j = 0; j < 100; ++j) {
            double v = (Double)y.get(gen.nextInt(y.size()));
            y.remove(v);
            x.remove(x.floor(new TDigest.Group(v)));
        }
        Collections.sort(y);
        i = y.iterator();
        for (TDigest.Group group : x) {
            Assert.assertEquals((double)((Double)i.next()), (double)group.mean(), (double)0.0);
        }
        for (int j = 0; j < y.size(); ++j) {
            double v = (Double)y.get(j);
            y.set(j, v + 10.0);
            TDigest.Group g = x.floor(new TDigest.Group(v));
            x.remove(g);
            x.checkBalance();
            g.add(g.mean() + 20.0, 1);
            x.add(g);
            x.checkBalance();
        }
        i = y.iterator();
        for (TDigest.Group group : x) {
            Assert.assertEquals((double)((Double)i.next()), (double)group.mean(), (double)0.0);
        }
    }
}

