/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.randomized;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.annotations.Repeat;
import com.carrotsearch.randomizedtesting.annotations.Seed;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.mahout.math.map.OpenIntIntHashMap;
import org.apache.mahout.math.map.OpenIntObjectHashMap;
import org.apache.mahout.math.map.OpenObjectIntHashMap;
import org.apache.mahout.math.set.OpenHashSet;
import org.apache.mahout.math.set.OpenIntHashSet;
import org.junit.Test;

public class RandomBlasting
extends RandomizedTest {
    @Test
    @Repeat(iterations=20)
    public void testAgainstReferenceOpenObjectIntHashMap() {
        OpenObjectIntHashMap base = new OpenObjectIntHashMap();
        HashMap<Integer, Integer> reference = new HashMap<Integer, Integer>();
        ArrayList ops = Lists.newArrayList();
        RandomBlasting.addOp(ops, Operation.ADD, 60);
        RandomBlasting.addOp(ops, Operation.REMOVE, 30);
        RandomBlasting.addOp(ops, Operation.INDEXOF, 30);
        RandomBlasting.addOp(ops, Operation.CLEAR, 5);
        RandomBlasting.addOp(ops, Operation.ISEMPTY, 2);
        RandomBlasting.addOp(ops, Operation.SIZE, 2);
        int max = RandomBlasting.randomIntBetween((int)1000, (int)20000);
        block8: for (int reps = 0; reps < max; ++reps) {
            int k = RandomBlasting.randomIntBetween((int)0, (int)(max / 4));
            int v = RandomBlasting.randomInt();
            switch ((Operation)((Object)RandomBlasting.randomFrom((List)ops))) {
                case ADD: {
                    RandomBlasting.assertEquals((Object)(reference.put(k, v) == null ? 1 : 0), (Object)base.put((Object)k, v));
                    continue block8;
                }
                case REMOVE: {
                    RandomBlasting.assertEquals((Object)(reference.remove(k) != null ? 1 : 0), (Object)base.removeKey((Object)k));
                    continue block8;
                }
                case INDEXOF: {
                    RandomBlasting.assertEquals((Object)reference.containsKey(k), (Object)base.containsKey((Object)k));
                    continue block8;
                }
                case CLEAR: {
                    reference.clear();
                    base.clear();
                    continue block8;
                }
                case ISEMPTY: {
                    RandomBlasting.assertEquals((Object)reference.isEmpty(), (Object)base.isEmpty());
                    continue block8;
                }
                case SIZE: {
                    RandomBlasting.assertEquals((long)reference.size(), (long)base.size());
                    continue block8;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
    }

    @Test
    @Repeat(iterations=20)
    public void testAgainstReferenceOpenIntObjectHashMap() {
        OpenIntObjectHashMap base = new OpenIntObjectHashMap();
        HashMap<Integer, Integer> reference = new HashMap<Integer, Integer>();
        ArrayList ops = Lists.newArrayList();
        RandomBlasting.addOp(ops, Operation.ADD, 60);
        RandomBlasting.addOp(ops, Operation.REMOVE, 30);
        RandomBlasting.addOp(ops, Operation.INDEXOF, 30);
        RandomBlasting.addOp(ops, Operation.CLEAR, 5);
        RandomBlasting.addOp(ops, Operation.ISEMPTY, 2);
        RandomBlasting.addOp(ops, Operation.SIZE, 2);
        int max = RandomBlasting.randomIntBetween((int)1000, (int)20000);
        block8: for (int reps = 0; reps < max; ++reps) {
            int k = RandomBlasting.randomIntBetween((int)0, (int)(max / 4));
            int v = RandomBlasting.randomInt();
            switch ((Operation)((Object)RandomBlasting.randomFrom((List)ops))) {
                case ADD: {
                    RandomBlasting.assertEquals((Object)(reference.put(k, v) == null ? 1 : 0), (Object)base.put(k, (Object)v));
                    continue block8;
                }
                case REMOVE: {
                    RandomBlasting.assertEquals((Object)(reference.remove(k) != null ? 1 : 0), (Object)base.removeKey(k));
                    continue block8;
                }
                case INDEXOF: {
                    RandomBlasting.assertEquals((Object)reference.containsKey(k), (Object)base.containsKey(k));
                    continue block8;
                }
                case CLEAR: {
                    reference.clear();
                    base.clear();
                    continue block8;
                }
                case ISEMPTY: {
                    RandomBlasting.assertEquals((Object)reference.isEmpty(), (Object)base.isEmpty());
                    continue block8;
                }
                case SIZE: {
                    RandomBlasting.assertEquals((long)reference.size(), (long)base.size());
                    continue block8;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
    }

    @Test
    @Repeat(iterations=20)
    public void testAgainstReferenceOpenIntIntHashMap() {
        OpenIntIntHashMap base = new OpenIntIntHashMap();
        HashMap<Integer, Integer> reference = new HashMap<Integer, Integer>();
        ArrayList ops = Lists.newArrayList();
        RandomBlasting.addOp(ops, Operation.ADD, 60);
        RandomBlasting.addOp(ops, Operation.REMOVE, 30);
        RandomBlasting.addOp(ops, Operation.INDEXOF, 30);
        RandomBlasting.addOp(ops, Operation.CLEAR, 5);
        RandomBlasting.addOp(ops, Operation.ISEMPTY, 2);
        RandomBlasting.addOp(ops, Operation.SIZE, 2);
        int max = RandomBlasting.randomIntBetween((int)1000, (int)20000);
        block8: for (int reps = 0; reps < max; ++reps) {
            int k = RandomBlasting.randomIntBetween((int)0, (int)(max / 4));
            int v = RandomBlasting.randomInt();
            switch ((Operation)((Object)RandomBlasting.randomFrom((List)ops))) {
                case ADD: {
                    Integer prevValue = reference.put(k, v);
                    if (prevValue == null) {
                        RandomBlasting.assertEquals((Object)true, (Object)base.put(k, v));
                        continue block8;
                    }
                    RandomBlasting.assertEquals((long)prevValue.intValue(), (long)base.get(k));
                    RandomBlasting.assertEquals((Object)false, (Object)base.put(k, v));
                    continue block8;
                }
                case REMOVE: {
                    RandomBlasting.assertEquals((Object)reference.containsKey(k), (Object)base.containsKey(k));
                    Integer removed = (Integer)reference.remove(k);
                    if (removed == null) {
                        RandomBlasting.assertEquals((Object)false, (Object)base.removeKey(k));
                        continue block8;
                    }
                    RandomBlasting.assertEquals((long)removed.intValue(), (long)base.get(k));
                    RandomBlasting.assertEquals((Object)true, (Object)base.removeKey(k));
                    continue block8;
                }
                case INDEXOF: {
                    RandomBlasting.assertEquals((Object)reference.containsKey(k), (Object)base.containsKey(k));
                    continue block8;
                }
                case CLEAR: {
                    reference.clear();
                    base.clear();
                    continue block8;
                }
                case ISEMPTY: {
                    RandomBlasting.assertEquals((Object)reference.isEmpty(), (Object)base.isEmpty());
                    continue block8;
                }
                case SIZE: {
                    RandomBlasting.assertEquals((long)reference.size(), (long)base.size());
                    continue block8;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
    }

    @Test
    @Repeat(iterations=20)
    public void testAgainstReferenceOpenIntHashSet() {
        OpenIntHashSet base = new OpenIntHashSet();
        HashSet reference = Sets.newHashSet();
        ArrayList ops = Lists.newArrayList();
        RandomBlasting.addOp(ops, Operation.ADD, 60);
        RandomBlasting.addOp(ops, Operation.REMOVE, 30);
        RandomBlasting.addOp(ops, Operation.INDEXOF, 30);
        RandomBlasting.addOp(ops, Operation.CLEAR, 5);
        RandomBlasting.addOp(ops, Operation.ISEMPTY, 2);
        RandomBlasting.addOp(ops, Operation.SIZE, 2);
        int max = RandomBlasting.randomIntBetween((int)1000, (int)20000);
        block8: for (int reps = 0; reps < max; ++reps) {
            int k = RandomBlasting.randomIntBetween((int)0, (int)(max / 4));
            switch ((Operation)((Object)RandomBlasting.randomFrom((List)ops))) {
                case ADD: {
                    RandomBlasting.assertEquals((Object)reference.add(k), (Object)base.add(k));
                    continue block8;
                }
                case REMOVE: {
                    RandomBlasting.assertEquals((Object)reference.remove(k), (Object)base.remove(k));
                    continue block8;
                }
                case INDEXOF: {
                    RandomBlasting.assertEquals((Object)reference.contains(k), (Object)base.contains(k));
                    continue block8;
                }
                case CLEAR: {
                    reference.clear();
                    base.clear();
                    continue block8;
                }
                case ISEMPTY: {
                    RandomBlasting.assertEquals((Object)reference.isEmpty(), (Object)base.isEmpty());
                    continue block8;
                }
                case SIZE: {
                    RandomBlasting.assertEquals((long)reference.size(), (long)base.size());
                    continue block8;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
    }

    @Seed(value="deadbeef")
    @Test
    @Repeat(iterations=20)
    public void testAgainstReferenceOpenHashSet() {
        OpenHashSet base = new OpenHashSet();
        HashSet reference = Sets.newHashSet();
        ArrayList ops = Lists.newArrayList();
        RandomBlasting.addOp(ops, Operation.ADD, 60);
        RandomBlasting.addOp(ops, Operation.REMOVE, 30);
        RandomBlasting.addOp(ops, Operation.INDEXOF, 30);
        RandomBlasting.addOp(ops, Operation.CLEAR, 5);
        RandomBlasting.addOp(ops, Operation.ISEMPTY, 2);
        RandomBlasting.addOp(ops, Operation.SIZE, 2);
        int max = RandomBlasting.randomIntBetween((int)1000, (int)20000);
        block8: for (int reps = 0; reps < max; ++reps) {
            int k = RandomBlasting.randomIntBetween((int)0, (int)(max / 4));
            switch ((Operation)((Object)RandomBlasting.randomFrom((List)ops))) {
                case ADD: {
                    RandomBlasting.assertEquals((Object)reference.contains(k), (Object)base.contains(k));
                    continue block8;
                }
                case REMOVE: {
                    RandomBlasting.assertEquals((Object)reference.remove(k), (Object)base.remove(k));
                    continue block8;
                }
                case INDEXOF: {
                    RandomBlasting.assertEquals((Object)reference.contains(k), (Object)base.contains(k));
                    continue block8;
                }
                case CLEAR: {
                    reference.clear();
                    base.clear();
                    continue block8;
                }
                case ISEMPTY: {
                    RandomBlasting.assertEquals((Object)reference.isEmpty(), (Object)base.isEmpty());
                    continue block8;
                }
                case SIZE: {
                    RandomBlasting.assertEquals((long)reference.size(), (long)base.size());
                    continue block8;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
    }

    @Test
    public void testMahout1225() {
        OpenIntHashSet s = new OpenIntHashSet();
        s.clear();
        s.add(23);
        s.add(46);
        s.clear();
        s.add(70);
        s.add(93);
        s.contains(100);
    }

    @Test
    public void testClearTable() throws Exception {
        OpenObjectIntHashMap m = new OpenObjectIntHashMap();
        m.clear();
        m.put((Object)1, 2);
        m.clear();
        Field tableField = m.getClass().getDeclaredField("table");
        tableField.setAccessible(true);
        Object[] table = (Object[])tableField.get(m);
        RandomBlasting.assertEquals((Object)Sets.newHashSet(Arrays.asList(new Object[]{null})), (Object)Sets.newHashSet(Arrays.asList(table)));
    }

    private static void addOp(List<Operation> ops, Operation op, int reps) {
        for (int i = 0; i < reps; ++i) {
            ops.add(op);
        }
    }

    private static enum Operation {
        ADD,
        REMOVE,
        CLEAR,
        INDEXOF,
        ISEMPTY,
        SIZE;

    }
}

