/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.LongByteProcedure;
import org.apache.mahout.math.function.LongProcedure;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.map.OpenLongByteHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenLongByteHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenLongByteHashMap map = new OpenLongByteHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongByteHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenLongByteHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenLongByteHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenLongByteHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongByteHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenLongByteHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenLongByteHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenLongByteHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongByteHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenLongByteHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenLongByteHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenLongByteHashMap map = new OpenLongByteHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongByteHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenLongByteHashMap map = new OpenLongByteHashMap();
        map.put(11L, (byte)22);
        OpenLongByteHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenLongByteHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenLongByteHashMapTest.assertEquals((double)0.0, (double)map.get(11L), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenLongByteHashMap map = new OpenLongByteHashMap();
        map.put(11L, (byte)22);
        OpenLongByteHashMap map2 = (OpenLongByteHashMap)map.clone();
        map.clear();
        OpenLongByteHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenLongByteHashMap map = new OpenLongByteHashMap();
        map.put(11L, (byte)22);
        OpenLongByteHashMapTest.assertTrue((boolean)map.containsKey(11L));
        OpenLongByteHashMapTest.assertFalse((boolean)map.containsKey(12L));
    }

    @Test
    public void testContainValue() {
        OpenLongByteHashMap map = new OpenLongByteHashMap();
        map.put(11L, (byte)22);
        OpenLongByteHashMapTest.assertTrue((boolean)map.containsValue((byte)22));
        OpenLongByteHashMapTest.assertFalse((boolean)map.containsValue((byte)23));
    }

    @Test
    public void testForEachKey() {
        final LongArrayList keys = new LongArrayList();
        OpenLongByteHashMap map = new OpenLongByteHashMap();
        map.put(11L, (byte)22);
        map.put(12L, (byte)23);
        map.put(13L, (byte)24);
        map.put(14L, (byte)25);
        map.removeKey(13L);
        map.forEachKey(new LongProcedure(){

            public boolean apply(long element) {
                keys.add(element);
                return true;
            }
        });
        long[] keysArray = keys.toArray(new long[keys.size()]);
        Arrays.sort(keysArray);
        OpenLongByteHashMapTest.assertArrayEquals((long[])new long[]{11L, 12L, 14L}, (long[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenLongByteHashMap map = new OpenLongByteHashMap();
        map.put(11L, (byte)22);
        map.put(12L, (byte)23);
        map.put(13L, (byte)24);
        map.put(14L, (byte)25);
        map.removeKey(13L);
        map.forEachPair(new LongByteProcedure(){

            public boolean apply(long first, byte second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenLongByteHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenLongByteHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenLongByteHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenLongByteHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenLongByteHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenLongByteHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenLongByteHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new LongByteProcedure(){
            int count = 0;

            public boolean apply(long first, byte second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenLongByteHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenLongByteHashMap map = new OpenLongByteHashMap();
        map.put(11L, (byte)22);
        map.put(12L, (byte)23);
        OpenLongByteHashMapTest.assertEquals((long)22L, (long)map.get(11L));
        OpenLongByteHashMapTest.assertEquals((long)0L, (long)map.get(0L));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenLongByteHashMap map = new OpenLongByteHashMap();
        map.put(11L, (byte)22);
        map.put(12L, (byte)23);
        map.put(13L, (byte)24);
        map.put(14L, (byte)25);
        map.adjustOrPutValue(11L, (byte)1, (byte)3);
        OpenLongByteHashMapTest.assertEquals((long)25L, (long)map.get(11L));
        map.adjustOrPutValue(15L, (byte)1, (byte)3);
        OpenLongByteHashMapTest.assertEquals((long)1L, (long)map.get(15L));
    }

    @Test
    public void testKeys() {
        OpenLongByteHashMap map = new OpenLongByteHashMap();
        map.put(11L, (byte)22);
        map.put(12L, (byte)22);
        LongArrayList keys = new LongArrayList();
        map.keys(keys);
        keys.sort();
        OpenLongByteHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenLongByteHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        LongArrayList k2 = map.keys();
        k2.sort();
        OpenLongByteHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        LongArrayList keyList = new LongArrayList();
        ByteArrayList valueList = new ByteArrayList();
        OpenLongByteHashMap map = new OpenLongByteHashMap();
        map.put(11L, (byte)22);
        map.put(12L, (byte)23);
        map.put(13L, (byte)24);
        map.put(14L, (byte)25);
        map.removeKey(13L);
        map.pairsMatching(new LongByteProcedure(){

            public boolean apply(long first, byte second) {
                return first % 2L == 0L;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenLongByteHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenLongByteHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenLongByteHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenLongByteHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenLongByteHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenLongByteHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenLongByteHashMap map = new OpenLongByteHashMap();
        map.put(11L, (byte)22);
        map.put(12L, (byte)23);
        map.put(13L, (byte)24);
        map.put(14L, (byte)25);
        map.removeKey(13L);
        ByteArrayList values = new ByteArrayList(100);
        map.values(values);
        OpenLongByteHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenLongByteHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenLongByteHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenLongByteHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenLongByteHashMap map = new OpenLongByteHashMap();
        map.put(11L, (byte)22);
        OpenLongByteHashMap map2 = (OpenLongByteHashMap)map.copy();
        map.clear();
        OpenLongByteHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenLongByteHashMap map = new OpenLongByteHashMap();
        map.put(11L, (byte)22);
        map.put(12L, (byte)23);
        map.put(13L, (byte)24);
        map.put(14L, (byte)25);
        map.removeKey(13L);
        OpenLongByteHashMap map2 = (OpenLongByteHashMap)map.copy();
        OpenLongByteHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenLongByteHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenLongByteHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenLongByteHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11L);
        OpenLongByteHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenLongByteHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenLongByteHashMap map = new OpenLongByteHashMap();
        map.put(11L, (byte)22);
        map.put(12L, (byte)23);
        map.put(13L, (byte)24);
        map.put(14L, (byte)25);
        map.removeKey(13L);
        LongArrayList keys = new LongArrayList();
        map.keysSortedByValue(keys);
        long[] keysArray = keys.toArray(new long[keys.size()]);
        OpenLongByteHashMapTest.assertArrayEquals((long[])new long[]{11L, 12L, 14L}, (long[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenLongByteHashMap map = new OpenLongByteHashMap();
        map.put(11L, (byte)100);
        map.put(12L, (byte)70);
        map.put(13L, (byte)30);
        map.put(14L, (byte)3);
        LongArrayList keys = new LongArrayList();
        ByteArrayList values = new ByteArrayList();
        map.pairsSortedByKey(keys, values);
        OpenLongByteHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenLongByteHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenLongByteHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenLongByteHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenLongByteHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenLongByteHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenLongByteHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenLongByteHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenLongByteHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenLongByteHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenLongByteHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenLongByteHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenLongByteHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenLongByteHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenLongByteHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenLongByteHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenLongByteHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenLongByteHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        long k;
        byte v;

        Pair(long k, byte v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

