/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.ByteObjectProcedure;
import org.apache.mahout.math.function.ByteProcedure;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.map.OpenByteObjectHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OpenByteObjectHashMapTest
extends Assert {
    private TestClass item;
    private TestClass anotherItem;
    private TestClass anotherItem2;
    private TestClass anotherItem3;
    private TestClass anotherItem4;
    private TestClass anotherItem5;

    @Before
    public void before() {
        this.item = new TestClass(101);
        this.anotherItem = new TestClass(99);
        this.anotherItem2 = new TestClass(2);
        this.anotherItem3 = new TestClass(3);
        this.anotherItem4 = new TestClass(4);
        this.anotherItem5 = new TestClass(5);
    }

    @Test
    public void testConstructors() {
        OpenByteObjectHashMap map = new OpenByteObjectHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteObjectHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenByteObjectHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenByteObjectHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenByteObjectHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteObjectHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenByteObjectHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenByteObjectHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenByteObjectHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteObjectHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenByteObjectHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenByteObjectHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenByteObjectHashMap map = new OpenByteObjectHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteObjectHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenByteObjectHashMap map = new OpenByteObjectHashMap();
        for (int i = 0; i < 100; ++i) {
            map.put((byte)i, (Object)this.item);
            OpenByteObjectHashMapTest.assertEquals((long)1L, (long)map.size());
            map.clear();
            OpenByteObjectHashMapTest.assertEquals((long)0L, (long)map.size());
            OpenByteObjectHashMapTest.assertFalse((String)("Contains: " + i), (boolean)map.containsKey((byte)i));
            OpenByteObjectHashMapTest.assertSame(null, (Object)map.get((byte)i));
        }
    }

    @Test
    public void testClone() {
        OpenByteObjectHashMap map = new OpenByteObjectHashMap();
        map.put((byte)11, (Object)this.item);
        OpenByteObjectHashMap map2 = map.clone();
        map.clear();
        OpenByteObjectHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenByteObjectHashMap map = new OpenByteObjectHashMap();
        map.put((byte)11, (Object)this.item);
        OpenByteObjectHashMapTest.assertTrue((boolean)map.containsKey((byte)11));
        OpenByteObjectHashMapTest.assertFalse((boolean)map.containsKey((byte)12));
    }

    @Test
    public void testContainValue() {
        OpenByteObjectHashMap map = new OpenByteObjectHashMap();
        map.put((byte)11, (Object)this.item);
        OpenByteObjectHashMapTest.assertTrue((boolean)map.containsValue((Object)this.item));
        OpenByteObjectHashMapTest.assertFalse((boolean)map.containsValue((Object)this.anotherItem));
    }

    @Test
    public void testForEachKey() {
        final ByteArrayList keys = new ByteArrayList();
        OpenByteObjectHashMap map = new OpenByteObjectHashMap();
        map.put((byte)11, (Object)this.anotherItem);
        map.put((byte)12, (Object)this.anotherItem2);
        map.put((byte)13, (Object)this.anotherItem3);
        map.put((byte)14, (Object)this.anotherItem4);
        map.removeKey((byte)13);
        map.forEachKey(new ByteProcedure(){

            public boolean apply(byte element) {
                keys.add(element);
                return true;
            }
        });
        byte[] keysArray = keys.toArray(new byte[keys.size()]);
        Arrays.sort(keysArray);
        OpenByteObjectHashMapTest.assertArrayEquals((byte[])new byte[]{11, 12, 14}, (byte[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenByteObjectHashMap map = new OpenByteObjectHashMap();
        map.put((byte)11, (Object)this.anotherItem);
        map.put((byte)12, (Object)this.anotherItem2);
        map.put((byte)13, (Object)this.anotherItem3);
        map.put((byte)14, (Object)this.anotherItem4);
        map.removeKey((byte)13);
        map.forEachPair((ByteObjectProcedure)new ByteObjectProcedure<TestClass>(){

            public boolean apply(byte first, TestClass second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenByteObjectHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenByteObjectHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenByteObjectHashMapTest.assertSame((Object)this.anotherItem, (Object)((Pair)pairs.get((int)0)).v);
        OpenByteObjectHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenByteObjectHashMapTest.assertSame((Object)this.anotherItem2, (Object)((Pair)pairs.get((int)1)).v);
        OpenByteObjectHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenByteObjectHashMapTest.assertSame((Object)this.anotherItem4, (Object)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair((ByteObjectProcedure)new ByteObjectProcedure<TestClass>(){
            int count = 0;

            public boolean apply(byte first, TestClass second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenByteObjectHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenByteObjectHashMap map = new OpenByteObjectHashMap();
        map.put((byte)11, (Object)this.item);
        map.put((byte)12, (Object)this.anotherItem);
        OpenByteObjectHashMapTest.assertSame((Object)this.item, (Object)map.get((byte)11));
        OpenByteObjectHashMapTest.assertSame(null, (Object)map.get((byte)0));
    }

    @Test
    public void testKeys() {
        OpenByteObjectHashMap map = new OpenByteObjectHashMap();
        map.put((byte)11, (Object)this.item);
        map.put((byte)12, (Object)this.item);
        ByteArrayList keys = new ByteArrayList();
        map.keys(keys);
        keys.sort();
        OpenByteObjectHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenByteObjectHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        ByteArrayList k2 = map.keys();
        k2.sort();
        OpenByteObjectHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        ByteArrayList keyList = new ByteArrayList();
        ArrayList valueList = new ArrayList();
        OpenByteObjectHashMap map = new OpenByteObjectHashMap();
        map.put((byte)11, (Object)this.anotherItem2);
        map.put((byte)12, (Object)this.anotherItem3);
        map.put((byte)13, (Object)this.anotherItem4);
        map.put((byte)14, (Object)this.anotherItem5);
        map.removeKey((byte)13);
        map.pairsMatching((ByteObjectProcedure)new ByteObjectProcedure<TestClass>(){

            public boolean apply(byte first, TestClass second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        Collections.sort(valueList);
        OpenByteObjectHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenByteObjectHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenByteObjectHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenByteObjectHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenByteObjectHashMapTest.assertSame((Object)this.anotherItem3, valueList.get(0));
        OpenByteObjectHashMapTest.assertSame((Object)this.anotherItem5, valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenByteObjectHashMap map = new OpenByteObjectHashMap();
        map.put((byte)11, (Object)this.anotherItem);
        map.put((byte)12, (Object)this.anotherItem2);
        map.put((byte)13, (Object)this.anotherItem3);
        map.put((byte)14, (Object)this.anotherItem4);
        map.removeKey((byte)13);
        ArrayList values = new ArrayList(100);
        map.values(values);
        OpenByteObjectHashMapTest.assertEquals((long)3L, (long)values.size());
        Collections.sort(values);
        OpenByteObjectHashMapTest.assertEquals((Object)this.anotherItem2, values.get(0));
        OpenByteObjectHashMapTest.assertEquals((Object)this.anotherItem4, values.get(1));
        OpenByteObjectHashMapTest.assertEquals((Object)this.anotherItem, values.get(2));
    }

    @Test
    public void testCopy() {
        OpenByteObjectHashMap map = new OpenByteObjectHashMap();
        map.put((byte)11, (Object)this.item);
        OpenByteObjectHashMap map2 = (OpenByteObjectHashMap)map.copy();
        map.clear();
        OpenByteObjectHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenByteObjectHashMap map = new OpenByteObjectHashMap();
        map.put((byte)11, (Object)this.anotherItem);
        map.put((byte)12, (Object)this.anotherItem2);
        map.put((byte)13, (Object)this.anotherItem3);
        map.put((byte)14, (Object)this.anotherItem4);
        map.removeKey((byte)13);
        OpenByteObjectHashMap map2 = (OpenByteObjectHashMap)map.copy();
        OpenByteObjectHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenByteObjectHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenByteObjectHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenByteObjectHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey((byte)11);
        OpenByteObjectHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenByteObjectHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenByteObjectHashMap map = new OpenByteObjectHashMap();
        map.put((byte)11, (Object)this.anotherItem5);
        map.put((byte)12, (Object)this.anotherItem4);
        map.put((byte)13, (Object)this.anotherItem3);
        map.put((byte)14, (Object)this.anotherItem2);
        map.removeKey((byte)13);
        ByteArrayList keys = new ByteArrayList();
        map.keysSortedByValue(keys);
        byte[] keysArray = keys.toArray(new byte[keys.size()]);
        OpenByteObjectHashMapTest.assertArrayEquals((byte[])new byte[]{14, 12, 11}, (byte[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenByteObjectHashMap map = new OpenByteObjectHashMap();
        map.put((byte)11, (Object)this.anotherItem5);
        map.put((byte)12, (Object)this.anotherItem4);
        map.put((byte)13, (Object)this.anotherItem3);
        map.put((byte)14, (Object)this.anotherItem2);
        ByteArrayList keys = new ByteArrayList();
        ArrayList values = new ArrayList();
        map.pairsSortedByKey(keys, values);
        OpenByteObjectHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenByteObjectHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenByteObjectHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenByteObjectHashMapTest.assertSame((Object)this.anotherItem5, values.get(0));
        OpenByteObjectHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenByteObjectHashMapTest.assertSame((Object)this.anotherItem4, values.get(1));
        OpenByteObjectHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenByteObjectHashMapTest.assertSame((Object)this.anotherItem3, values.get(2));
        OpenByteObjectHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenByteObjectHashMapTest.assertSame((Object)this.anotherItem2, values.get(3));
    }

    @Test
    public void testPairsSortedByValue() {
        OpenByteObjectHashMap map = new OpenByteObjectHashMap();
        map.put((byte)11, (Object)this.anotherItem5);
        map.put((byte)12, (Object)this.anotherItem4);
        map.put((byte)13, (Object)this.anotherItem3);
        map.put((byte)14, (Object)this.anotherItem2);
        ByteArrayList keys = new ByteArrayList();
        ArrayList values = new ArrayList();
        map.pairsSortedByValue(keys, values);
        OpenByteObjectHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenByteObjectHashMapTest.assertEquals((Object)this.anotherItem5, values.get(3));
        OpenByteObjectHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenByteObjectHashMapTest.assertEquals((Object)this.anotherItem4, values.get(2));
        OpenByteObjectHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenByteObjectHashMapTest.assertEquals((Object)this.anotherItem3, values.get(1));
        OpenByteObjectHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenByteObjectHashMapTest.assertEquals((Object)this.anotherItem2, values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        byte k;
        TestClass v;

        Pair(byte k, TestClass v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }

    private static class TestClass
    implements Comparable<TestClass> {
        byte x;

        TestClass(byte x) {
            this.x = x;
        }

        public String toString() {
            return "[ts " + this.x + " ]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Byte.valueOf(this.x).hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestClass other = (TestClass)obj;
            return this.x == other.x;
        }

        @Override
        public int compareTo(TestClass o) {
            return this.x - o.x;
        }
    }
}

