/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.decomposer.lanczos;

import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorIterable;
import org.apache.mahout.math.decomposer.SolverTest;
import org.apache.mahout.math.decomposer.lanczos.LanczosSolver;
import org.apache.mahout.math.decomposer.lanczos.LanczosState;
import org.apache.mahout.math.solver.EigenDecomposition;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestLanczosSolver
extends SolverTest {
    private static final Logger log = LoggerFactory.getLogger(TestLanczosSolver.class);
    private static final double ERROR_TOLERANCE = 0.05;

    @Test
    public void testEigenvalueCheck() throws Exception {
        int size = 100;
        Matrix m = TestLanczosSolver.randomHierarchicalSymmetricMatrix(size);
        DenseVector initialVector = new DenseVector(size);
        initialVector.assign(1.0 / Math.sqrt(size));
        LanczosSolver solver = new LanczosSolver();
        int desiredRank = 80;
        LanczosState state = new LanczosState((VectorIterable)m, desiredRank, (Vector)initialVector);
        solver.solve(state, desiredRank, true);
        EigenDecomposition decomposition = new EigenDecomposition(m);
        Vector eigenvalues = decomposition.getRealEigenvalues();
        float fractionOfEigensExpectedGood = 0.6f;
        int i = 0;
        while ((float)i < fractionOfEigensExpectedGood * (float)desiredRank) {
            double s = state.getSingularValue(i);
            double e = eigenvalues.get(i);
            log.info("{} : L = {}, E = {}", new Object[]{i, s, e});
            TestLanczosSolver.assertTrue((String)"Singular value differs from eigenvalue", (Math.abs((s - e) / e) < 0.05 ? 1 : 0) != 0);
            Vector v = state.getRightSingularVector(i);
            Vector v2 = decomposition.getV().viewColumn(i);
            double error = 1.0 - Math.abs(v.dot(v2) / (v.norm(2.0) * v2.norm(2.0)));
            log.info("error: {}", (Object)error);
            TestLanczosSolver.assertTrue((String)(i + ": 1 - cosAngle = " + error), (error < 0.05 ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public void testLanczosSolver() throws Exception {
        int numRows = 800;
        int numColumns = 500;
        Matrix corpus = TestLanczosSolver.randomHierarchicalMatrix(numRows, numColumns, false);
        DenseVector initialVector = new DenseVector(numColumns);
        initialVector.assign(1.0 / Math.sqrt(numColumns));
        int rank = 50;
        LanczosState state = new LanczosState((VectorIterable)corpus, rank, (Vector)initialVector);
        LanczosSolver solver = new LanczosSolver();
        solver.solve(state, rank, false);
        TestLanczosSolver.assertOrthonormal(state);
        for (int i = 0; i < rank / 2; ++i) {
            TestLanczosSolver.assertEigen(i, state.getRightSingularVector(i), (VectorIterable)corpus, 0.05, false);
        }
    }

    @Test
    public void testLanczosSolverSymmetric() throws Exception {
        int numCols = 500;
        Matrix corpus = TestLanczosSolver.randomHierarchicalSymmetricMatrix(numCols);
        DenseVector initialVector = new DenseVector(numCols);
        initialVector.assign(1.0 / Math.sqrt(numCols));
        int rank = 30;
        LanczosState state = new LanczosState((VectorIterable)corpus, rank, (Vector)initialVector);
        LanczosSolver solver = new LanczosSolver();
        solver.solve(state, rank, true);
    }
}

