/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakAction;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakLingering;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakScope;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakZombies;
import com.carrotsearch.randomizedtesting.annotations.TimeoutSuite;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.mahout.common.RandomUtils;
import org.junit.After;
import org.junit.Before;

@ThreadLeakScope(value=ThreadLeakScope.Scope.SUITE)
@ThreadLeakAction(value={ThreadLeakAction.Action.WARN, ThreadLeakAction.Action.INTERRUPT})
@ThreadLeakLingering(linger=20000)
@ThreadLeakZombies(value=ThreadLeakZombies.Consequence.IGNORE_REMAINING_TESTS)
@TimeoutSuite(millis=0x6DDD00)
public abstract class MahoutTestCase
extends RandomizedTest {
    public static final double EPSILON = 1.0E-6;
    private File testTempDir;

    @Before
    public void setUp() throws Exception {
        this.testTempDir = null;
        RandomUtils.useTestSeed();
    }

    @After
    public void tearDown() throws Exception {
        if (this.testTempDir != null) {
            new DeletingVisitor().accept(this.testTempDir);
        }
    }

    protected final File getTestTempDir() throws IOException {
        if (this.testTempDir == null) {
            String systemTmpDir = System.getProperty("mahout.test.directory");
            if (systemTmpDir == null) {
                systemTmpDir = "target/";
                systemTmpDir = systemTmpDir + "test-data";
            }
            long simpleRandomLong = (long)(9.223372036854776E18 * Math.random());
            this.testTempDir = new File(systemTmpDir, "mahout-" + ((Object)((Object)this)).getClass().getSimpleName() + '-' + simpleRandomLong);
            if (!this.testTempDir.mkdirs()) {
                throw new IOException("Could not create " + this.testTempDir);
            }
            this.testTempDir.deleteOnExit();
        }
        return this.testTempDir;
    }

    protected final File getTestTempFile(String name) throws IOException {
        return this.getTestTempFileOrDir(name, false);
    }

    protected final File getTestTempDir(String name) throws IOException {
        return this.getTestTempFileOrDir(name, true);
    }

    private File getTestTempFileOrDir(String name, boolean dir) throws IOException {
        File f = new File(this.getTestTempDir(), name);
        f.deleteOnExit();
        if (dir && !f.mkdirs()) {
            throw new IOException("Could not make directory " + f);
        }
        return f;
    }

    private static class DeletingVisitor
    implements FileFilter {
        private DeletingVisitor() {
        }

        @Override
        public boolean accept(File f) {
            if (!f.isFile()) {
                f.listFiles(this);
            }
            f.delete();
            return false;
        }
    }
}

