/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.io.File;
import java.io.IOException;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.FileBasedSparseBinaryMatrix;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.SparseRowMatrix;
import org.apache.mahout.math.Vector;
import org.junit.Test;

public class FileBasedSparseBinaryMatrixTest
extends MahoutTestCase {
    @Test
    public void testSetData() throws IOException {
        File f = File.createTempFile("matrix", ".m");
        f.deleteOnExit();
        RandomWrapper gen = RandomUtils.getRandom();
        SparseRowMatrix m0 = new SparseRowMatrix(10, 21);
        for (MatrixSlice row : m0) {
            int len = (int)Math.ceil(-15.0 * Math.log(1.0 - gen.nextDouble()));
            for (int i = 0; i < len; ++i) {
                row.vector().set(gen.nextInt(21), 1.0);
            }
        }
        FileBasedSparseBinaryMatrix.writeMatrix((File)f, (Matrix)m0);
        FileBasedSparseBinaryMatrix m = new FileBasedSparseBinaryMatrix(10, 21);
        m.setData(f);
        for (MatrixSlice row : m) {
            Vector diff = row.vector().minus(m0.viewRow(row.index()));
            double error = diff.norm(1.0);
            if (error > 1.0E-14) {
                System.out.printf("%s\n", diff);
            }
            FileBasedSparseBinaryMatrixTest.assertEquals((double)0.0, (double)error, (double)1.0E-14);
        }
    }
}

