/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.io.File;
import java.io.IOException;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.FileBasedMatrix;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.SparseRowMatrix;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.random.MultiNormal;
import org.junit.Assume;
import org.junit.Test;

public class FileBasedMatrixTest
extends MahoutTestCase {
    private static final int ROWS = 10000000;
    private static final int COLUMNS = 40;

    @Test
    public void testBigMatrix() throws IOException {
        Assume.assumeNotNull((Object[])new Object[]{System.getProperty("runSlowTests")});
        SparseRowMatrix m0 = new SparseRowMatrix(10000000, 40);
        RandomWrapper gen = RandomUtils.getRandom();
        for (int i = 0; i < 1000; ++i) {
            m0.set(gen.nextInt(10000000), gen.nextInt(40), (double)FileBasedMatrixTest.matrixValue(i));
        }
        File f = File.createTempFile("foo", ".m");
        f.deleteOnExit();
        System.out.printf("Starting to write to %s\n", f.getAbsolutePath());
        FileBasedMatrix.writeMatrix((File)f, (Matrix)m0);
        System.out.printf("done\n", new Object[0]);
        System.out.printf("File is %.1f MB\n", (double)f.length() / 1000000.0);
        FileBasedMatrix m1 = new FileBasedMatrix(10000000, 40);
        System.out.printf("Starting read\n", new Object[0]);
        m1.setData(f, false);
        gen = RandomUtils.getRandom();
        for (int i = 0; i < 1000; ++i) {
            FileBasedMatrixTest.assertEquals((double)FileBasedMatrixTest.matrixValue(i), (double)m1.get(gen.nextInt(10000000), gen.nextInt(40)), (double)0.0);
        }
        System.out.printf("done\n", new Object[0]);
    }

    private static int matrixValue(int i) {
        return i * 88513 % 10000;
    }

    @Test
    public void testSetData() throws IOException {
        File f = File.createTempFile("matrix", ".m");
        f.deleteOnExit();
        DenseMatrix m0 = new DenseMatrix(100000, 30);
        MultiNormal gen = new MultiNormal(30);
        for (MatrixSlice row : m0) {
            row.vector().assign(gen.sample());
        }
        FileBasedMatrix.writeMatrix((File)f, (Matrix)m0);
        FileBasedMatrix m = new FileBasedMatrix(100000, 30);
        m.setData(f, true);
        FileBasedMatrixTest.assertEquals((double)0.0, (double)m0.minus((Matrix)m).aggregate(Functions.MAX, Functions.ABS), (double)1.0E-8);
        int i = 0;
        for (MatrixSlice row : m) {
            FileBasedMatrixTest.assertEquals((double)0.0, (double)row.vector().minus(m0.viewRow(i++)).norm(1.0), (double)1.0E-8);
        }
    }
}

