/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.ssvd;

import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.RealMatrix;

public class EigenSolverWrapper {
    private final double[] eigenvalues;
    private final double[][] uHat;

    public EigenSolverWrapper(double[][] bbt) {
        int dim = bbt.length;
        EigenDecomposition evd2 = new EigenDecomposition((RealMatrix)new Array2DRowRealMatrix(bbt));
        this.eigenvalues = evd2.getRealEigenvalues();
        RealMatrix uHatrm = evd2.getV();
        this.uHat = new double[dim][];
        for (int i = 0; i < dim; ++i) {
            this.uHat[i] = uHatrm.getRow(i);
        }
    }

    public double[][] getUHat() {
        return this.uHat;
    }

    public double[] getEigenValues() {
        return this.eigenvalues;
    }
}

