/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.random;

import com.google.common.base.Preconditions;
import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.random.AbstractSamplerFunction;

public final class Empirical
extends AbstractSamplerFunction {
    private final Random gen;
    private final boolean exceedMinimum;
    private final boolean exceedMaximum;
    private final double[] x;
    private final double[] y;
    private final int n;

    public Empirical(boolean exceedMinimum, boolean exceedMaximum, int samples, double ... ecdf) {
        Preconditions.checkArgument((ecdf.length % 2 == 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((samples >= 3 ? 1 : 0) != 0);
        Preconditions.checkArgument((exceedMinimum || ecdf[0] == 0.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((exceedMaximum || ecdf[ecdf.length - 2] == 1.0 ? 1 : 0) != 0);
        this.gen = RandomUtils.getRandom();
        this.n = ecdf.length / 2;
        this.x = new double[this.n];
        this.y = new double[this.n];
        double lastX = ecdf[1];
        double lastY = ecdf[0];
        for (int i = 0; i < ecdf.length; i += 2) {
            Preconditions.checkArgument((i == 0 || ecdf[i + 1] > lastY ? 1 : 0) != 0);
            this.y[i / 2] = ecdf[i + 1];
            lastY = this.y[i / 2];
            Preconditions.checkArgument((ecdf[i] >= 0.0 && ecdf[i] <= 1.0 ? 1 : 0) != 0);
            Preconditions.checkArgument((i == 0 || ecdf[i] > lastX ? 1 : 0) != 0);
            this.x[i / 2] = ecdf[i];
            lastX = this.x[i / 2];
        }
        double x0 = exceedMinimum ? 0.5 / (double)samples : 0.0;
        double x1 = 1.0 - (exceedMaximum ? 0.5 / (double)samples : 0.0);
        for (int i = 0; i < this.n; ++i) {
            this.x[i] = this.x[i] * (x1 - x0) + x0;
        }
        this.exceedMinimum = exceedMinimum;
        this.exceedMaximum = exceedMaximum;
    }

    @Override
    public Double sample() {
        return this.sample(this.gen.nextDouble());
    }

    public double sample(double u) {
        if (this.exceedMinimum && u < this.x[0]) {
            if (u == 0.0) {
                u = 1.0E-16;
            }
            return this.y[0] + Math.log(u / this.x[0]) * this.x[0] * (this.y[1] - this.y[0]) / (this.x[1] - this.x[0]);
        }
        if (this.exceedMaximum && u > this.x[this.n - 1]) {
            if (u == 1.0) {
                u = 0.9999999999999999;
            }
            double dy = this.y[this.n - 1] - this.y[this.n - 2];
            double dx = this.x[this.n - 1] - this.x[this.n - 2];
            return this.y[this.n - 1] - Math.log((1.0 - u) / (1.0 - this.x[this.n - 1])) * (1.0 - this.x[this.n - 1]) * dy / dx;
        }
        for (int i = 1; i < this.n; ++i) {
            if (!(this.x[i] > u)) continue;
            double dy = this.y[i] - this.y[i - 1];
            double dx = this.x[i] - this.x[i - 1];
            return this.y[i - 1] + (u - this.x[i - 1]) * dy / dx;
        }
        throw new RuntimeException(String.format("Can't happen (%.3f is not in [%.3f,%.3f]", u, this.x[0], this.x[this.n - 1]));
    }
}

