/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.nio.IntBuffer;
import java.util.Arrays;
import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.function.ShortByteProcedure;
import org.apache.mahout.math.function.ShortProcedure;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.set.AbstractSet;
import org.apache.mahout.math.set.HashUtils;

public abstract class AbstractShortByteMap
extends AbstractSet {
    public boolean containsKey(final short key) {
        return !this.forEachKey(new ShortProcedure(){

            @Override
            public boolean apply(short iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final byte value) {
        return !this.forEachPair(new ShortByteProcedure(){

            @Override
            public boolean apply(short iterKey, byte iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractShortByteMap copy() {
        return (AbstractShortByteMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractShortByteMap)) {
            return false;
        }
        final AbstractShortByteMap other = (AbstractShortByteMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new ShortByteProcedure(){

            @Override
            public boolean apply(short key, byte value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new ShortByteProcedure(){

            @Override
            public boolean apply(short key, byte value) {
                return AbstractShortByteMap.this.containsKey(key) && AbstractShortByteMap.this.get(key) == value;
            }
        });
    }

    public int hashCode() {
        final int[] buf = new int[this.size()];
        this.forEachPair(new ShortByteProcedure(){
            int i = 0;

            @Override
            public boolean apply(short key, byte value) {
                buf[this.i++] = HashUtils.hash(key) ^ HashUtils.hash(value);
                return true;
            }
        });
        Arrays.sort(buf);
        return IntBuffer.wrap(buf).hashCode();
    }

    public abstract boolean forEachKey(ShortProcedure var1);

    public boolean forEachPair(final ShortByteProcedure procedure) {
        return this.forEachKey(new ShortProcedure(){

            @Override
            public boolean apply(short key) {
                return procedure.apply(key, AbstractShortByteMap.this.get(key));
            }
        });
    }

    public abstract byte get(short var1);

    public ShortArrayList keys() {
        ShortArrayList list = new ShortArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final ShortArrayList list) {
        list.clear();
        this.forEachKey(new ShortProcedure(){

            @Override
            public boolean apply(short key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(ShortArrayList keyList) {
        this.pairsSortedByValue(keyList, new ByteArrayList(this.size()));
    }

    public void pairsMatching(final ShortByteProcedure condition, final ShortArrayList keyList, final ByteArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new ShortByteProcedure(){

            @Override
            public boolean apply(short key, byte value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(ShortArrayList keyList, ByteArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(ShortArrayList keyList, ByteArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final short[] k = keyList.elements();
        final byte[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                byte t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                short t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(short var1, byte var2);

    public abstract boolean removeKey(short var1);

    public String toString() {
        ShortArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            short key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        ShortArrayList theKeys = new ShortArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            short key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public ByteArrayList values() {
        ByteArrayList list = new ByteArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final ByteArrayList list) {
        list.clear();
        this.forEachKey(new ShortProcedure(){

            @Override
            public boolean apply(short key) {
                list.add(AbstractShortByteMap.this.get(key));
                return true;
            }
        });
    }

    public byte adjustOrPutValue(short key, byte newValue, byte incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = (byte)(this.get(key) + incrValue);
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

