/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.stats;

import java.util.Random;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.stats.OnlineSummarizer;
import org.junit.Test;

public final class OnlineSummarizerTest
extends MahoutTestCase {
    @Test
    public void testCount() {
        OnlineSummarizer x = new OnlineSummarizer();
        OnlineSummarizerTest.assertEquals((long)0L, (long)x.getCount());
        x.add(1.0);
        OnlineSummarizerTest.assertEquals((long)1L, (long)x.getCount());
        for (int i = 2; i < 110; ++i) {
            x.add((double)i);
            OnlineSummarizerTest.assertEquals((long)i, (long)x.getCount());
        }
    }

    @Test
    public void testStats() {
        OnlineSummarizerTest.check(OnlineSummarizerTest.normal(10000), -4.417246, -3.419809, -0.6972919, -0.6519899, -0.02056658, 0.02176474, 0.6503866, 0.6983311, 3.419809, 4.417246, -0.01515753, 0.01592942, 0.988395, 1.011883);
        OnlineSummarizerTest.check(OnlineSummarizerTest.exp(10000), 4.317969E-6, 3.278763E-4, 0.2783866, 0.298, 0.6765024, 0.7109463, 1.356929, 1.414761, 8.0, 13.0, 0.983805, 1.01592, 0.977162, 1.022093);
    }

    private static void check(OnlineSummarizer x, double ... values) {
        for (int i = 0; i < 5; ++i) {
            OnlineSummarizerTest.checkRange("quartile " + i, x.getQuartile(i), values[2 * i], values[2 * i + 1]);
        }
        OnlineSummarizerTest.assertEquals((double)x.getQuartile(2), (double)x.getMedian(), (double)0.0);
        OnlineSummarizerTest.checkRange("mean", x.getMean(), values[10], values[11]);
        OnlineSummarizerTest.checkRange("sd", x.getSD(), values[12], values[13]);
    }

    private static void checkRange(String msg, double v, double low, double high) {
        if (v < low || v > high) {
            OnlineSummarizerTest.fail((String)("Wanted " + msg + " to be in range [" + low + ',' + high + "] but got " + v));
        }
    }

    private static OnlineSummarizer normal(int n) {
        OnlineSummarizer x = new OnlineSummarizer();
        Random gen = new Random(1L);
        for (int i = 0; i < n; ++i) {
            x.add(gen.nextGaussian());
        }
        return x;
    }

    private static OnlineSummarizer exp(int n) {
        OnlineSummarizer x = new OnlineSummarizer();
        Random gen = new Random(1L);
        for (int i = 0; i < n; ++i) {
            x.add(-Math.log1p(-gen.nextDouble()));
        }
        return x;
    }
}

