/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.random;

import org.apache.commons.math3.distribution.PoissonDistribution;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.random.PoissonSampler;
import org.apache.mahout.math.random.Sampler;
import org.junit.Before;
import org.junit.Test;

public final class PoissonSamplerTest
extends MahoutTestCase {
    @Override
    @Before
    public void setUp() {
        RandomUtils.useTestSeed();
    }

    @Test
    public void testBasics() {
        for (double alpha : new double[]{0.1, 1.0, 10.0, 100.0}) {
            PoissonSamplerTest.checkDistribution((Sampler<Double>)new PoissonSampler(alpha), alpha);
        }
    }

    private static void checkDistribution(Sampler<Double> pd, double alpha) {
        int[] count = new int[(int)Math.max(10.0, 5.0 * alpha)];
        for (int i = 0; i < 10000; ++i) {
            int n = ((Double)pd.sample()).intValue();
            count[n] = count[n] + 1;
        }
        PoissonDistribution ref = new PoissonDistribution(RandomUtils.getRandom().getRandomGenerator(), alpha, 1.0E-12, 10000000);
        for (int i = 0; i < count.length; ++i) {
            PoissonSamplerTest.assertEquals((double)ref.probability(i), (double)((double)count[i] / 10000.0), (double)0.02);
        }
    }
}

