/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.random;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.random.Multinomial;
import org.junit.Before;
import org.junit.Test;

public class MultinomialTest
extends MahoutTestCase {
    @Override
    @Before
    public void setUp() {
        RandomUtils.useTestSeed();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoValues() {
        HashMultiset emptySet = HashMultiset.create();
        new Multinomial((Multiset)emptySet);
    }

    @Test
    public void testSingleton() {
        HashMultiset oneThing = HashMultiset.create();
        oneThing.add((Object)"one");
        Multinomial s = new Multinomial((Multiset)oneThing);
        MultinomialTest.assertEquals((Object)"one", (Object)s.sample(0.0));
        MultinomialTest.assertEquals((Object)"one", (Object)s.sample(0.1));
        MultinomialTest.assertEquals((Object)"one", (Object)s.sample(1.0));
    }

    @Test
    public void testEvenSplit() {
        HashMultiset stuff = HashMultiset.create();
        for (int i = 0; i < 5; ++i) {
            stuff.add((Object)String.valueOf(i));
        }
        Multinomial s = new Multinomial((Multiset)stuff);
        double EPSILON = 1.0E-15;
        HashMultiset cnt = HashMultiset.create();
        for (int i = 0; i < 5; ++i) {
            cnt.add(s.sample((double)i * 0.2));
            cnt.add(s.sample((double)i * 0.2 + EPSILON));
            cnt.add(s.sample((double)(i + 1) * 0.2 - EPSILON));
        }
        MultinomialTest.assertEquals((long)5L, (long)cnt.elementSet().size());
        for (String v : cnt.elementSet()) {
            MultinomialTest.assertEquals((double)3.0, (double)cnt.count((Object)v), (double)1.01);
        }
        MultinomialTest.assertTrue((boolean)cnt.contains(s.sample(1.0)));
        MultinomialTest.assertEquals((Object)s.sample(1.0 - EPSILON), (Object)s.sample(1.0));
    }

    @Test
    public void testPrime() {
        ArrayList data = Lists.newArrayList();
        for (int i = 0; i < 17; ++i) {
            String s = "0";
            if ((i & 1) != 0) {
                s = "1";
            }
            if ((i & 2) != 0) {
                s = "2";
            }
            if ((i & 4) != 0) {
                s = "3";
            }
            if ((i & 8) != 0) {
                s = "4";
            }
            data.add(s);
        }
        HashMultiset stuff = HashMultiset.create();
        for (String x : data) {
            stuff.add((Object)x);
        }
        Multinomial s0 = new Multinomial((Multiset)stuff);
        Multinomial s1 = new Multinomial((Multiset)stuff);
        Multinomial s2 = new Multinomial((Multiset)stuff);
        double EPSILON = 1.0E-15;
        HashMultiset cnt = HashMultiset.create();
        for (int i = 0; i < 50; ++i) {
            double p0 = (double)i * 0.02;
            double p1 = (double)(i + 1) * 0.02;
            cnt.add(s0.sample(p0));
            cnt.add(s0.sample(p0 + EPSILON));
            cnt.add(s0.sample(p1 - EPSILON));
            MultinomialTest.assertEquals((Object)s0.sample(p0), (Object)s1.sample(p0));
            MultinomialTest.assertEquals((Object)s0.sample(p0 + EPSILON), (Object)s1.sample(p0 + EPSILON));
            MultinomialTest.assertEquals((Object)s0.sample(p1 - EPSILON), (Object)s1.sample(p1 - EPSILON));
            MultinomialTest.assertEquals((Object)s0.sample(p0), (Object)s2.sample(p0));
            MultinomialTest.assertEquals((Object)s0.sample(p0 + EPSILON), (Object)s2.sample(p0 + EPSILON));
            MultinomialTest.assertEquals((Object)s0.sample(p1 - EPSILON), (Object)s2.sample(p1 - EPSILON));
        }
        MultinomialTest.assertEquals((Object)s0.sample(0.0), (Object)s1.sample(0.0));
        MultinomialTest.assertEquals((Object)s0.sample(0.0 + EPSILON), (Object)s1.sample(0.0 + EPSILON));
        MultinomialTest.assertEquals((Object)s0.sample(1.0 - EPSILON), (Object)s1.sample(1.0 - EPSILON));
        MultinomialTest.assertEquals((Object)s0.sample(1.0), (Object)s1.sample(1.0));
        MultinomialTest.assertEquals((Object)s0.sample(0.0), (Object)s2.sample(0.0));
        MultinomialTest.assertEquals((Object)s0.sample(0.0 + EPSILON), (Object)s2.sample(0.0 + EPSILON));
        MultinomialTest.assertEquals((Object)s0.sample(1.0 - EPSILON), (Object)s2.sample(1.0 - EPSILON));
        MultinomialTest.assertEquals((Object)s0.sample(1.0), (Object)s2.sample(1.0));
        MultinomialTest.assertEquals((long)5L, (long)cnt.elementSet().size());
        ImmutableMap ref = ImmutableMap.of((Object)"3", (Object)35, (Object)"2", (Object)18, (Object)"1", (Object)9, (Object)"0", (Object)16, (Object)"4", (Object)72);
        for (String v : cnt.elementSet()) {
            MultinomialTest.assertEquals((long)((Integer)ref.get(v)).intValue(), (long)cnt.count((Object)v));
        }
        MultinomialTest.assertTrue((boolean)cnt.contains(s0.sample(1.0)));
        MultinomialTest.assertEquals((Object)s0.sample(1.0 - EPSILON), (Object)s0.sample(1.0));
    }

    @Test
    public void testInsert() {
        int i;
        RandomWrapper rand = RandomUtils.getRandom();
        Multinomial table = new Multinomial();
        double[] p = new double[10];
        for (i = 0; i < 10; ++i) {
            p[i] = rand.nextDouble();
            table.add((Object)i, p[i]);
        }
        MultinomialTest.checkSelfConsistent((Multinomial<Integer>)table);
        for (i = 0; i < 10; ++i) {
            MultinomialTest.assertEquals((double)p[i], (double)table.getWeight((Object)i), (double)0.0);
        }
    }

    @Test
    public void testSetZeroWhileIterating() {
        Multinomial table = new Multinomial();
        for (int i = 0; i < 10000; ++i) {
            table.add((Object)i, (double)i);
        }
        for (Integer sample : table) {
            table.set((Object)sample, 0.0);
        }
    }

    @Test(expected=NullPointerException.class)
    public void testNoNullValuesAllowed() {
        Multinomial table = new Multinomial();
        table.add(null, 1.0);
    }

    @Test
    public void testDeleteAndUpdate() {
        int i;
        RandomWrapper rand = RandomUtils.getRandom();
        Multinomial table = new Multinomial();
        MultinomialTest.assertEquals((double)0.0, (double)table.getWeight(), (double)1.0E-9);
        double total = 0.0;
        double[] p = new double[10];
        for (int i2 = 0; i2 < 10; ++i2) {
            p[i2] = rand.nextDouble();
            table.add((Object)i2, p[i2]);
            MultinomialTest.assertEquals((double)(total += p[i2]), (double)table.getWeight(), (double)1.0E-9);
        }
        MultinomialTest.assertEquals((double)total, (double)table.getWeight(), (double)1.0E-9);
        MultinomialTest.checkSelfConsistent((Multinomial<Integer>)table);
        double delta = p[7] + p[8];
        table.delete((Object)7);
        p[7] = 0.0;
        table.set((Object)8, 0.0);
        p[8] = 0.0;
        MultinomialTest.checkSelfConsistent((Multinomial<Integer>)table);
        MultinomialTest.assertEquals((double)(total -= delta), (double)table.getWeight(), (double)1.0E-9);
        for (i = 0; i < 10; ++i) {
            MultinomialTest.assertEquals((double)p[i], (double)table.getWeight((Object)i), (double)0.0);
            MultinomialTest.assertEquals((double)(p[i] / total), (double)table.getProbability((Object)i), (double)1.0E-10);
        }
        table.set((Object)9, 5.1);
        total -= p[9];
        p[9] = 5.1;
        MultinomialTest.assertEquals((double)(total += 5.1), (double)table.getWeight(), (double)1.0E-9);
        for (i = 0; i < 10; ++i) {
            MultinomialTest.assertEquals((double)p[i], (double)table.getWeight((Object)i), (double)0.0);
            MultinomialTest.assertEquals((double)(p[i] / total), (double)table.getProbability((Object)i), (double)1.0E-10);
        }
        MultinomialTest.checkSelfConsistent((Multinomial<Integer>)table);
        for (i = 0; i < 10; ++i) {
            MultinomialTest.assertEquals((double)p[i], (double)table.getWeight((Object)i), (double)0.0);
        }
    }

    private static void checkSelfConsistent(Multinomial<Integer> table) {
        List weights = table.getWeights();
        double totalWeight = table.getWeight();
        double p = 0.0;
        int[] k = new int[weights.size()];
        Iterator i$ = weights.iterator();
        while (i$.hasNext()) {
            double weight = (Double)i$.next();
            if (weight > 0.0) {
                if (p > 0.0) {
                    int n = (Integer)table.sample(p - 1.0E-9);
                    k[n] = k[n] + 1;
                }
                int n = (Integer)table.sample(p + 1.0E-9);
                k[n] = k[n] + 1;
            }
            p += weight / totalWeight;
        }
        int n = (Integer)table.sample(p - 1.0E-9);
        k[n] = k[n] + 1;
        MultinomialTest.assertEquals((double)1.0, (double)p, (double)1.0E-9);
        for (int i = 0; i < weights.size(); ++i) {
            if (table.getWeight((Object)i) > 0.0) {
                MultinomialTest.assertEquals((long)2L, (long)k[i]);
                continue;
            }
            MultinomialTest.assertEquals((long)0L, (long)k[i]);
        }
    }
}

