/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorBinaryAggregate;
import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class VectorBinaryAggregateTest {
    private static final int CARDINALITY = 1000;
    private final DoubleDoubleFunction aggregator;
    private final DoubleDoubleFunction combiner;
    private final VectorBinaryAggregate operation;
    private final Vector first;
    private final Vector second;
    Random r = new Random();

    @Parameterized.Parameters
    public static Collection<Object[]> generateData() {
        ArrayList data = Lists.newArrayList();
        for (List entry : Sets.cartesianProduct((List)Lists.newArrayList((Object[])new ImmutableSet[]{ImmutableSet.of((Object)Functions.PLUS, (Object)Functions.PLUS_ABS, (Object)Functions.MAX), ImmutableSet.of((Object)Functions.PLUS, (Object)Functions.PLUS_ABS, (Object)Functions.MULT, (Object)Functions.MULT_RIGHT_PLUS1, (Object)Functions.MINUS), ImmutableSet.copyOf((Object[])VectorBinaryAggregate.OPERATIONS), ImmutableSet.of((Object)new SequentialAccessSparseVector(1000), (Object)new RandomAccessSparseVector(1000), (Object)new DenseVector(1000)), ImmutableSet.of((Object)new SequentialAccessSparseVector(1000), (Object)new RandomAccessSparseVector(1000), (Object)new DenseVector(1000))}))) {
            data.add(entry.toArray());
        }
        return data;
    }

    public VectorBinaryAggregateTest(DoubleDoubleFunction aggregator, DoubleDoubleFunction combiner, VectorBinaryAggregate operation, Vector first, Vector second) {
        this.aggregator = aggregator;
        this.combiner = combiner;
        this.operation = operation;
        this.first = first;
        this.second = second;
    }

    @Test
    public void testSelf() {
        int i;
        Vector x = this.first.like();
        DenseVector xBase = new DenseVector(1000);
        ArrayList items = Lists.newArrayList();
        for (i = 0; i < x.size(); ++i) {
            items.add(this.r.nextDouble());
        }
        for (i = 1; i < x.size(); ++i) {
            x.setQuick(i, ((Double)items.get(i)).doubleValue());
            xBase.setQuick(i, ((Double)items.get(i)).doubleValue());
        }
        Vector y = this.second.like().assign(x);
        DenseVector yBase = new DenseVector(x);
        System.out.printf("aggregator %s; combiner %s; operation %s\n", this.aggregator, this.combiner, this.operation);
        double expectedResult = this.combiner.apply(0.0, 0.0);
        for (int i2 = 1; i2 < x.size(); ++i2) {
            expectedResult = this.aggregator.apply(expectedResult, this.combiner.apply(((Double)items.get(i2)).doubleValue(), ((Double)items.get(i2)).doubleValue()));
        }
        double result = this.operation.aggregate(x, y, this.aggregator, this.combiner);
        double resultBase = this.operation.aggregate((Vector)xBase, (Vector)yBase, this.aggregator, this.combiner);
        Assert.assertEquals((double)expectedResult, (double)result, (double)0.0);
        Assert.assertEquals((double)resultBase, (double)result, (double)0.0);
    }

    @Test
    public void testSeparate() {
        ArrayList items1 = Lists.newArrayList();
        ArrayList items2 = Lists.newArrayList();
        for (int i = 0; i < 1000; ++i) {
            items1.add(this.r.nextDouble());
            items2.add(this.r.nextDouble());
        }
        Vector x = this.first.like();
        DenseVector xBase = new DenseVector(1000);
        for (int i = 0; i < x.size(); ++i) {
            x.setQuick(i, ((Double)items1.get(i)).doubleValue());
            xBase.setQuick(i, ((Double)items1.get(i)).doubleValue());
        }
        Vector y = this.second.like();
        DenseVector yBase = new DenseVector(1000);
        for (int i = 0; i < y.size(); ++i) {
            y.setQuick(i, ((Double)items2.get(i)).doubleValue());
            yBase.setQuick(i, ((Double)items2.get(i)).doubleValue());
        }
        System.out.printf("aggregator %s; combiner %s; operation %s\n", this.aggregator, this.combiner, this.operation);
        double expectedResult = this.combiner.apply(((Double)items1.get(0)).doubleValue(), ((Double)items2.get(0)).doubleValue());
        for (int i = 1; i < x.size(); ++i) {
            expectedResult = this.aggregator.apply(expectedResult, this.combiner.apply(((Double)items1.get(i)).doubleValue(), ((Double)items2.get(i)).doubleValue()));
        }
        double result = this.operation.aggregate(x, y, this.aggregator, this.combiner);
        double resultBase = this.operation.aggregate((Vector)xBase, (Vector)yBase, this.aggregator, this.combiner);
        Assert.assertEquals((double)expectedResult, (double)result, (double)0.0);
        Assert.assertEquals((double)resultBase, (double)result, (double)0.0);
    }
}

