/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.Algebra;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.SingularValueDecomposition;
import org.junit.Test;

public final class TestSingularValueDecomposition
extends MahoutTestCase {
    private final double[][] testSquare = new double[][]{{0.96, 1.72}, {2.28, 0.96}};
    private final double[][] testNonSquare = new double[][]{{-0.864, 1.5408, -0.3456}, {-2.768, -1.1904, 1.6128}, {-1.152, 2.0544, -0.4608}, {-0.576, 0.3072, 2.8096}};
    private static final double NORM_TOLERANCE = 1.0E-13;

    @Test
    public void testMoreRows() {
        double[] singularValues = new double[]{123.456, 2.3, 1.001, 0.999};
        int rows = singularValues.length + 2;
        int columns = singularValues.length;
        RandomWrapper r = RandomUtils.getRandom();
        SingularValueDecomposition svd = new SingularValueDecomposition(TestSingularValueDecomposition.createTestMatrix((Random)r, rows, columns, singularValues));
        double[] computedSV = svd.getSingularValues();
        TestSingularValueDecomposition.assertEquals((long)singularValues.length, (long)computedSV.length);
        for (int i = 0; i < singularValues.length; ++i) {
            TestSingularValueDecomposition.assertEquals((double)singularValues[i], (double)computedSV[i], (double)1.0E-10);
        }
    }

    @Test
    public void testMoreColumns() {
        double[] singularValues = new double[]{123.456, 2.3, 1.001, 0.999};
        int rows = singularValues.length;
        int columns = singularValues.length + 2;
        RandomWrapper r = RandomUtils.getRandom();
        SingularValueDecomposition svd = new SingularValueDecomposition(TestSingularValueDecomposition.createTestMatrix((Random)r, rows, columns, singularValues));
        double[] computedSV = svd.getSingularValues();
        TestSingularValueDecomposition.assertEquals((long)singularValues.length, (long)computedSV.length);
        for (int i = 0; i < singularValues.length; ++i) {
            TestSingularValueDecomposition.assertEquals((double)singularValues[i], (double)computedSV[i], (double)1.0E-10);
        }
    }

    @Test
    public void testDimensions() {
        DenseMatrix matrix = new DenseMatrix(this.testSquare);
        int m = matrix.numRows();
        int n = matrix.numCols();
        SingularValueDecomposition svd = new SingularValueDecomposition((Matrix)matrix);
        TestSingularValueDecomposition.assertEquals((long)m, (long)svd.getU().numRows());
        TestSingularValueDecomposition.assertEquals((long)m, (long)svd.getU().numCols());
        TestSingularValueDecomposition.assertEquals((long)m, (long)svd.getS().numCols());
        TestSingularValueDecomposition.assertEquals((long)n, (long)svd.getS().numCols());
        TestSingularValueDecomposition.assertEquals((long)n, (long)svd.getV().numRows());
        TestSingularValueDecomposition.assertEquals((long)n, (long)svd.getV().numCols());
    }

    @Test
    public void testHadamard() {
        DenseMatrix matrix = new DenseMatrix((double[][])new double[][]{{7.5, 2.5, 4.5, 1.5}, {2.5, 7.5, 1.5, 4.5}, {4.5, 1.5, 7.5, 2.5}, {1.5, 4.5, 2.5, 7.5}});
        SingularValueDecomposition svd = new SingularValueDecomposition((Matrix)matrix);
        TestSingularValueDecomposition.assertEquals((double)16.0, (double)svd.getSingularValues()[0], (double)1.0E-14);
        TestSingularValueDecomposition.assertEquals((double)8.0, (double)svd.getSingularValues()[1], (double)1.0E-14);
        TestSingularValueDecomposition.assertEquals((double)4.0, (double)svd.getSingularValues()[2], (double)1.0E-14);
        TestSingularValueDecomposition.assertEquals((double)2.0, (double)svd.getSingularValues()[3], (double)1.0E-14);
        DenseMatrix fullCovariance = new DenseMatrix((double[][])new double[][]{{0.0830078125, -0.0498046875, -0.0732421875, 0.0439453125}, {-0.0498046875, 0.0830078125, 0.0439453125, -0.0732421875}, {-0.0732421875, 0.0439453125, 0.0830078125, -0.0498046875}, {0.0439453125, -0.0732421875, -0.0498046875, 0.0830078125}});
        TestSingularValueDecomposition.assertEquals((double)0.0, (double)Algebra.getNorm((Matrix)fullCovariance.minus(svd.getCovariance(0.0))), (double)1.0E-14);
        DenseMatrix halfCovariance = new DenseMatrix((double[][])new double[][]{{0.0048828125, -0.0029296875, 0.0048828125, -0.0029296875}, {-0.0029296875, 0.0048828125, -0.0029296875, 0.0048828125}, {0.0048828125, -0.0029296875, 0.0048828125, -0.0029296875}, {-0.0029296875, 0.0048828125, -0.0029296875, 0.0048828125}});
        TestSingularValueDecomposition.assertEquals((double)0.0, (double)Algebra.getNorm((Matrix)halfCovariance.minus(svd.getCovariance(6.0))), (double)1.0E-14);
    }

    @Test
    public void testAEqualUSVt() {
        TestSingularValueDecomposition.checkAEqualUSVt((Matrix)new DenseMatrix(this.testSquare));
        TestSingularValueDecomposition.checkAEqualUSVt((Matrix)new DenseMatrix(this.testNonSquare));
        TestSingularValueDecomposition.checkAEqualUSVt(new DenseMatrix(this.testNonSquare).transpose());
    }

    public static void checkAEqualUSVt(Matrix matrix) {
        SingularValueDecomposition svd = new SingularValueDecomposition(matrix);
        Matrix u = svd.getU();
        Matrix s = svd.getS();
        Matrix v = svd.getV();
        if (s.numRows() < matrix.numRows()) {
            int j;
            int i;
            DenseMatrix sp = new DenseMatrix(s.numRows() + 1, s.numCols());
            DenseMatrix up = new DenseMatrix(u.numRows(), u.numCols() + 1);
            for (i = 0; i < u.numRows(); ++i) {
                for (j = 0; j < u.numCols(); ++j) {
                    up.set(i, j, u.get(i, j));
                }
            }
            for (i = 0; i < s.numRows(); ++i) {
                for (j = 0; j < s.numCols(); ++j) {
                    sp.set(i, j, s.get(i, j));
                }
            }
            u = up;
            s = sp;
        }
        double norm = Algebra.getNorm((Matrix)u.times(s).times(v.transpose()).minus(matrix));
        TestSingularValueDecomposition.assertEquals((double)0.0, (double)norm, (double)1.0E-13);
    }

    @Test
    public void testUOrthogonal() {
        TestSingularValueDecomposition.checkOrthogonal(new SingularValueDecomposition((Matrix)new DenseMatrix(this.testSquare)).getU());
        TestSingularValueDecomposition.checkOrthogonal(new SingularValueDecomposition((Matrix)new DenseMatrix(this.testNonSquare)).getU());
        TestSingularValueDecomposition.checkOrthogonal(new SingularValueDecomposition(new DenseMatrix(this.testNonSquare).transpose()).getU());
    }

    @Test
    public void testVOrthogonal() {
        TestSingularValueDecomposition.checkOrthogonal(new SingularValueDecomposition((Matrix)new DenseMatrix(this.testSquare)).getV());
        TestSingularValueDecomposition.checkOrthogonal(new SingularValueDecomposition((Matrix)new DenseMatrix(this.testNonSquare)).getV());
        TestSingularValueDecomposition.checkOrthogonal(new SingularValueDecomposition(new DenseMatrix(this.testNonSquare).transpose()).getV());
    }

    public static void checkOrthogonal(Matrix m) {
        Matrix mTm = m.transpose().times(m);
        DenseMatrix id = new DenseMatrix(mTm.numRows(), mTm.numRows());
        for (int i = 0; i < mTm.numRows(); ++i) {
            id.set(i, i, 1.0);
        }
        TestSingularValueDecomposition.assertEquals((double)0.0, (double)Algebra.getNorm((Matrix)mTm.minus((Matrix)id)), (double)1.0E-13);
    }

    @Test
    public void testMatricesValues1() {
        SingularValueDecomposition svd = new SingularValueDecomposition((Matrix)new DenseMatrix(this.testSquare));
        DenseMatrix uRef = new DenseMatrix((double[][])new double[][]{{0.6, 0.8}, {0.8, -0.6}});
        DenseMatrix sRef = new DenseMatrix((double[][])new double[][]{{3.0, 0.0}, {0.0, 1.0}});
        DenseMatrix vRef = new DenseMatrix((double[][])new double[][]{{0.8, -0.6}, {0.6, 0.8}});
        Matrix u = svd.getU();
        TestSingularValueDecomposition.assertEquals((double)0.0, (double)Algebra.getNorm((Matrix)u.minus((Matrix)uRef)), (double)1.0E-13);
        Matrix s = svd.getS();
        TestSingularValueDecomposition.assertEquals((double)0.0, (double)Algebra.getNorm((Matrix)s.minus((Matrix)sRef)), (double)1.0E-13);
        Matrix v = svd.getV();
        TestSingularValueDecomposition.assertEquals((double)0.0, (double)Algebra.getNorm((Matrix)v.minus((Matrix)vRef)), (double)1.0E-13);
    }

    @Test
    public void testConditionNumber() {
        SingularValueDecomposition svd = new SingularValueDecomposition((Matrix)new DenseMatrix(this.testSquare));
        TestSingularValueDecomposition.assertEquals((double)3.0, (double)svd.cond(), (double)1.5E-15);
    }

    private static Matrix createTestMatrix(Random r, int rows, int columns, double[] singularValues) {
        Matrix u = TestSingularValueDecomposition.createOrthogonalMatrix(r, rows);
        Matrix d = TestSingularValueDecomposition.createDiagonalMatrix(singularValues, rows, columns);
        Matrix v = TestSingularValueDecomposition.createOrthogonalMatrix(r, columns);
        return u.times(d).times(v);
    }

    public static Matrix createOrthogonalMatrix(Random r, int size) {
        double[][] data = new double[size][size];
        for (int i = 0; i < size; ++i) {
            double norm2;
            double[] dataI = data[i];
            do {
                for (int j = 0; j < size; ++j) {
                    dataI[j] = 2.0 * r.nextDouble() - 1.0;
                }
                for (int k = 0; k < i; ++k) {
                    int j;
                    double[] dataK = data[k];
                    double dotProduct = 0.0;
                    for (j = 0; j < size; ++j) {
                        dotProduct += dataI[j] * dataK[j];
                    }
                    for (j = 0; j < size; ++j) {
                        int n = j;
                        dataI[n] = dataI[n] - dotProduct * dataK[j];
                    }
                }
                norm2 = 0.0;
                for (double dataIJ : dataI) {
                    norm2 += dataIJ * dataIJ;
                }
                double inv = 1.0 / Math.sqrt(norm2);
                int j = 0;
                while (j < size) {
                    int n = j++;
                    dataI[n] = dataI[n] * inv;
                }
            } while (norm2 * (double)size < 0.01);
        }
        return new DenseMatrix(data);
    }

    public static Matrix createDiagonalMatrix(double[] diagonal, int rows, int columns) {
        double[][] dData = new double[rows][columns];
        for (int i = 0; i < Math.min(rows, columns); ++i) {
            dData[i][i] = diagonal[i];
        }
        return new DenseMatrix(dData);
    }
}

