/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.AbstractVectorTest;
import org.apache.mahout.math.Centroid;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.WeightedVector;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.random.MultiNormal;
import org.junit.Test;

public class CentroidTest
extends AbstractVectorTest<Centroid> {
    @Test
    public void testUpdate() {
        MultiNormal f = new MultiNormal(20);
        Vector a = f.sample();
        Vector b = f.sample();
        Vector c = f.sample();
        DenseVector x = new DenseVector(a);
        Centroid x1 = new Centroid(1, (Vector)x);
        x1.update((Vector)new Centroid(2, (Vector)new DenseVector(b)));
        Centroid x2 = new Centroid((WeightedVector)x1);
        x1.update(c);
        Vector mean = a.plus(b).plus(c).assign(Functions.div((double)3.0));
        CentroidTest.assertEquals((double)0.0, (double)x1.getVector().minus(mean).norm(1.0), (double)1.0E-8);
        CentroidTest.assertEquals((double)3.0, (double)x1.getWeight(), (double)0.0);
        CentroidTest.assertEquals((double)0.0, (double)x2.minus(a.plus(b).divide(2.0)).norm(1.0), (double)1.0E-8);
        CentroidTest.assertEquals((double)2.0, (double)x2.getWeight(), (double)0.0);
        CentroidTest.assertEquals((double)0.0, (double)new Centroid(x1.getIndex(), (Vector)x1, x1.getWeight()).minus((Vector)x1).norm(1.0), (double)1.0E-8);
        CentroidTest.assertEquals((double)0.0, (double)x.minus((Vector)x1).norm(1.0), (double)0.0);
        CentroidTest.assertEquals((double)3.0, (double)x1.getWeight(), (double)1.0E-8);
        CentroidTest.assertEquals((long)1L, (long)x1.getIndex());
    }

    @Override
    public Centroid vectorToTest(int size) {
        return new Centroid(new WeightedVector((Vector)new DenseVector(size), 3.15, 51));
    }

    @Override
    public void testSize() {
        CentroidTest.assertEquals((String)"size", (long)3L, (long)this.getTestVector().getNumNonZeroElements());
    }

    @Override
    Vector generateTestVector(int cardinality) {
        return new Centroid(new WeightedVector((Vector)new DenseVector(cardinality), 3.14, 53));
    }
}

