/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.stats;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.List;
import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.stats.LogLikelihood;
import org.junit.Test;

public final class LogLikelihoodTest
extends MahoutTestCase {
    @Test
    public void testEntropy() throws Exception {
        LogLikelihoodTest.assertEquals((double)1.386294, (double)LogLikelihood.entropy((long[])new long[]{1L, 1L}), (double)1.0E-4);
        LogLikelihoodTest.assertEquals((double)0.0, (double)LogLikelihood.entropy((long[])new long[]{1L}), (double)0.0);
        try {
            LogLikelihood.entropy((long[])new long[]{-1L, -1L});
            LogLikelihoodTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLogLikelihood() throws Exception {
        LogLikelihoodTest.assertEquals((double)2.772589, (double)LogLikelihood.logLikelihoodRatio((long)1L, (long)0L, (long)0L, (long)1L), (double)1.0E-6);
        LogLikelihoodTest.assertEquals((double)27.72589, (double)LogLikelihood.logLikelihoodRatio((long)10L, (long)0L, (long)0L, (long)10L), (double)1.0E-5);
        LogLikelihoodTest.assertEquals((double)39.33052, (double)LogLikelihood.logLikelihoodRatio((long)5L, (long)1995L, (long)0L, (long)100000L), (double)1.0E-5);
        LogLikelihoodTest.assertEquals((double)4730.737, (double)LogLikelihood.logLikelihoodRatio((long)1000L, (long)1995L, (long)1000L, (long)100000L), (double)0.001);
        LogLikelihoodTest.assertEquals((double)5734.343, (double)LogLikelihood.logLikelihoodRatio((long)1000L, (long)1000L, (long)1000L, (long)100000L), (double)0.001);
        LogLikelihoodTest.assertEquals((double)5714.932, (double)LogLikelihood.logLikelihoodRatio((long)1000L, (long)1000L, (long)1000L, (long)99000L), (double)0.001);
    }

    @Test
    public void testRootLogLikelihood() throws Exception {
        LogLikelihoodTest.assertTrue((LogLikelihood.rootLogLikelihoodRatio((long)904L, (long)21060L, (long)1144L, (long)283012L) > 0.0 ? 1 : 0) != 0);
        LogLikelihoodTest.assertTrue((LogLikelihood.rootLogLikelihoodRatio((long)36L, (long)21928L, (long)60280L, (long)623876L) < 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testRootNegativeLLR() {
        LogLikelihoodTest.assertTrue((LogLikelihood.rootLogLikelihoodRatio((long)6L, (long)7567L, (long)1924L, (long)2426487L) > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testFrequencyComparison() {
        final Random rand = RandomUtils.getRandom();
        Vector p1 = new DenseVector(25).assign(new DoubleFunction(){

            public double apply(double arg1) {
                return -Math.log1p(-rand.nextDouble());
            }
        });
        Vector p2 = p1.like().assign(p1);
        p1.viewPart(0, 5).assign(0.0);
        p1.viewPart(5, 3).assign(Functions.mult((double)4.0));
        p1.assign(Functions.div((double)p1.norm(1.0)));
        p2.assign(Functions.div((double)p2.norm(1.0)));
        HashMultiset w1 = HashMultiset.create();
        for (int i = 0; i < 100; ++i) {
            w1.add((Object)LogLikelihoodTest.sample(p1, rand));
        }
        HashMultiset w2 = HashMultiset.create();
        for (int i = 0; i < 1000; ++i) {
            w2.add((Object)LogLikelihoodTest.sample(p2, rand));
        }
        List r = LogLikelihood.compareFrequencies((Multiset)w1, (Multiset)w2, (int)8, (double)0.0);
        LogLikelihoodTest.assertTrue((r.size() <= 8 ? 1 : 0) != 0);
        LogLikelihoodTest.assertFalse((boolean)r.isEmpty());
        for (LogLikelihood.ScoredItem item : r) {
            LogLikelihoodTest.assertTrue((item.getScore() >= 0.0 ? 1 : 0) != 0);
        }
        LogLikelihoodTest.assertEquals((long)7L, (long)((Integer)((LogLikelihood.ScoredItem)r.get(0)).getItem()).intValue());
        double lastScore = ((LogLikelihood.ScoredItem)r.get(0)).getScore();
        for (LogLikelihood.ScoredItem item : r) {
            LogLikelihoodTest.assertTrue((item.getScore() <= lastScore ? 1 : 0) != 0);
            lastScore = item.getScore();
        }
        r = LogLikelihood.compareFrequencies((Multiset)w1, (Multiset)w2, (int)40, (double)1.0);
        LogLikelihoodTest.assertEquals((long)3L, (long)r.size());
        LogLikelihoodTest.assertEquals((long)7L, (long)((Integer)((LogLikelihood.ScoredItem)r.get(0)).getItem()).intValue());
        LogLikelihoodTest.assertEquals((long)5L, (long)((Integer)((LogLikelihood.ScoredItem)r.get(1)).getItem()).intValue());
        LogLikelihoodTest.assertEquals((long)6L, (long)((Integer)((LogLikelihood.ScoredItem)r.get(2)).getItem()).intValue());
        r = LogLikelihood.compareFrequencies((Multiset)w1, (Multiset)w2, (int)1000, (double)-100.0);
        HashMultiset k = HashMultiset.create();
        for (LogLikelihood.ScoredItem item : r) {
            k.add(item.getItem());
        }
        for (int i = 0; i < 25; ++i) {
            LogLikelihoodTest.assertTrue((String)("i = " + i), (k.count((Object)i) == 1 || w2.count((Object)i) == 0 ? 1 : 0) != 0);
        }
        LogLikelihoodTest.assertEquals((long)w2.elementSet().size(), (long)r.size());
        LogLikelihoodTest.assertEquals((long)7L, (long)((Integer)((LogLikelihood.ScoredItem)r.get(0)).getItem()).intValue());
        LogLikelihoodTest.assertEquals((long)5L, (long)((Integer)((LogLikelihood.ScoredItem)r.get(1)).getItem()).intValue());
        LogLikelihoodTest.assertEquals((long)6L, (long)((Integer)((LogLikelihood.ScoredItem)r.get(2)).getItem()).intValue());
        LogLikelihoodTest.assertTrue((((LogLikelihood.ScoredItem)r.get(r.size() - 1)).getScore() < 0.0 ? 1 : 0) != 0);
        lastScore = ((LogLikelihood.ScoredItem)r.get(0)).getScore();
        for (LogLikelihood.ScoredItem item : r) {
            LogLikelihoodTest.assertTrue((item.getScore() <= lastScore ? 1 : 0) != 0);
            lastScore = item.getScore();
        }
    }

    private static int sample(Vector p, Random rand) {
        double u = rand.nextDouble();
        for (int i = 0; i < p.size(); ++i) {
            if (u <= p.get(i)) {
                return i;
            }
            u -= p.get(i);
        }
        return p.size() - 1;
    }
}

