/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.solver;

import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.solver.EigenDecomposition;
import org.junit.Assert;
import org.junit.Test;

public class EigenDecompositionTest {
    @Test
    public void testDegenerateMatrix() {
        double[][] m = new double[][]{{0.641284, 0.767303, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.767303, 3.050159, 2.561342, 0.0, 0.0, 0.0, 0.0}, {0.0, 2.561342, 5.000609, 0.810507, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.810507, 0.550477, 0.142853, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.142853, 0.254566, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.256073, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
        DenseMatrix x = new DenseMatrix((double[][])m);
        EigenDecomposition eig = new EigenDecomposition((Matrix)x, true);
        Matrix d = eig.getD();
        Matrix v = eig.getV();
        this.check("EigenvalueDecomposition (evil)...", x.times(v), v.times(d));
    }

    @Test
    public void testDeficientRank() {
        Matrix a = new DenseMatrix(10, 3).assign(new DoubleFunction(){
            Random gen = RandomUtils.getRandom();

            public double apply(double arg1) {
                return this.gen.nextGaussian();
            }
        });
        a = a.transpose().times(a);
        EigenDecomposition eig = new EigenDecomposition(a);
        Matrix d = eig.getD();
        Matrix v = eig.getV();
        this.check("EigenvalueDecomposition (rank deficient)...", a.times(v), v.times(d));
        Assert.assertEquals((double)0.0, (double)eig.getImagEigenvalues().norm(1.0), (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)eig.getRealEigenvalues().norm(0.0), (double)1.0E-10);
    }

    @Test
    public void testEigen() {
        double[] evals = new double[]{0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 2.0E-7, 0.0, 0.0, -2.0E-7, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0};
        int i = 0;
        DenseMatrix a = new DenseMatrix(4, 4);
        for (MatrixSlice row : a) {
            for (Vector.Element element : row.vector()) {
                element.set(evals[i++]);
            }
        }
        EigenDecomposition eig = new EigenDecomposition((Matrix)a);
        Matrix d = eig.getD();
        Matrix v = eig.getV();
        this.check("EigenvalueDecomposition (nonsymmetric)...", a.times(v), v.times(d));
    }

    @Test
    public void testSequential() {
        int validld = 3;
        DenseMatrix A = new DenseMatrix(validld, validld);
        double[] columnwise = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0};
        int i = 0;
        for (MatrixSlice row : A) {
            for (Vector.Element element : row.vector()) {
                element.set(columnwise[i++]);
            }
        }
        EigenDecomposition Eig = new EigenDecomposition((Matrix)A);
        Matrix D = Eig.getD();
        Matrix V = Eig.getV();
        this.check("EigenvalueDecomposition (nonsymmetric)...", A.times(V), V.times(D));
        A = A.transpose().times((Matrix)A);
        Eig = new EigenDecomposition((Matrix)A);
        D = Eig.getD();
        V = Eig.getV();
        this.check("EigenvalueDecomposition (symmetric)...", A.times(V), V.times(D));
    }

    private void check(String msg, Matrix a, Matrix b) {
        Assert.assertEquals((String)msg, (double)0.0, (double)a.minus(b).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-10);
    }
}

