/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.set;

import java.util.Arrays;
import org.apache.mahout.math.function.ShortProcedure;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.map.PrimeFinder;
import org.apache.mahout.math.set.OpenShortHashSet;
import org.junit.Assert;
import org.junit.Test;

public class OpenShortHashSetTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenShortHashSet map = new OpenShortHashSet();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortHashSetTest.assertEquals((long)277L, (long)capacity[0]);
        OpenShortHashSetTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenShortHashSetTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenShortHashSet(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortHashSetTest.assertEquals((long)prime, (long)capacity[0]);
        OpenShortHashSetTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenShortHashSetTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenShortHashSet(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortHashSetTest.assertEquals((long)prime, (long)capacity[0]);
        OpenShortHashSetTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenShortHashSetTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenShortHashSet map = new OpenShortHashSet();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortHashSetTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenShortHashSet map = new OpenShortHashSet();
        map.add((short)11);
        OpenShortHashSetTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenShortHashSetTest.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testClone() {
        OpenShortHashSet map = new OpenShortHashSet();
        map.add((short)11);
        OpenShortHashSet map2 = (OpenShortHashSet)map.clone();
        map.clear();
        OpenShortHashSetTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContains() {
        OpenShortHashSet map = new OpenShortHashSet();
        map.add((short)11);
        OpenShortHashSetTest.assertTrue((boolean)map.contains((short)11));
        OpenShortHashSetTest.assertFalse((boolean)map.contains((short)12));
    }

    @Test
    public void testForEachKey() {
        final ShortArrayList keys = new ShortArrayList();
        OpenShortHashSet map = new OpenShortHashSet();
        map.add((short)11);
        map.add((short)12);
        map.add((short)13);
        map.add((short)14);
        map.remove((short)13);
        map.forEachKey(new ShortProcedure(){

            public boolean apply(short element) {
                keys.add(element);
                return true;
            }
        });
        short[] keysArray = keys.toArray(new short[keys.size()]);
        Arrays.sort(keysArray);
        OpenShortHashSetTest.assertArrayEquals((short[])new short[]{11, 12, 14}, (short[])keysArray);
    }

    @Test
    public void testKeys() {
        OpenShortHashSet map = new OpenShortHashSet();
        map.add((short)11);
        map.add((short)12);
        ShortArrayList keys = new ShortArrayList();
        map.keys(keys);
        keys.sort();
        OpenShortHashSetTest.assertEquals((long)11L, (long)keys.get(0));
        OpenShortHashSetTest.assertEquals((long)12L, (long)keys.get(1));
        ShortArrayList k2 = map.keys();
        k2.sort();
        OpenShortHashSetTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testCopy() {
        OpenShortHashSet map = new OpenShortHashSet();
        map.add((short)11);
        OpenShortHashSet map2 = (OpenShortHashSet)map.copy();
        map.clear();
        OpenShortHashSetTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenShortHashSet map = new OpenShortHashSet();
        map.add((short)11);
        map.add((short)12);
        map.add((short)13);
        map.add((short)14);
        map.remove((short)13);
        OpenShortHashSet map2 = (OpenShortHashSet)map.copy();
        OpenShortHashSetTest.assertTrue((boolean)map.equals((Object)map2));
        OpenShortHashSetTest.assertTrue((boolean)map2.equals((Object)map));
        OpenShortHashSetTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenShortHashSetTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.remove((short)11);
        OpenShortHashSetTest.assertFalse((boolean)map.equals((Object)map2));
        OpenShortHashSetTest.assertFalse((boolean)map2.equals((Object)map));
    }
}

