/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.set;

import java.util.Arrays;
import org.apache.mahout.math.function.LongProcedure;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.map.PrimeFinder;
import org.apache.mahout.math.set.OpenLongHashSet;
import org.junit.Assert;
import org.junit.Test;

public class OpenLongHashSetTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenLongHashSet map = new OpenLongHashSet();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongHashSetTest.assertEquals((long)277L, (long)capacity[0]);
        OpenLongHashSetTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenLongHashSetTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenLongHashSet(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongHashSetTest.assertEquals((long)prime, (long)capacity[0]);
        OpenLongHashSetTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenLongHashSetTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenLongHashSet(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongHashSetTest.assertEquals((long)prime, (long)capacity[0]);
        OpenLongHashSetTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenLongHashSetTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenLongHashSet map = new OpenLongHashSet();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongHashSetTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenLongHashSet map = new OpenLongHashSet();
        map.add(11L);
        OpenLongHashSetTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenLongHashSetTest.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testClone() {
        OpenLongHashSet map = new OpenLongHashSet();
        map.add(11L);
        OpenLongHashSet map2 = (OpenLongHashSet)map.clone();
        map.clear();
        OpenLongHashSetTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContains() {
        OpenLongHashSet map = new OpenLongHashSet();
        map.add(11L);
        OpenLongHashSetTest.assertTrue((boolean)map.contains(11L));
        OpenLongHashSetTest.assertFalse((boolean)map.contains(12L));
    }

    @Test
    public void testForEachKey() {
        final LongArrayList keys = new LongArrayList();
        OpenLongHashSet map = new OpenLongHashSet();
        map.add(11L);
        map.add(12L);
        map.add(13L);
        map.add(14L);
        map.remove(13L);
        map.forEachKey(new LongProcedure(){

            public boolean apply(long element) {
                keys.add(element);
                return true;
            }
        });
        long[] keysArray = keys.toArray(new long[keys.size()]);
        Arrays.sort(keysArray);
        OpenLongHashSetTest.assertArrayEquals((long[])new long[]{11L, 12L, 14L}, (long[])keysArray);
    }

    @Test
    public void testKeys() {
        OpenLongHashSet map = new OpenLongHashSet();
        map.add(11L);
        map.add(12L);
        LongArrayList keys = new LongArrayList();
        map.keys(keys);
        keys.sort();
        OpenLongHashSetTest.assertEquals((long)11L, (long)keys.get(0));
        OpenLongHashSetTest.assertEquals((long)12L, (long)keys.get(1));
        LongArrayList k2 = map.keys();
        k2.sort();
        OpenLongHashSetTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testCopy() {
        OpenLongHashSet map = new OpenLongHashSet();
        map.add(11L);
        OpenLongHashSet map2 = (OpenLongHashSet)map.copy();
        map.clear();
        OpenLongHashSetTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenLongHashSet map = new OpenLongHashSet();
        map.add(11L);
        map.add(12L);
        map.add(13L);
        map.add(14L);
        map.remove(13L);
        OpenLongHashSet map2 = (OpenLongHashSet)map.copy();
        OpenLongHashSetTest.assertTrue((boolean)map.equals((Object)map2));
        OpenLongHashSetTest.assertTrue((boolean)map2.equals((Object)map));
        OpenLongHashSetTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenLongHashSetTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.remove(11L);
        OpenLongHashSetTest.assertFalse((boolean)map.equals((Object)map2));
        OpenLongHashSetTest.assertFalse((boolean)map2.equals((Object)map));
    }
}

