/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.set;

import java.util.Arrays;
import org.apache.mahout.math.function.IntProcedure;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.map.PrimeFinder;
import org.apache.mahout.math.set.OpenIntHashSet;
import org.junit.Assert;
import org.junit.Test;

public class OpenIntHashSetTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenIntHashSet map = new OpenIntHashSet();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntHashSetTest.assertEquals((long)277L, (long)capacity[0]);
        OpenIntHashSetTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenIntHashSetTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenIntHashSet(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntHashSetTest.assertEquals((long)prime, (long)capacity[0]);
        OpenIntHashSetTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenIntHashSetTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenIntHashSet(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntHashSetTest.assertEquals((long)prime, (long)capacity[0]);
        OpenIntHashSetTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenIntHashSetTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenIntHashSet map = new OpenIntHashSet();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntHashSetTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenIntHashSet map = new OpenIntHashSet();
        map.add(11);
        OpenIntHashSetTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenIntHashSetTest.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testClone() {
        OpenIntHashSet map = new OpenIntHashSet();
        map.add(11);
        OpenIntHashSet map2 = (OpenIntHashSet)map.clone();
        map.clear();
        OpenIntHashSetTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContains() {
        OpenIntHashSet map = new OpenIntHashSet();
        map.add(11);
        OpenIntHashSetTest.assertTrue((boolean)map.contains(11));
        OpenIntHashSetTest.assertFalse((boolean)map.contains(12));
    }

    @Test
    public void testForEachKey() {
        final IntArrayList keys = new IntArrayList();
        OpenIntHashSet map = new OpenIntHashSet();
        map.add(11);
        map.add(12);
        map.add(13);
        map.add(14);
        map.remove(13);
        map.forEachKey(new IntProcedure(){

            public boolean apply(int element) {
                keys.add(element);
                return true;
            }
        });
        int[] keysArray = keys.toArray(new int[keys.size()]);
        Arrays.sort(keysArray);
        OpenIntHashSetTest.assertArrayEquals((int[])new int[]{11, 12, 14}, (int[])keysArray);
    }

    @Test
    public void testKeys() {
        OpenIntHashSet map = new OpenIntHashSet();
        map.add(11);
        map.add(12);
        IntArrayList keys = new IntArrayList();
        map.keys(keys);
        keys.sort();
        OpenIntHashSetTest.assertEquals((long)11L, (long)keys.get(0));
        OpenIntHashSetTest.assertEquals((long)12L, (long)keys.get(1));
        IntArrayList k2 = map.keys();
        k2.sort();
        OpenIntHashSetTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testCopy() {
        OpenIntHashSet map = new OpenIntHashSet();
        map.add(11);
        OpenIntHashSet map2 = (OpenIntHashSet)map.copy();
        map.clear();
        OpenIntHashSetTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenIntHashSet map = new OpenIntHashSet();
        map.add(11);
        map.add(12);
        map.add(13);
        map.add(14);
        map.remove(13);
        OpenIntHashSet map2 = (OpenIntHashSet)map.copy();
        OpenIntHashSetTest.assertTrue((boolean)map.equals((Object)map2));
        OpenIntHashSetTest.assertTrue((boolean)map2.equals((Object)map));
        OpenIntHashSetTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenIntHashSetTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.remove(11);
        OpenIntHashSetTest.assertFalse((boolean)map.equals((Object)map2));
        OpenIntHashSetTest.assertFalse((boolean)map2.equals((Object)map));
    }
}

