/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.set;

import java.util.Arrays;
import org.apache.mahout.math.function.FloatProcedure;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.map.PrimeFinder;
import org.apache.mahout.math.set.OpenFloatHashSet;
import org.junit.Assert;
import org.junit.Test;

public class OpenFloatHashSetTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenFloatHashSet map = new OpenFloatHashSet();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatHashSetTest.assertEquals((long)277L, (long)capacity[0]);
        OpenFloatHashSetTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenFloatHashSetTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenFloatHashSet(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatHashSetTest.assertEquals((long)prime, (long)capacity[0]);
        OpenFloatHashSetTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenFloatHashSetTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenFloatHashSet(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatHashSetTest.assertEquals((long)prime, (long)capacity[0]);
        OpenFloatHashSetTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenFloatHashSetTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenFloatHashSet map = new OpenFloatHashSet();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatHashSetTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenFloatHashSet map = new OpenFloatHashSet();
        map.add(11.0f);
        OpenFloatHashSetTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenFloatHashSetTest.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testClone() {
        OpenFloatHashSet map = new OpenFloatHashSet();
        map.add(11.0f);
        OpenFloatHashSet map2 = (OpenFloatHashSet)map.clone();
        map.clear();
        OpenFloatHashSetTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContains() {
        OpenFloatHashSet map = new OpenFloatHashSet();
        map.add(11.0f);
        OpenFloatHashSetTest.assertTrue((boolean)map.contains(11.0f));
        OpenFloatHashSetTest.assertFalse((boolean)map.contains(12.0f));
    }

    @Test
    public void testForEachKey() {
        final FloatArrayList keys = new FloatArrayList();
        OpenFloatHashSet map = new OpenFloatHashSet();
        map.add(11.0f);
        map.add(12.0f);
        map.add(13.0f);
        map.add(14.0f);
        map.remove(13.0f);
        map.forEachKey(new FloatProcedure(){

            public boolean apply(float element) {
                keys.add(element);
                return true;
            }
        });
        float[] keysArray = keys.toArray(new float[keys.size()]);
        Arrays.sort(keysArray);
        OpenFloatHashSetTest.assertArrayEquals((float[])new float[]{11.0f, 12.0f, 14.0f}, (float[])keysArray, (float)1.0E-6f);
    }

    @Test
    public void testKeys() {
        OpenFloatHashSet map = new OpenFloatHashSet();
        map.add(11.0f);
        map.add(12.0f);
        FloatArrayList keys = new FloatArrayList();
        map.keys(keys);
        keys.sort();
        OpenFloatHashSetTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6f);
        OpenFloatHashSetTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6f);
        FloatArrayList k2 = map.keys();
        k2.sort();
        OpenFloatHashSetTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testCopy() {
        OpenFloatHashSet map = new OpenFloatHashSet();
        map.add(11.0f);
        OpenFloatHashSet map2 = (OpenFloatHashSet)map.copy();
        map.clear();
        OpenFloatHashSetTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenFloatHashSet map = new OpenFloatHashSet();
        map.add(11.0f);
        map.add(12.0f);
        map.add(13.0f);
        map.add(14.0f);
        map.remove(13.0f);
        OpenFloatHashSet map2 = (OpenFloatHashSet)map.copy();
        OpenFloatHashSetTest.assertTrue((boolean)map.equals((Object)map2));
        OpenFloatHashSetTest.assertTrue((boolean)map2.equals((Object)map));
        OpenFloatHashSetTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenFloatHashSetTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.remove(11.0f);
        OpenFloatHashSetTest.assertFalse((boolean)map.equals((Object)map2));
        OpenFloatHashSetTest.assertFalse((boolean)map2.equals((Object)map));
    }
}

