/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.set;

import java.util.Arrays;
import org.apache.mahout.math.function.DoubleProcedure;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.map.PrimeFinder;
import org.apache.mahout.math.set.OpenDoubleHashSet;
import org.junit.Assert;
import org.junit.Test;

public class OpenDoubleHashSetTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenDoubleHashSet map = new OpenDoubleHashSet();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleHashSetTest.assertEquals((long)277L, (long)capacity[0]);
        OpenDoubleHashSetTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenDoubleHashSetTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenDoubleHashSet(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleHashSetTest.assertEquals((long)prime, (long)capacity[0]);
        OpenDoubleHashSetTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenDoubleHashSetTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenDoubleHashSet(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleHashSetTest.assertEquals((long)prime, (long)capacity[0]);
        OpenDoubleHashSetTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenDoubleHashSetTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenDoubleHashSet map = new OpenDoubleHashSet();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenDoubleHashSetTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenDoubleHashSet map = new OpenDoubleHashSet();
        map.add(11.0);
        OpenDoubleHashSetTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenDoubleHashSetTest.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testClone() {
        OpenDoubleHashSet map = new OpenDoubleHashSet();
        map.add(11.0);
        OpenDoubleHashSet map2 = (OpenDoubleHashSet)map.clone();
        map.clear();
        OpenDoubleHashSetTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContains() {
        OpenDoubleHashSet map = new OpenDoubleHashSet();
        map.add(11.0);
        OpenDoubleHashSetTest.assertTrue((boolean)map.contains(11.0));
        OpenDoubleHashSetTest.assertFalse((boolean)map.contains(12.0));
    }

    @Test
    public void testForEachKey() {
        final DoubleArrayList keys = new DoubleArrayList();
        OpenDoubleHashSet map = new OpenDoubleHashSet();
        map.add(11.0);
        map.add(12.0);
        map.add(13.0);
        map.add(14.0);
        map.remove(13.0);
        map.forEachKey(new DoubleProcedure(){

            public boolean apply(double element) {
                keys.add(element);
                return true;
            }
        });
        double[] keysArray = keys.toArray(new double[keys.size()]);
        Arrays.sort(keysArray);
        OpenDoubleHashSetTest.assertArrayEquals((double[])new double[]{11.0, 12.0, 14.0}, (double[])keysArray, (double)1.0E-6);
    }

    @Test
    public void testKeys() {
        OpenDoubleHashSet map = new OpenDoubleHashSet();
        map.add(11.0);
        map.add(12.0);
        DoubleArrayList keys = new DoubleArrayList();
        map.keys(keys);
        keys.sort();
        OpenDoubleHashSetTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6);
        OpenDoubleHashSetTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6);
        DoubleArrayList k2 = map.keys();
        k2.sort();
        OpenDoubleHashSetTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testCopy() {
        OpenDoubleHashSet map = new OpenDoubleHashSet();
        map.add(11.0);
        OpenDoubleHashSet map2 = (OpenDoubleHashSet)map.copy();
        map.clear();
        OpenDoubleHashSetTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenDoubleHashSet map = new OpenDoubleHashSet();
        map.add(11.0);
        map.add(12.0);
        map.add(13.0);
        map.add(14.0);
        map.remove(13.0);
        OpenDoubleHashSet map2 = (OpenDoubleHashSet)map.copy();
        OpenDoubleHashSetTest.assertTrue((boolean)map.equals((Object)map2));
        OpenDoubleHashSetTest.assertTrue((boolean)map2.equals((Object)map));
        OpenDoubleHashSetTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenDoubleHashSetTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.remove(11.0);
        OpenDoubleHashSetTest.assertFalse((boolean)map.equals((Object)map2));
        OpenDoubleHashSetTest.assertFalse((boolean)map2.equals((Object)map));
    }
}

