/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.set;

import java.util.Arrays;
import org.apache.mahout.math.function.CharProcedure;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.map.PrimeFinder;
import org.apache.mahout.math.set.OpenCharHashSet;
import org.junit.Assert;
import org.junit.Test;

public class OpenCharHashSetTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenCharHashSet map = new OpenCharHashSet();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharHashSetTest.assertEquals((long)277L, (long)capacity[0]);
        OpenCharHashSetTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenCharHashSetTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenCharHashSet(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharHashSetTest.assertEquals((long)prime, (long)capacity[0]);
        OpenCharHashSetTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenCharHashSetTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenCharHashSet(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharHashSetTest.assertEquals((long)prime, (long)capacity[0]);
        OpenCharHashSetTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenCharHashSetTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenCharHashSet map = new OpenCharHashSet();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenCharHashSetTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenCharHashSet map = new OpenCharHashSet();
        map.add('\u000b');
        OpenCharHashSetTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenCharHashSetTest.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testClone() {
        OpenCharHashSet map = new OpenCharHashSet();
        map.add('\u000b');
        OpenCharHashSet map2 = (OpenCharHashSet)map.clone();
        map.clear();
        OpenCharHashSetTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContains() {
        OpenCharHashSet map = new OpenCharHashSet();
        map.add('\u000b');
        OpenCharHashSetTest.assertTrue((boolean)map.contains('\u000b'));
        OpenCharHashSetTest.assertFalse((boolean)map.contains('\f'));
    }

    @Test
    public void testForEachKey() {
        final CharArrayList keys = new CharArrayList();
        OpenCharHashSet map = new OpenCharHashSet();
        map.add('\u000b');
        map.add('\f');
        map.add('\r');
        map.add('\u000e');
        map.remove('\r');
        map.forEachKey(new CharProcedure(){

            public boolean apply(char element) {
                keys.add(element);
                return true;
            }
        });
        char[] keysArray = keys.toArray(new char[keys.size()]);
        Arrays.sort(keysArray);
        OpenCharHashSetTest.assertArrayEquals((char[])new char[]{'\u000b', '\f', '\u000e'}, (char[])keysArray);
    }

    @Test
    public void testKeys() {
        OpenCharHashSet map = new OpenCharHashSet();
        map.add('\u000b');
        map.add('\f');
        CharArrayList keys = new CharArrayList();
        map.keys(keys);
        keys.sort();
        OpenCharHashSetTest.assertEquals((long)11L, (long)keys.get(0));
        OpenCharHashSetTest.assertEquals((long)12L, (long)keys.get(1));
        CharArrayList k2 = map.keys();
        k2.sort();
        OpenCharHashSetTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testCopy() {
        OpenCharHashSet map = new OpenCharHashSet();
        map.add('\u000b');
        OpenCharHashSet map2 = (OpenCharHashSet)map.copy();
        map.clear();
        OpenCharHashSetTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenCharHashSet map = new OpenCharHashSet();
        map.add('\u000b');
        map.add('\f');
        map.add('\r');
        map.add('\u000e');
        map.remove('\r');
        OpenCharHashSet map2 = (OpenCharHashSet)map.copy();
        OpenCharHashSetTest.assertTrue((boolean)map.equals((Object)map2));
        OpenCharHashSetTest.assertTrue((boolean)map2.equals((Object)map));
        OpenCharHashSetTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenCharHashSetTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.remove('\u000b');
        OpenCharHashSetTest.assertFalse((boolean)map.equals((Object)map2));
        OpenCharHashSetTest.assertFalse((boolean)map2.equals((Object)map));
    }
}

