/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.set;

import java.util.Arrays;
import org.apache.mahout.math.function.ByteProcedure;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.map.PrimeFinder;
import org.apache.mahout.math.set.OpenByteHashSet;
import org.junit.Assert;
import org.junit.Test;

public class OpenByteHashSetTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenByteHashSet map = new OpenByteHashSet();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteHashSetTest.assertEquals((long)277L, (long)capacity[0]);
        OpenByteHashSetTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenByteHashSetTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenByteHashSet(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteHashSetTest.assertEquals((long)prime, (long)capacity[0]);
        OpenByteHashSetTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenByteHashSetTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenByteHashSet(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteHashSetTest.assertEquals((long)prime, (long)capacity[0]);
        OpenByteHashSetTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenByteHashSetTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenByteHashSet map = new OpenByteHashSet();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenByteHashSetTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenByteHashSet map = new OpenByteHashSet();
        map.add((byte)11);
        OpenByteHashSetTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenByteHashSetTest.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testClone() {
        OpenByteHashSet map = new OpenByteHashSet();
        map.add((byte)11);
        OpenByteHashSet map2 = (OpenByteHashSet)map.clone();
        map.clear();
        OpenByteHashSetTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContains() {
        OpenByteHashSet map = new OpenByteHashSet();
        map.add((byte)11);
        OpenByteHashSetTest.assertTrue((boolean)map.contains((byte)11));
        OpenByteHashSetTest.assertFalse((boolean)map.contains((byte)12));
    }

    @Test
    public void testForEachKey() {
        final ByteArrayList keys = new ByteArrayList();
        OpenByteHashSet map = new OpenByteHashSet();
        map.add((byte)11);
        map.add((byte)12);
        map.add((byte)13);
        map.add((byte)14);
        map.remove((byte)13);
        map.forEachKey(new ByteProcedure(){

            public boolean apply(byte element) {
                keys.add(element);
                return true;
            }
        });
        byte[] keysArray = keys.toArray(new byte[keys.size()]);
        Arrays.sort(keysArray);
        OpenByteHashSetTest.assertArrayEquals((byte[])new byte[]{11, 12, 14}, (byte[])keysArray);
    }

    @Test
    public void testKeys() {
        OpenByteHashSet map = new OpenByteHashSet();
        map.add((byte)11);
        map.add((byte)12);
        ByteArrayList keys = new ByteArrayList();
        map.keys(keys);
        keys.sort();
        OpenByteHashSetTest.assertEquals((long)11L, (long)keys.get(0));
        OpenByteHashSetTest.assertEquals((long)12L, (long)keys.get(1));
        ByteArrayList k2 = map.keys();
        k2.sort();
        OpenByteHashSetTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testCopy() {
        OpenByteHashSet map = new OpenByteHashSet();
        map.add((byte)11);
        OpenByteHashSet map2 = (OpenByteHashSet)map.copy();
        map.clear();
        OpenByteHashSetTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenByteHashSet map = new OpenByteHashSet();
        map.add((byte)11);
        map.add((byte)12);
        map.add((byte)13);
        map.add((byte)14);
        map.remove((byte)13);
        OpenByteHashSet map2 = (OpenByteHashSet)map.copy();
        OpenByteHashSetTest.assertTrue((boolean)map.equals((Object)map2));
        OpenByteHashSetTest.assertTrue((boolean)map2.equals((Object)map));
        OpenByteHashSetTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenByteHashSetTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.remove((byte)11);
        OpenByteHashSetTest.assertFalse((boolean)map.equals((Object)map2));
        OpenByteHashSetTest.assertFalse((boolean)map2.equals((Object)map));
    }
}

