/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.ShortObjectProcedure;
import org.apache.mahout.math.function.ShortProcedure;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.map.OpenShortObjectHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OpenShortObjectHashMapTest
extends Assert {
    private TestClass item;
    private TestClass anotherItem;
    private TestClass anotherItem2;
    private TestClass anotherItem3;
    private TestClass anotherItem4;
    private TestClass anotherItem5;

    @Before
    public void before() {
        this.item = new TestClass(101);
        this.anotherItem = new TestClass(99);
        this.anotherItem2 = new TestClass(2);
        this.anotherItem3 = new TestClass(3);
        this.anotherItem4 = new TestClass(4);
        this.anotherItem5 = new TestClass(5);
    }

    @Test
    public void testConstructors() {
        OpenShortObjectHashMap map = new OpenShortObjectHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortObjectHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenShortObjectHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenShortObjectHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenShortObjectHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortObjectHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenShortObjectHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenShortObjectHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenShortObjectHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortObjectHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenShortObjectHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenShortObjectHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenShortObjectHashMap map = new OpenShortObjectHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortObjectHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenShortObjectHashMap map = new OpenShortObjectHashMap();
        map.put((short)11, (Object)this.item);
        OpenShortObjectHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenShortObjectHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenShortObjectHashMapTest.assertSame(null, (Object)map.get((short)11));
    }

    @Test
    public void testClone() {
        OpenShortObjectHashMap map = new OpenShortObjectHashMap();
        map.put((short)11, (Object)this.item);
        OpenShortObjectHashMap map2 = map.clone();
        map.clear();
        OpenShortObjectHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenShortObjectHashMap map = new OpenShortObjectHashMap();
        map.put((short)11, (Object)this.item);
        OpenShortObjectHashMapTest.assertTrue((boolean)map.containsKey((short)11));
        OpenShortObjectHashMapTest.assertFalse((boolean)map.containsKey((short)12));
    }

    @Test
    public void testContainValue() {
        OpenShortObjectHashMap map = new OpenShortObjectHashMap();
        map.put((short)11, (Object)this.item);
        OpenShortObjectHashMapTest.assertTrue((boolean)map.containsValue((Object)this.item));
        OpenShortObjectHashMapTest.assertFalse((boolean)map.containsValue((Object)this.anotherItem));
    }

    @Test
    public void testForEachKey() {
        final ShortArrayList keys = new ShortArrayList();
        OpenShortObjectHashMap map = new OpenShortObjectHashMap();
        map.put((short)11, (Object)this.anotherItem);
        map.put((short)12, (Object)this.anotherItem2);
        map.put((short)13, (Object)this.anotherItem3);
        map.put((short)14, (Object)this.anotherItem4);
        map.removeKey((short)13);
        map.forEachKey(new ShortProcedure(){

            public boolean apply(short element) {
                keys.add(element);
                return true;
            }
        });
        short[] keysArray = keys.toArray(new short[keys.size()]);
        Arrays.sort(keysArray);
        OpenShortObjectHashMapTest.assertArrayEquals((short[])new short[]{11, 12, 14}, (short[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenShortObjectHashMap map = new OpenShortObjectHashMap();
        map.put((short)11, (Object)this.anotherItem);
        map.put((short)12, (Object)this.anotherItem2);
        map.put((short)13, (Object)this.anotherItem3);
        map.put((short)14, (Object)this.anotherItem4);
        map.removeKey((short)13);
        map.forEachPair((ShortObjectProcedure)new ShortObjectProcedure<TestClass>(){

            public boolean apply(short first, TestClass second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenShortObjectHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenShortObjectHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenShortObjectHashMapTest.assertSame((Object)this.anotherItem, (Object)((Pair)pairs.get((int)0)).v);
        OpenShortObjectHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenShortObjectHashMapTest.assertSame((Object)this.anotherItem2, (Object)((Pair)pairs.get((int)1)).v);
        OpenShortObjectHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenShortObjectHashMapTest.assertSame((Object)this.anotherItem4, (Object)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair((ShortObjectProcedure)new ShortObjectProcedure<TestClass>(){
            int count = 0;

            public boolean apply(short first, TestClass second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenShortObjectHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenShortObjectHashMap map = new OpenShortObjectHashMap();
        map.put((short)11, (Object)this.item);
        map.put((short)12, (Object)this.anotherItem);
        OpenShortObjectHashMapTest.assertSame((Object)this.item, (Object)map.get((short)11));
        OpenShortObjectHashMapTest.assertSame(null, (Object)map.get((short)0));
    }

    @Test
    public void testKeys() {
        OpenShortObjectHashMap map = new OpenShortObjectHashMap();
        map.put((short)11, (Object)this.item);
        map.put((short)12, (Object)this.item);
        ShortArrayList keys = new ShortArrayList();
        map.keys(keys);
        keys.sort();
        OpenShortObjectHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenShortObjectHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        ShortArrayList k2 = map.keys();
        k2.sort();
        OpenShortObjectHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        ShortArrayList keyList = new ShortArrayList();
        ArrayList valueList = new ArrayList();
        OpenShortObjectHashMap map = new OpenShortObjectHashMap();
        map.put((short)11, (Object)this.anotherItem2);
        map.put((short)12, (Object)this.anotherItem3);
        map.put((short)13, (Object)this.anotherItem4);
        map.put((short)14, (Object)this.anotherItem5);
        map.removeKey((short)13);
        map.pairsMatching((ShortObjectProcedure)new ShortObjectProcedure<TestClass>(){

            public boolean apply(short first, TestClass second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        Collections.sort(valueList);
        OpenShortObjectHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenShortObjectHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenShortObjectHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenShortObjectHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenShortObjectHashMapTest.assertSame((Object)this.anotherItem3, valueList.get(0));
        OpenShortObjectHashMapTest.assertSame((Object)this.anotherItem5, valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenShortObjectHashMap map = new OpenShortObjectHashMap();
        map.put((short)11, (Object)this.anotherItem);
        map.put((short)12, (Object)this.anotherItem2);
        map.put((short)13, (Object)this.anotherItem3);
        map.put((short)14, (Object)this.anotherItem4);
        map.removeKey((short)13);
        ArrayList values = new ArrayList(100);
        map.values(values);
        OpenShortObjectHashMapTest.assertEquals((long)3L, (long)values.size());
        Collections.sort(values);
        OpenShortObjectHashMapTest.assertEquals((Object)this.anotherItem2, values.get(0));
        OpenShortObjectHashMapTest.assertEquals((Object)this.anotherItem4, values.get(1));
        OpenShortObjectHashMapTest.assertEquals((Object)this.anotherItem, values.get(2));
    }

    @Test
    public void testCopy() {
        OpenShortObjectHashMap map = new OpenShortObjectHashMap();
        map.put((short)11, (Object)this.item);
        OpenShortObjectHashMap map2 = (OpenShortObjectHashMap)map.copy();
        map.clear();
        OpenShortObjectHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenShortObjectHashMap map = new OpenShortObjectHashMap();
        map.put((short)11, (Object)this.anotherItem);
        map.put((short)12, (Object)this.anotherItem2);
        map.put((short)13, (Object)this.anotherItem3);
        map.put((short)14, (Object)this.anotherItem4);
        map.removeKey((short)13);
        OpenShortObjectHashMap map2 = (OpenShortObjectHashMap)map.copy();
        OpenShortObjectHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenShortObjectHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenShortObjectHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenShortObjectHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey((short)11);
        OpenShortObjectHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenShortObjectHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenShortObjectHashMap map = new OpenShortObjectHashMap();
        map.put((short)11, (Object)this.anotherItem5);
        map.put((short)12, (Object)this.anotherItem4);
        map.put((short)13, (Object)this.anotherItem3);
        map.put((short)14, (Object)this.anotherItem2);
        map.removeKey((short)13);
        ShortArrayList keys = new ShortArrayList();
        map.keysSortedByValue(keys);
        short[] keysArray = keys.toArray(new short[keys.size()]);
        OpenShortObjectHashMapTest.assertArrayEquals((short[])new short[]{14, 12, 11}, (short[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenShortObjectHashMap map = new OpenShortObjectHashMap();
        map.put((short)11, (Object)this.anotherItem5);
        map.put((short)12, (Object)this.anotherItem4);
        map.put((short)13, (Object)this.anotherItem3);
        map.put((short)14, (Object)this.anotherItem2);
        ShortArrayList keys = new ShortArrayList();
        ArrayList values = new ArrayList();
        map.pairsSortedByKey(keys, values);
        OpenShortObjectHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenShortObjectHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenShortObjectHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenShortObjectHashMapTest.assertSame((Object)this.anotherItem5, values.get(0));
        OpenShortObjectHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenShortObjectHashMapTest.assertSame((Object)this.anotherItem4, values.get(1));
        OpenShortObjectHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenShortObjectHashMapTest.assertSame((Object)this.anotherItem3, values.get(2));
        OpenShortObjectHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenShortObjectHashMapTest.assertSame((Object)this.anotherItem2, values.get(3));
    }

    @Test
    public void testPairsSortedByValue() {
        OpenShortObjectHashMap map = new OpenShortObjectHashMap();
        map.put((short)11, (Object)this.anotherItem5);
        map.put((short)12, (Object)this.anotherItem4);
        map.put((short)13, (Object)this.anotherItem3);
        map.put((short)14, (Object)this.anotherItem2);
        ShortArrayList keys = new ShortArrayList();
        ArrayList values = new ArrayList();
        map.pairsSortedByValue(keys, values);
        OpenShortObjectHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenShortObjectHashMapTest.assertEquals((Object)this.anotherItem5, values.get(3));
        OpenShortObjectHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenShortObjectHashMapTest.assertEquals((Object)this.anotherItem4, values.get(2));
        OpenShortObjectHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenShortObjectHashMapTest.assertEquals((Object)this.anotherItem3, values.get(1));
        OpenShortObjectHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenShortObjectHashMapTest.assertEquals((Object)this.anotherItem2, values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        short k;
        TestClass v;

        Pair(short k, TestClass v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }

    private static class TestClass
    implements Comparable<TestClass> {
        short x;

        TestClass(short x) {
            this.x = x;
        }

        public String toString() {
            return "[ts " + this.x + " ]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Short.valueOf(this.x).hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestClass other = (TestClass)obj;
            return this.x == other.x;
        }

        @Override
        public int compareTo(TestClass o) {
            return this.x - o.x;
        }
    }
}

