/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.mahout.math.function.ObjectLongProcedure;
import org.apache.mahout.math.function.ObjectProcedure;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.map.OpenObjectLongHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenObjectLongHashMapTest
extends Assert {
    private final NotComparableKey[] ncKeys = new NotComparableKey[]{new NotComparableKey(101), new NotComparableKey(99), new NotComparableKey(2), new NotComparableKey(3), new NotComparableKey(4), new NotComparableKey(5)};

    @Test
    public void testConstructors() {
        OpenObjectLongHashMap map = new OpenObjectLongHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectLongHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenObjectLongHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenObjectLongHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenObjectLongHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectLongHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenObjectLongHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenObjectLongHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenObjectLongHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectLongHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenObjectLongHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenObjectLongHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenObjectLongHashMap map = new OpenObjectLongHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectLongHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenObjectLongHashMap map = new OpenObjectLongHashMap();
        map.put((Object)"Eleven", 11L);
        OpenObjectLongHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenObjectLongHashMapTest.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testClone() {
        OpenObjectLongHashMap map = new OpenObjectLongHashMap();
        map.put((Object)"Eleven", 11L);
        OpenObjectLongHashMap map2 = (OpenObjectLongHashMap)map.clone();
        map.clear();
        OpenObjectLongHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenObjectLongHashMap map = new OpenObjectLongHashMap();
        map.put((Object)"Eleven", 11L);
        OpenObjectLongHashMapTest.assertTrue((boolean)map.containsKey((Object)"Eleven"));
        OpenObjectLongHashMapTest.assertTrue((boolean)map.containsKey((Object)new String("Eleven")));
        OpenObjectLongHashMapTest.assertFalse((boolean)map.containsKey((Object)"Twelve"));
    }

    @Test
    public void testContainValue() {
        OpenObjectLongHashMap map = new OpenObjectLongHashMap();
        map.put((Object)"Eleven", 11L);
        OpenObjectLongHashMapTest.assertTrue((boolean)map.containsValue(11L));
        OpenObjectLongHashMapTest.assertFalse((boolean)map.containsValue(12L));
    }

    @Test
    public void testForEachKey() {
        final ArrayList keys = new ArrayList();
        OpenObjectLongHashMap map = new OpenObjectLongHashMap();
        map.put((Object)"Eleven", 11L);
        map.put((Object)"Twelve", 12L);
        map.put((Object)"Thirteen", 13L);
        map.put((Object)"Fourteen", 14L);
        map.removeKey((Object)"Thirteen");
        map.forEachKey((ObjectProcedure)new ObjectProcedure<String>(){

            public boolean apply(String element) {
                keys.add(element);
                return true;
            }
        });
        OpenObjectLongHashMapTest.assertEquals((long)3L, (long)keys.size());
        Collections.sort(keys);
        OpenObjectLongHashMapTest.assertSame((Object)"Fourteen", keys.get(1));
        OpenObjectLongHashMapTest.assertSame((Object)"Twelve", keys.get(2));
        OpenObjectLongHashMapTest.assertSame((Object)"Eleven", keys.get(0));
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenObjectLongHashMap map = new OpenObjectLongHashMap();
        map.put((Object)"Eleven", 11L);
        map.put((Object)"Twelve", 12L);
        map.put((Object)"Thirteen", 13L);
        map.put((Object)"Fourteen", 14L);
        map.removeKey((Object)"Thirteen");
        map.forEachPair((ObjectLongProcedure)new ObjectLongProcedure<String>(){

            public boolean apply(String first, long second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenObjectLongHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenObjectLongHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)1)).v);
        OpenObjectLongHashMapTest.assertSame((Object)"Fourteen", (Object)((Pair)pairs.get((int)1)).k);
        OpenObjectLongHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)2)).v);
        OpenObjectLongHashMapTest.assertSame((Object)"Twelve", (Object)((Pair)pairs.get((int)2)).k);
        OpenObjectLongHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).v);
        OpenObjectLongHashMapTest.assertSame((Object)"Eleven", (Object)((Pair)pairs.get((int)0)).k);
        pairs.clear();
        map.forEachPair((ObjectLongProcedure)new ObjectLongProcedure<String>(){
            int count = 0;

            public boolean apply(String first, long second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenObjectLongHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenObjectLongHashMap map = new OpenObjectLongHashMap();
        map.put((Object)"Eleven", 11L);
        map.put((Object)"Twelve", 12L);
        OpenObjectLongHashMapTest.assertEquals((long)11L, (long)map.get((Object)"Eleven"));
    }

    @Test
    public void testKeys() {
        OpenObjectLongHashMap map = new OpenObjectLongHashMap();
        map.put((Object)"Eleven", 11L);
        map.put((Object)"Twelve", 12L);
        ArrayList keys = new ArrayList();
        map.keys(keys);
        Collections.sort(keys);
        OpenObjectLongHashMapTest.assertSame((Object)"Twelve", keys.get(1));
        OpenObjectLongHashMapTest.assertSame((Object)"Eleven", keys.get(0));
        List k2 = map.keys();
        Collections.sort(k2);
        OpenObjectLongHashMapTest.assertEquals(keys, (Object)k2);
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenObjectLongHashMap map = new OpenObjectLongHashMap();
        map.put((Object)"Eleven", 11L);
        map.put((Object)"Twelve", 12L);
        map.put((Object)"Thirteen", 13L);
        map.put((Object)"Fourteen", 14L);
        map.adjustOrPutValue((Object)"Eleven", 1L, 3L);
        OpenObjectLongHashMapTest.assertEquals((long)14L, (long)map.get((Object)new String("Eleven")));
        map.adjustOrPutValue((Object)"Fifteen", 1L, 3L);
        OpenObjectLongHashMapTest.assertEquals((long)1L, (long)map.get((Object)"Fifteen"));
    }

    @Test
    public void testPairsMatching() {
        ArrayList keyList = new ArrayList();
        LongArrayList valueList = new LongArrayList();
        OpenObjectLongHashMap map = new OpenObjectLongHashMap();
        map.put((Object)"Eleven", 11L);
        map.put((Object)"Twelve", 12L);
        map.put((Object)"Thirteen", 13L);
        map.put((Object)"Fourteen", 14L);
        map.removeKey((Object)"Thirteen");
        map.pairsMatching((ObjectLongProcedure)new ObjectLongProcedure<String>(){

            public boolean apply(String first, long second) {
                return second % 2L == 0L;
            }
        }, keyList, valueList);
        Collections.sort(keyList);
        valueList.sort();
        OpenObjectLongHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenObjectLongHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenObjectLongHashMapTest.assertSame((Object)"Fourteen", keyList.get(0));
        OpenObjectLongHashMapTest.assertSame((Object)"Twelve", keyList.get(1));
        OpenObjectLongHashMapTest.assertEquals((long)14L, (long)valueList.get(1));
        OpenObjectLongHashMapTest.assertEquals((long)12L, (long)valueList.get(0));
    }

    @Test
    public void testValues() {
        OpenObjectLongHashMap map = new OpenObjectLongHashMap();
        map.put((Object)"Eleven", 11L);
        map.put((Object)"Twelve", 12L);
        map.put((Object)"Thirteen", 13L);
        map.put((Object)"Fourteen", 14L);
        map.removeKey((Object)"Thirteen");
        LongArrayList values = new LongArrayList(100);
        map.values(values);
        OpenObjectLongHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenObjectLongHashMapTest.assertEquals((long)11L, (long)values.get(0));
        OpenObjectLongHashMapTest.assertEquals((long)12L, (long)values.get(1));
        OpenObjectLongHashMapTest.assertEquals((long)14L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenObjectLongHashMap map = new OpenObjectLongHashMap();
        map.put((Object)"Eleven", 11L);
        OpenObjectLongHashMap map2 = (OpenObjectLongHashMap)map.copy();
        map.clear();
        OpenObjectLongHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenObjectLongHashMap map = new OpenObjectLongHashMap();
        map.put((Object)"Eleven", 11L);
        map.put((Object)"Twelve", 12L);
        map.put((Object)"Thirteen", 13L);
        map.put((Object)"Fourteen", 14L);
        map.removeKey((Object)"Thirteen");
        OpenObjectLongHashMap map2 = (OpenObjectLongHashMap)map.copy();
        OpenObjectLongHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenObjectLongHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenObjectLongHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenObjectLongHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey((Object)"Eleven");
        OpenObjectLongHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenObjectLongHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenObjectLongHashMap map = new OpenObjectLongHashMap();
        map.put((Object)"Eleven", 11L);
        map.put((Object)"Twelve", 12L);
        map.put((Object)"Thirteen", 13L);
        map.put((Object)"Fourteen", 14L);
        map.removeKey((Object)"Thirteen");
        ArrayList keys = new ArrayList();
        map.keysSortedByValue(keys);
        Object[] keysArray = keys.toArray(new String[keys.size()]);
        OpenObjectLongHashMapTest.assertArrayEquals((Object[])new String[]{"Eleven", "Twelve", "Fourteen"}, (Object[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenObjectLongHashMap map = new OpenObjectLongHashMap();
        map.put((Object)"Eleven", 11L);
        map.put((Object)"Twelve", 12L);
        map.put((Object)"Thirteen", 13L);
        map.put((Object)"Fourteen", 14L);
        LongArrayList values = new LongArrayList();
        ArrayList keys = new ArrayList();
        map.pairsSortedByKey(keys, values);
        OpenObjectLongHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenObjectLongHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenObjectLongHashMapTest.assertEquals((long)11L, (long)values.get(0));
        OpenObjectLongHashMapTest.assertSame((Object)"Eleven", keys.get(0));
        OpenObjectLongHashMapTest.assertEquals((long)14L, (long)values.get(1));
        OpenObjectLongHashMapTest.assertSame((Object)"Fourteen", keys.get(1));
        OpenObjectLongHashMapTest.assertEquals((long)13L, (long)values.get(2));
        OpenObjectLongHashMapTest.assertSame((Object)"Thirteen", keys.get(2));
        OpenObjectLongHashMapTest.assertEquals((long)12L, (long)values.get(3));
        OpenObjectLongHashMapTest.assertSame((Object)"Twelve", keys.get(3));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPairsSortedByKeyNotComparable() {
        OpenObjectLongHashMap map = new OpenObjectLongHashMap();
        map.put((Object)this.ncKeys[0], 11L);
        map.put((Object)this.ncKeys[1], 12L);
        map.put((Object)this.ncKeys[2], 13L);
        map.put((Object)this.ncKeys[3], 14L);
        LongArrayList values = new LongArrayList();
        ArrayList keys = new ArrayList();
        map.pairsSortedByKey(keys, values);
    }

    @Test
    public void testPairsSortedByValue() {
        OpenObjectLongHashMap map = new OpenObjectLongHashMap();
        map.put((Object)"Eleven", 11L);
        map.put((Object)"Twelve", 12L);
        map.put((Object)"Thirteen", 13L);
        map.put((Object)"Fourteen", 14L);
        ArrayList keys = new ArrayList();
        LongArrayList values = new LongArrayList();
        map.pairsSortedByValue(keys, values);
        OpenObjectLongHashMapTest.assertEquals((long)11L, (long)values.get(0));
        OpenObjectLongHashMapTest.assertEquals((Object)"Eleven", keys.get(0));
        OpenObjectLongHashMapTest.assertEquals((long)12L, (long)values.get(1));
        OpenObjectLongHashMapTest.assertEquals((Object)"Twelve", keys.get(1));
        OpenObjectLongHashMapTest.assertEquals((long)13L, (long)values.get(2));
        OpenObjectLongHashMapTest.assertEquals((Object)"Thirteen", keys.get(2));
        OpenObjectLongHashMapTest.assertEquals((long)14L, (long)values.get(3));
        OpenObjectLongHashMapTest.assertEquals((Object)"Fourteen", keys.get(3));
    }

    private static class Pair
    implements Comparable<Pair> {
        long v;
        String k;

        Pair(String k, long v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            return this.k.compareTo(o.k);
        }
    }

    private static class NotComparableKey {
        protected int x;

        public NotComparableKey(int x) {
            this.x = x;
        }

        public String toString() {
            return "[k " + this.x + " ]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.x;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NotComparableKey other = (NotComparableKey)obj;
            return this.x == other.x;
        }
    }
}

