/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.mahout.math.function.ObjectFloatProcedure;
import org.apache.mahout.math.function.ObjectProcedure;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.map.OpenObjectFloatHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenObjectFloatHashMapTest
extends Assert {
    private final NotComparableKey[] ncKeys = new NotComparableKey[]{new NotComparableKey(101), new NotComparableKey(99), new NotComparableKey(2), new NotComparableKey(3), new NotComparableKey(4), new NotComparableKey(5)};

    @Test
    public void testConstructors() {
        OpenObjectFloatHashMap map = new OpenObjectFloatHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectFloatHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenObjectFloatHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenObjectFloatHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenObjectFloatHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectFloatHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenObjectFloatHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenObjectFloatHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenObjectFloatHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectFloatHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenObjectFloatHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenObjectFloatHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenObjectFloatHashMap map = new OpenObjectFloatHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectFloatHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenObjectFloatHashMap map = new OpenObjectFloatHashMap();
        map.put((Object)"Eleven", 11.0f);
        OpenObjectFloatHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenObjectFloatHashMapTest.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testClone() {
        OpenObjectFloatHashMap map = new OpenObjectFloatHashMap();
        map.put((Object)"Eleven", 11.0f);
        OpenObjectFloatHashMap map2 = (OpenObjectFloatHashMap)map.clone();
        map.clear();
        OpenObjectFloatHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenObjectFloatHashMap map = new OpenObjectFloatHashMap();
        map.put((Object)"Eleven", 11.0f);
        OpenObjectFloatHashMapTest.assertTrue((boolean)map.containsKey((Object)"Eleven"));
        OpenObjectFloatHashMapTest.assertTrue((boolean)map.containsKey((Object)new String("Eleven")));
        OpenObjectFloatHashMapTest.assertFalse((boolean)map.containsKey((Object)"Twelve"));
    }

    @Test
    public void testContainValue() {
        OpenObjectFloatHashMap map = new OpenObjectFloatHashMap();
        map.put((Object)"Eleven", 11.0f);
        OpenObjectFloatHashMapTest.assertTrue((boolean)map.containsValue(11.0f));
        OpenObjectFloatHashMapTest.assertFalse((boolean)map.containsValue(12.0f));
    }

    @Test
    public void testForEachKey() {
        final ArrayList keys = new ArrayList();
        OpenObjectFloatHashMap map = new OpenObjectFloatHashMap();
        map.put((Object)"Eleven", 11.0f);
        map.put((Object)"Twelve", 12.0f);
        map.put((Object)"Thirteen", 13.0f);
        map.put((Object)"Fourteen", 14.0f);
        map.removeKey((Object)"Thirteen");
        map.forEachKey((ObjectProcedure)new ObjectProcedure<String>(){

            public boolean apply(String element) {
                keys.add(element);
                return true;
            }
        });
        OpenObjectFloatHashMapTest.assertEquals((long)3L, (long)keys.size());
        Collections.sort(keys);
        OpenObjectFloatHashMapTest.assertSame((Object)"Fourteen", keys.get(1));
        OpenObjectFloatHashMapTest.assertSame((Object)"Twelve", keys.get(2));
        OpenObjectFloatHashMapTest.assertSame((Object)"Eleven", keys.get(0));
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenObjectFloatHashMap map = new OpenObjectFloatHashMap();
        map.put((Object)"Eleven", 11.0f);
        map.put((Object)"Twelve", 12.0f);
        map.put((Object)"Thirteen", 13.0f);
        map.put((Object)"Fourteen", 14.0f);
        map.removeKey((Object)"Thirteen");
        map.forEachPair((ObjectFloatProcedure)new ObjectFloatProcedure<String>(){

            public boolean apply(String first, float second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenObjectFloatHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenObjectFloatHashMapTest.assertEquals((double)14.0, (double)((Pair)pairs.get((int)1)).v, (double)1.0E-6f);
        OpenObjectFloatHashMapTest.assertSame((Object)"Fourteen", (Object)((Pair)pairs.get((int)1)).k);
        OpenObjectFloatHashMapTest.assertEquals((double)12.0, (double)((Pair)pairs.get((int)2)).v, (double)1.0E-6f);
        OpenObjectFloatHashMapTest.assertSame((Object)"Twelve", (Object)((Pair)pairs.get((int)2)).k);
        OpenObjectFloatHashMapTest.assertEquals((double)11.0, (double)((Pair)pairs.get((int)0)).v, (double)1.0E-6f);
        OpenObjectFloatHashMapTest.assertSame((Object)"Eleven", (Object)((Pair)pairs.get((int)0)).k);
        pairs.clear();
        map.forEachPair((ObjectFloatProcedure)new ObjectFloatProcedure<String>(){
            int count = 0;

            public boolean apply(String first, float second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenObjectFloatHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenObjectFloatHashMap map = new OpenObjectFloatHashMap();
        map.put((Object)"Eleven", 11.0f);
        map.put((Object)"Twelve", 12.0f);
        OpenObjectFloatHashMapTest.assertEquals((double)11.0, (double)map.get((Object)"Eleven"), (double)1.0E-6f);
    }

    @Test
    public void testKeys() {
        OpenObjectFloatHashMap map = new OpenObjectFloatHashMap();
        map.put((Object)"Eleven", 11.0f);
        map.put((Object)"Twelve", 12.0f);
        ArrayList keys = new ArrayList();
        map.keys(keys);
        Collections.sort(keys);
        OpenObjectFloatHashMapTest.assertSame((Object)"Twelve", keys.get(1));
        OpenObjectFloatHashMapTest.assertSame((Object)"Eleven", keys.get(0));
        List k2 = map.keys();
        Collections.sort(k2);
        OpenObjectFloatHashMapTest.assertEquals(keys, (Object)k2);
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenObjectFloatHashMap map = new OpenObjectFloatHashMap();
        map.put((Object)"Eleven", 11.0f);
        map.put((Object)"Twelve", 12.0f);
        map.put((Object)"Thirteen", 13.0f);
        map.put((Object)"Fourteen", 14.0f);
        map.adjustOrPutValue((Object)"Eleven", 1.0f, 3.0f);
        OpenObjectFloatHashMapTest.assertEquals((double)14.0, (double)map.get((Object)new String("Eleven")), (double)1.0E-6f);
        map.adjustOrPutValue((Object)"Fifteen", 1.0f, 3.0f);
        OpenObjectFloatHashMapTest.assertEquals((double)1.0, (double)map.get((Object)"Fifteen"), (double)1.0E-6f);
    }

    @Test
    public void testPairsMatching() {
        ArrayList keyList = new ArrayList();
        FloatArrayList valueList = new FloatArrayList();
        OpenObjectFloatHashMap map = new OpenObjectFloatHashMap();
        map.put((Object)"Eleven", 11.0f);
        map.put((Object)"Twelve", 12.0f);
        map.put((Object)"Thirteen", 13.0f);
        map.put((Object)"Fourteen", 14.0f);
        map.removeKey((Object)"Thirteen");
        map.pairsMatching((ObjectFloatProcedure)new ObjectFloatProcedure<String>(){

            public boolean apply(String first, float second) {
                return second % 2.0f == 0.0f;
            }
        }, keyList, valueList);
        Collections.sort(keyList);
        valueList.sort();
        OpenObjectFloatHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenObjectFloatHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenObjectFloatHashMapTest.assertSame((Object)"Fourteen", keyList.get(0));
        OpenObjectFloatHashMapTest.assertSame((Object)"Twelve", keyList.get(1));
        OpenObjectFloatHashMapTest.assertEquals((double)14.0, (double)valueList.get(1), (double)1.0E-6f);
        OpenObjectFloatHashMapTest.assertEquals((double)12.0, (double)valueList.get(0), (double)1.0E-6f);
    }

    @Test
    public void testValues() {
        OpenObjectFloatHashMap map = new OpenObjectFloatHashMap();
        map.put((Object)"Eleven", 11.0f);
        map.put((Object)"Twelve", 12.0f);
        map.put((Object)"Thirteen", 13.0f);
        map.put((Object)"Fourteen", 14.0f);
        map.removeKey((Object)"Thirteen");
        FloatArrayList values = new FloatArrayList(100);
        map.values(values);
        OpenObjectFloatHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenObjectFloatHashMapTest.assertEquals((double)11.0, (double)values.get(0), (double)1.0E-6f);
        OpenObjectFloatHashMapTest.assertEquals((double)12.0, (double)values.get(1), (double)1.0E-6f);
        OpenObjectFloatHashMapTest.assertEquals((double)14.0, (double)values.get(2), (double)1.0E-6f);
    }

    @Test
    public void testCopy() {
        OpenObjectFloatHashMap map = new OpenObjectFloatHashMap();
        map.put((Object)"Eleven", 11.0f);
        OpenObjectFloatHashMap map2 = (OpenObjectFloatHashMap)map.copy();
        map.clear();
        OpenObjectFloatHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenObjectFloatHashMap map = new OpenObjectFloatHashMap();
        map.put((Object)"Eleven", 11.0f);
        map.put((Object)"Twelve", 12.0f);
        map.put((Object)"Thirteen", 13.0f);
        map.put((Object)"Fourteen", 14.0f);
        map.removeKey((Object)"Thirteen");
        OpenObjectFloatHashMap map2 = (OpenObjectFloatHashMap)map.copy();
        OpenObjectFloatHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenObjectFloatHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenObjectFloatHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenObjectFloatHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey((Object)"Eleven");
        OpenObjectFloatHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenObjectFloatHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenObjectFloatHashMap map = new OpenObjectFloatHashMap();
        map.put((Object)"Eleven", 11.0f);
        map.put((Object)"Twelve", 12.0f);
        map.put((Object)"Thirteen", 13.0f);
        map.put((Object)"Fourteen", 14.0f);
        map.removeKey((Object)"Thirteen");
        ArrayList keys = new ArrayList();
        map.keysSortedByValue(keys);
        Object[] keysArray = keys.toArray(new String[keys.size()]);
        OpenObjectFloatHashMapTest.assertArrayEquals((Object[])new String[]{"Eleven", "Twelve", "Fourteen"}, (Object[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenObjectFloatHashMap map = new OpenObjectFloatHashMap();
        map.put((Object)"Eleven", 11.0f);
        map.put((Object)"Twelve", 12.0f);
        map.put((Object)"Thirteen", 13.0f);
        map.put((Object)"Fourteen", 14.0f);
        FloatArrayList values = new FloatArrayList();
        ArrayList keys = new ArrayList();
        map.pairsSortedByKey(keys, values);
        OpenObjectFloatHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenObjectFloatHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenObjectFloatHashMapTest.assertEquals((double)11.0, (double)values.get(0), (double)1.0E-6f);
        OpenObjectFloatHashMapTest.assertSame((Object)"Eleven", keys.get(0));
        OpenObjectFloatHashMapTest.assertEquals((double)14.0, (double)values.get(1), (double)1.0E-6f);
        OpenObjectFloatHashMapTest.assertSame((Object)"Fourteen", keys.get(1));
        OpenObjectFloatHashMapTest.assertEquals((double)13.0, (double)values.get(2), (double)1.0E-6f);
        OpenObjectFloatHashMapTest.assertSame((Object)"Thirteen", keys.get(2));
        OpenObjectFloatHashMapTest.assertEquals((double)12.0, (double)values.get(3), (double)1.0E-6f);
        OpenObjectFloatHashMapTest.assertSame((Object)"Twelve", keys.get(3));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPairsSortedByKeyNotComparable() {
        OpenObjectFloatHashMap map = new OpenObjectFloatHashMap();
        map.put((Object)this.ncKeys[0], 11.0f);
        map.put((Object)this.ncKeys[1], 12.0f);
        map.put((Object)this.ncKeys[2], 13.0f);
        map.put((Object)this.ncKeys[3], 14.0f);
        FloatArrayList values = new FloatArrayList();
        ArrayList keys = new ArrayList();
        map.pairsSortedByKey(keys, values);
    }

    @Test
    public void testPairsSortedByValue() {
        OpenObjectFloatHashMap map = new OpenObjectFloatHashMap();
        map.put((Object)"Eleven", 11.0f);
        map.put((Object)"Twelve", 12.0f);
        map.put((Object)"Thirteen", 13.0f);
        map.put((Object)"Fourteen", 14.0f);
        ArrayList keys = new ArrayList();
        FloatArrayList values = new FloatArrayList();
        map.pairsSortedByValue(keys, values);
        OpenObjectFloatHashMapTest.assertEquals((double)11.0, (double)values.get(0), (double)1.0E-6f);
        OpenObjectFloatHashMapTest.assertEquals((Object)"Eleven", keys.get(0));
        OpenObjectFloatHashMapTest.assertEquals((double)12.0, (double)values.get(1), (double)1.0E-6f);
        OpenObjectFloatHashMapTest.assertEquals((Object)"Twelve", keys.get(1));
        OpenObjectFloatHashMapTest.assertEquals((double)13.0, (double)values.get(2), (double)1.0E-6f);
        OpenObjectFloatHashMapTest.assertEquals((Object)"Thirteen", keys.get(2));
        OpenObjectFloatHashMapTest.assertEquals((double)14.0, (double)values.get(3), (double)1.0E-6f);
        OpenObjectFloatHashMapTest.assertEquals((Object)"Fourteen", keys.get(3));
    }

    private static class Pair
    implements Comparable<Pair> {
        float v;
        String k;

        Pair(String k, float v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            return this.k.compareTo(o.k);
        }
    }

    private static class NotComparableKey {
        protected int x;

        public NotComparableKey(int x) {
            this.x = x;
        }

        public String toString() {
            return "[k " + this.x + " ]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.x;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NotComparableKey other = (NotComparableKey)obj;
            return this.x == other.x;
        }
    }
}

