/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.mahout.math.function.ObjectDoubleProcedure;
import org.apache.mahout.math.function.ObjectProcedure;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.map.OpenObjectDoubleHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenObjectDoubleHashMapTest
extends Assert {
    private final NotComparableKey[] ncKeys = new NotComparableKey[]{new NotComparableKey(101), new NotComparableKey(99), new NotComparableKey(2), new NotComparableKey(3), new NotComparableKey(4), new NotComparableKey(5)};

    @Test
    public void testConstructors() {
        OpenObjectDoubleHashMap map = new OpenObjectDoubleHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectDoubleHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenObjectDoubleHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenObjectDoubleHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenObjectDoubleHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectDoubleHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenObjectDoubleHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenObjectDoubleHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenObjectDoubleHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectDoubleHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenObjectDoubleHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenObjectDoubleHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenObjectDoubleHashMap map = new OpenObjectDoubleHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectDoubleHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenObjectDoubleHashMap map = new OpenObjectDoubleHashMap();
        map.put((Object)"Eleven", 11.0);
        OpenObjectDoubleHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenObjectDoubleHashMapTest.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testClone() {
        OpenObjectDoubleHashMap map = new OpenObjectDoubleHashMap();
        map.put((Object)"Eleven", 11.0);
        OpenObjectDoubleHashMap map2 = (OpenObjectDoubleHashMap)map.clone();
        map.clear();
        OpenObjectDoubleHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenObjectDoubleHashMap map = new OpenObjectDoubleHashMap();
        map.put((Object)"Eleven", 11.0);
        OpenObjectDoubleHashMapTest.assertTrue((boolean)map.containsKey((Object)"Eleven"));
        OpenObjectDoubleHashMapTest.assertTrue((boolean)map.containsKey((Object)new String("Eleven")));
        OpenObjectDoubleHashMapTest.assertFalse((boolean)map.containsKey((Object)"Twelve"));
    }

    @Test
    public void testContainValue() {
        OpenObjectDoubleHashMap map = new OpenObjectDoubleHashMap();
        map.put((Object)"Eleven", 11.0);
        OpenObjectDoubleHashMapTest.assertTrue((boolean)map.containsValue(11.0));
        OpenObjectDoubleHashMapTest.assertFalse((boolean)map.containsValue(12.0));
    }

    @Test
    public void testForEachKey() {
        final ArrayList keys = new ArrayList();
        OpenObjectDoubleHashMap map = new OpenObjectDoubleHashMap();
        map.put((Object)"Eleven", 11.0);
        map.put((Object)"Twelve", 12.0);
        map.put((Object)"Thirteen", 13.0);
        map.put((Object)"Fourteen", 14.0);
        map.removeKey((Object)"Thirteen");
        map.forEachKey((ObjectProcedure)new ObjectProcedure<String>(){

            public boolean apply(String element) {
                keys.add(element);
                return true;
            }
        });
        OpenObjectDoubleHashMapTest.assertEquals((long)3L, (long)keys.size());
        Collections.sort(keys);
        OpenObjectDoubleHashMapTest.assertSame((Object)"Fourteen", keys.get(1));
        OpenObjectDoubleHashMapTest.assertSame((Object)"Twelve", keys.get(2));
        OpenObjectDoubleHashMapTest.assertSame((Object)"Eleven", keys.get(0));
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenObjectDoubleHashMap map = new OpenObjectDoubleHashMap();
        map.put((Object)"Eleven", 11.0);
        map.put((Object)"Twelve", 12.0);
        map.put((Object)"Thirteen", 13.0);
        map.put((Object)"Fourteen", 14.0);
        map.removeKey((Object)"Thirteen");
        map.forEachPair((ObjectDoubleProcedure)new ObjectDoubleProcedure<String>(){

            public boolean apply(String first, double second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenObjectDoubleHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenObjectDoubleHashMapTest.assertEquals((double)14.0, (double)((Pair)pairs.get((int)1)).v, (double)1.0E-6);
        OpenObjectDoubleHashMapTest.assertSame((Object)"Fourteen", (Object)((Pair)pairs.get((int)1)).k);
        OpenObjectDoubleHashMapTest.assertEquals((double)12.0, (double)((Pair)pairs.get((int)2)).v, (double)1.0E-6);
        OpenObjectDoubleHashMapTest.assertSame((Object)"Twelve", (Object)((Pair)pairs.get((int)2)).k);
        OpenObjectDoubleHashMapTest.assertEquals((double)11.0, (double)((Pair)pairs.get((int)0)).v, (double)1.0E-6);
        OpenObjectDoubleHashMapTest.assertSame((Object)"Eleven", (Object)((Pair)pairs.get((int)0)).k);
        pairs.clear();
        map.forEachPair((ObjectDoubleProcedure)new ObjectDoubleProcedure<String>(){
            int count = 0;

            public boolean apply(String first, double second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenObjectDoubleHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenObjectDoubleHashMap map = new OpenObjectDoubleHashMap();
        map.put((Object)"Eleven", 11.0);
        map.put((Object)"Twelve", 12.0);
        OpenObjectDoubleHashMapTest.assertEquals((double)11.0, (double)map.get((Object)"Eleven"), (double)1.0E-6);
    }

    @Test
    public void testKeys() {
        OpenObjectDoubleHashMap map = new OpenObjectDoubleHashMap();
        map.put((Object)"Eleven", 11.0);
        map.put((Object)"Twelve", 12.0);
        ArrayList keys = new ArrayList();
        map.keys(keys);
        Collections.sort(keys);
        OpenObjectDoubleHashMapTest.assertSame((Object)"Twelve", keys.get(1));
        OpenObjectDoubleHashMapTest.assertSame((Object)"Eleven", keys.get(0));
        List k2 = map.keys();
        Collections.sort(k2);
        OpenObjectDoubleHashMapTest.assertEquals(keys, (Object)k2);
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenObjectDoubleHashMap map = new OpenObjectDoubleHashMap();
        map.put((Object)"Eleven", 11.0);
        map.put((Object)"Twelve", 12.0);
        map.put((Object)"Thirteen", 13.0);
        map.put((Object)"Fourteen", 14.0);
        map.adjustOrPutValue((Object)"Eleven", 1.0, 3.0);
        OpenObjectDoubleHashMapTest.assertEquals((double)14.0, (double)map.get((Object)new String("Eleven")), (double)1.0E-6);
        map.adjustOrPutValue((Object)"Fifteen", 1.0, 3.0);
        OpenObjectDoubleHashMapTest.assertEquals((double)1.0, (double)map.get((Object)"Fifteen"), (double)1.0E-6);
    }

    @Test
    public void testPairsMatching() {
        ArrayList keyList = new ArrayList();
        DoubleArrayList valueList = new DoubleArrayList();
        OpenObjectDoubleHashMap map = new OpenObjectDoubleHashMap();
        map.put((Object)"Eleven", 11.0);
        map.put((Object)"Twelve", 12.0);
        map.put((Object)"Thirteen", 13.0);
        map.put((Object)"Fourteen", 14.0);
        map.removeKey((Object)"Thirteen");
        map.pairsMatching((ObjectDoubleProcedure)new ObjectDoubleProcedure<String>(){

            public boolean apply(String first, double second) {
                return second % 2.0 == 0.0;
            }
        }, keyList, valueList);
        Collections.sort(keyList);
        valueList.sort();
        OpenObjectDoubleHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenObjectDoubleHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenObjectDoubleHashMapTest.assertSame((Object)"Fourteen", keyList.get(0));
        OpenObjectDoubleHashMapTest.assertSame((Object)"Twelve", keyList.get(1));
        OpenObjectDoubleHashMapTest.assertEquals((double)14.0, (double)valueList.get(1), (double)1.0E-6);
        OpenObjectDoubleHashMapTest.assertEquals((double)12.0, (double)valueList.get(0), (double)1.0E-6);
    }

    @Test
    public void testValues() {
        OpenObjectDoubleHashMap map = new OpenObjectDoubleHashMap();
        map.put((Object)"Eleven", 11.0);
        map.put((Object)"Twelve", 12.0);
        map.put((Object)"Thirteen", 13.0);
        map.put((Object)"Fourteen", 14.0);
        map.removeKey((Object)"Thirteen");
        DoubleArrayList values = new DoubleArrayList(100);
        map.values(values);
        OpenObjectDoubleHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenObjectDoubleHashMapTest.assertEquals((double)11.0, (double)values.get(0), (double)1.0E-6);
        OpenObjectDoubleHashMapTest.assertEquals((double)12.0, (double)values.get(1), (double)1.0E-6);
        OpenObjectDoubleHashMapTest.assertEquals((double)14.0, (double)values.get(2), (double)1.0E-6);
    }

    @Test
    public void testCopy() {
        OpenObjectDoubleHashMap map = new OpenObjectDoubleHashMap();
        map.put((Object)"Eleven", 11.0);
        OpenObjectDoubleHashMap map2 = (OpenObjectDoubleHashMap)map.copy();
        map.clear();
        OpenObjectDoubleHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenObjectDoubleHashMap map = new OpenObjectDoubleHashMap();
        map.put((Object)"Eleven", 11.0);
        map.put((Object)"Twelve", 12.0);
        map.put((Object)"Thirteen", 13.0);
        map.put((Object)"Fourteen", 14.0);
        map.removeKey((Object)"Thirteen");
        OpenObjectDoubleHashMap map2 = (OpenObjectDoubleHashMap)map.copy();
        OpenObjectDoubleHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenObjectDoubleHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenObjectDoubleHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenObjectDoubleHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey((Object)"Eleven");
        OpenObjectDoubleHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenObjectDoubleHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenObjectDoubleHashMap map = new OpenObjectDoubleHashMap();
        map.put((Object)"Eleven", 11.0);
        map.put((Object)"Twelve", 12.0);
        map.put((Object)"Thirteen", 13.0);
        map.put((Object)"Fourteen", 14.0);
        map.removeKey((Object)"Thirteen");
        ArrayList keys = new ArrayList();
        map.keysSortedByValue(keys);
        Object[] keysArray = keys.toArray(new String[keys.size()]);
        OpenObjectDoubleHashMapTest.assertArrayEquals((Object[])new String[]{"Eleven", "Twelve", "Fourteen"}, (Object[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenObjectDoubleHashMap map = new OpenObjectDoubleHashMap();
        map.put((Object)"Eleven", 11.0);
        map.put((Object)"Twelve", 12.0);
        map.put((Object)"Thirteen", 13.0);
        map.put((Object)"Fourteen", 14.0);
        DoubleArrayList values = new DoubleArrayList();
        ArrayList keys = new ArrayList();
        map.pairsSortedByKey(keys, values);
        OpenObjectDoubleHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenObjectDoubleHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenObjectDoubleHashMapTest.assertEquals((double)11.0, (double)values.get(0), (double)1.0E-6);
        OpenObjectDoubleHashMapTest.assertSame((Object)"Eleven", keys.get(0));
        OpenObjectDoubleHashMapTest.assertEquals((double)14.0, (double)values.get(1), (double)1.0E-6);
        OpenObjectDoubleHashMapTest.assertSame((Object)"Fourteen", keys.get(1));
        OpenObjectDoubleHashMapTest.assertEquals((double)13.0, (double)values.get(2), (double)1.0E-6);
        OpenObjectDoubleHashMapTest.assertSame((Object)"Thirteen", keys.get(2));
        OpenObjectDoubleHashMapTest.assertEquals((double)12.0, (double)values.get(3), (double)1.0E-6);
        OpenObjectDoubleHashMapTest.assertSame((Object)"Twelve", keys.get(3));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPairsSortedByKeyNotComparable() {
        OpenObjectDoubleHashMap map = new OpenObjectDoubleHashMap();
        map.put((Object)this.ncKeys[0], 11.0);
        map.put((Object)this.ncKeys[1], 12.0);
        map.put((Object)this.ncKeys[2], 13.0);
        map.put((Object)this.ncKeys[3], 14.0);
        DoubleArrayList values = new DoubleArrayList();
        ArrayList keys = new ArrayList();
        map.pairsSortedByKey(keys, values);
    }

    @Test
    public void testPairsSortedByValue() {
        OpenObjectDoubleHashMap map = new OpenObjectDoubleHashMap();
        map.put((Object)"Eleven", 11.0);
        map.put((Object)"Twelve", 12.0);
        map.put((Object)"Thirteen", 13.0);
        map.put((Object)"Fourteen", 14.0);
        ArrayList keys = new ArrayList();
        DoubleArrayList values = new DoubleArrayList();
        map.pairsSortedByValue(keys, values);
        OpenObjectDoubleHashMapTest.assertEquals((double)11.0, (double)values.get(0), (double)1.0E-6);
        OpenObjectDoubleHashMapTest.assertEquals((Object)"Eleven", keys.get(0));
        OpenObjectDoubleHashMapTest.assertEquals((double)12.0, (double)values.get(1), (double)1.0E-6);
        OpenObjectDoubleHashMapTest.assertEquals((Object)"Twelve", keys.get(1));
        OpenObjectDoubleHashMapTest.assertEquals((double)13.0, (double)values.get(2), (double)1.0E-6);
        OpenObjectDoubleHashMapTest.assertEquals((Object)"Thirteen", keys.get(2));
        OpenObjectDoubleHashMapTest.assertEquals((double)14.0, (double)values.get(3), (double)1.0E-6);
        OpenObjectDoubleHashMapTest.assertEquals((Object)"Fourteen", keys.get(3));
    }

    private static class Pair
    implements Comparable<Pair> {
        double v;
        String k;

        Pair(String k, double v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            return this.k.compareTo(o.k);
        }
    }

    private static class NotComparableKey {
        protected int x;

        public NotComparableKey(int x) {
            this.x = x;
        }

        public String toString() {
            return "[k " + this.x + " ]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.x;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NotComparableKey other = (NotComparableKey)obj;
            return this.x == other.x;
        }
    }
}

