/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.mahout.math.function.ObjectCharProcedure;
import org.apache.mahout.math.function.ObjectProcedure;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.map.OpenObjectCharHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenObjectCharHashMapTest
extends Assert {
    private final NotComparableKey[] ncKeys = new NotComparableKey[]{new NotComparableKey(101), new NotComparableKey(99), new NotComparableKey(2), new NotComparableKey(3), new NotComparableKey(4), new NotComparableKey(5)};

    @Test
    public void testConstructors() {
        OpenObjectCharHashMap map = new OpenObjectCharHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectCharHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenObjectCharHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenObjectCharHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenObjectCharHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectCharHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenObjectCharHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenObjectCharHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenObjectCharHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectCharHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenObjectCharHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenObjectCharHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenObjectCharHashMap map = new OpenObjectCharHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectCharHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenObjectCharHashMap map = new OpenObjectCharHashMap();
        map.put((Object)"Eleven", '\u000b');
        OpenObjectCharHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenObjectCharHashMapTest.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testClone() {
        OpenObjectCharHashMap map = new OpenObjectCharHashMap();
        map.put((Object)"Eleven", '\u000b');
        OpenObjectCharHashMap map2 = (OpenObjectCharHashMap)map.clone();
        map.clear();
        OpenObjectCharHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenObjectCharHashMap map = new OpenObjectCharHashMap();
        map.put((Object)"Eleven", '\u000b');
        OpenObjectCharHashMapTest.assertTrue((boolean)map.containsKey((Object)"Eleven"));
        OpenObjectCharHashMapTest.assertTrue((boolean)map.containsKey((Object)new String("Eleven")));
        OpenObjectCharHashMapTest.assertFalse((boolean)map.containsKey((Object)"Twelve"));
    }

    @Test
    public void testContainValue() {
        OpenObjectCharHashMap map = new OpenObjectCharHashMap();
        map.put((Object)"Eleven", '\u000b');
        OpenObjectCharHashMapTest.assertTrue((boolean)map.containsValue('\u000b'));
        OpenObjectCharHashMapTest.assertFalse((boolean)map.containsValue('\f'));
    }

    @Test
    public void testForEachKey() {
        final ArrayList keys = new ArrayList();
        OpenObjectCharHashMap map = new OpenObjectCharHashMap();
        map.put((Object)"Eleven", '\u000b');
        map.put((Object)"Twelve", '\f');
        map.put((Object)"Thirteen", '\r');
        map.put((Object)"Fourteen", '\u000e');
        map.removeKey((Object)"Thirteen");
        map.forEachKey((ObjectProcedure)new ObjectProcedure<String>(){

            public boolean apply(String element) {
                keys.add(element);
                return true;
            }
        });
        OpenObjectCharHashMapTest.assertEquals((long)3L, (long)keys.size());
        Collections.sort(keys);
        OpenObjectCharHashMapTest.assertSame((Object)"Fourteen", keys.get(1));
        OpenObjectCharHashMapTest.assertSame((Object)"Twelve", keys.get(2));
        OpenObjectCharHashMapTest.assertSame((Object)"Eleven", keys.get(0));
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenObjectCharHashMap map = new OpenObjectCharHashMap();
        map.put((Object)"Eleven", '\u000b');
        map.put((Object)"Twelve", '\f');
        map.put((Object)"Thirteen", '\r');
        map.put((Object)"Fourteen", '\u000e');
        map.removeKey((Object)"Thirteen");
        map.forEachPair((ObjectCharProcedure)new ObjectCharProcedure<String>(){

            public boolean apply(String first, char second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenObjectCharHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenObjectCharHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)1)).v);
        OpenObjectCharHashMapTest.assertSame((Object)"Fourteen", (Object)((Pair)pairs.get((int)1)).k);
        OpenObjectCharHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)2)).v);
        OpenObjectCharHashMapTest.assertSame((Object)"Twelve", (Object)((Pair)pairs.get((int)2)).k);
        OpenObjectCharHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).v);
        OpenObjectCharHashMapTest.assertSame((Object)"Eleven", (Object)((Pair)pairs.get((int)0)).k);
        pairs.clear();
        map.forEachPair((ObjectCharProcedure)new ObjectCharProcedure<String>(){
            int count = 0;

            public boolean apply(String first, char second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenObjectCharHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenObjectCharHashMap map = new OpenObjectCharHashMap();
        map.put((Object)"Eleven", '\u000b');
        map.put((Object)"Twelve", '\f');
        OpenObjectCharHashMapTest.assertEquals((long)11L, (long)map.get((Object)"Eleven"));
    }

    @Test
    public void testKeys() {
        OpenObjectCharHashMap map = new OpenObjectCharHashMap();
        map.put((Object)"Eleven", '\u000b');
        map.put((Object)"Twelve", '\f');
        ArrayList keys = new ArrayList();
        map.keys(keys);
        Collections.sort(keys);
        OpenObjectCharHashMapTest.assertSame((Object)"Twelve", keys.get(1));
        OpenObjectCharHashMapTest.assertSame((Object)"Eleven", keys.get(0));
        List k2 = map.keys();
        Collections.sort(k2);
        OpenObjectCharHashMapTest.assertEquals(keys, (Object)k2);
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenObjectCharHashMap map = new OpenObjectCharHashMap();
        map.put((Object)"Eleven", '\u000b');
        map.put((Object)"Twelve", '\f');
        map.put((Object)"Thirteen", '\r');
        map.put((Object)"Fourteen", '\u000e');
        map.adjustOrPutValue((Object)"Eleven", '\u0001', '\u0003');
        OpenObjectCharHashMapTest.assertEquals((long)14L, (long)map.get((Object)new String("Eleven")));
        map.adjustOrPutValue((Object)"Fifteen", '\u0001', '\u0003');
        OpenObjectCharHashMapTest.assertEquals((long)1L, (long)map.get((Object)"Fifteen"));
    }

    @Test
    public void testPairsMatching() {
        ArrayList keyList = new ArrayList();
        CharArrayList valueList = new CharArrayList();
        OpenObjectCharHashMap map = new OpenObjectCharHashMap();
        map.put((Object)"Eleven", '\u000b');
        map.put((Object)"Twelve", '\f');
        map.put((Object)"Thirteen", '\r');
        map.put((Object)"Fourteen", '\u000e');
        map.removeKey((Object)"Thirteen");
        map.pairsMatching((ObjectCharProcedure)new ObjectCharProcedure<String>(){

            public boolean apply(String first, char second) {
                return second % 2 == 0;
            }
        }, keyList, valueList);
        Collections.sort(keyList);
        valueList.sort();
        OpenObjectCharHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenObjectCharHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenObjectCharHashMapTest.assertSame((Object)"Fourteen", keyList.get(0));
        OpenObjectCharHashMapTest.assertSame((Object)"Twelve", keyList.get(1));
        OpenObjectCharHashMapTest.assertEquals((long)14L, (long)valueList.get(1));
        OpenObjectCharHashMapTest.assertEquals((long)12L, (long)valueList.get(0));
    }

    @Test
    public void testValues() {
        OpenObjectCharHashMap map = new OpenObjectCharHashMap();
        map.put((Object)"Eleven", '\u000b');
        map.put((Object)"Twelve", '\f');
        map.put((Object)"Thirteen", '\r');
        map.put((Object)"Fourteen", '\u000e');
        map.removeKey((Object)"Thirteen");
        CharArrayList values = new CharArrayList(100);
        map.values(values);
        OpenObjectCharHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenObjectCharHashMapTest.assertEquals((long)11L, (long)values.get(0));
        OpenObjectCharHashMapTest.assertEquals((long)12L, (long)values.get(1));
        OpenObjectCharHashMapTest.assertEquals((long)14L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenObjectCharHashMap map = new OpenObjectCharHashMap();
        map.put((Object)"Eleven", '\u000b');
        OpenObjectCharHashMap map2 = (OpenObjectCharHashMap)map.copy();
        map.clear();
        OpenObjectCharHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenObjectCharHashMap map = new OpenObjectCharHashMap();
        map.put((Object)"Eleven", '\u000b');
        map.put((Object)"Twelve", '\f');
        map.put((Object)"Thirteen", '\r');
        map.put((Object)"Fourteen", '\u000e');
        map.removeKey((Object)"Thirteen");
        OpenObjectCharHashMap map2 = (OpenObjectCharHashMap)map.copy();
        OpenObjectCharHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenObjectCharHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenObjectCharHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenObjectCharHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey((Object)"Eleven");
        OpenObjectCharHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenObjectCharHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenObjectCharHashMap map = new OpenObjectCharHashMap();
        map.put((Object)"Eleven", '\u000b');
        map.put((Object)"Twelve", '\f');
        map.put((Object)"Thirteen", '\r');
        map.put((Object)"Fourteen", '\u000e');
        map.removeKey((Object)"Thirteen");
        ArrayList keys = new ArrayList();
        map.keysSortedByValue(keys);
        Object[] keysArray = keys.toArray(new String[keys.size()]);
        OpenObjectCharHashMapTest.assertArrayEquals((Object[])new String[]{"Eleven", "Twelve", "Fourteen"}, (Object[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenObjectCharHashMap map = new OpenObjectCharHashMap();
        map.put((Object)"Eleven", '\u000b');
        map.put((Object)"Twelve", '\f');
        map.put((Object)"Thirteen", '\r');
        map.put((Object)"Fourteen", '\u000e');
        CharArrayList values = new CharArrayList();
        ArrayList keys = new ArrayList();
        map.pairsSortedByKey(keys, values);
        OpenObjectCharHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenObjectCharHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenObjectCharHashMapTest.assertEquals((long)11L, (long)values.get(0));
        OpenObjectCharHashMapTest.assertSame((Object)"Eleven", keys.get(0));
        OpenObjectCharHashMapTest.assertEquals((long)14L, (long)values.get(1));
        OpenObjectCharHashMapTest.assertSame((Object)"Fourteen", keys.get(1));
        OpenObjectCharHashMapTest.assertEquals((long)13L, (long)values.get(2));
        OpenObjectCharHashMapTest.assertSame((Object)"Thirteen", keys.get(2));
        OpenObjectCharHashMapTest.assertEquals((long)12L, (long)values.get(3));
        OpenObjectCharHashMapTest.assertSame((Object)"Twelve", keys.get(3));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPairsSortedByKeyNotComparable() {
        OpenObjectCharHashMap map = new OpenObjectCharHashMap();
        map.put((Object)this.ncKeys[0], '\u000b');
        map.put((Object)this.ncKeys[1], '\f');
        map.put((Object)this.ncKeys[2], '\r');
        map.put((Object)this.ncKeys[3], '\u000e');
        CharArrayList values = new CharArrayList();
        ArrayList keys = new ArrayList();
        map.pairsSortedByKey(keys, values);
    }

    @Test
    public void testPairsSortedByValue() {
        OpenObjectCharHashMap map = new OpenObjectCharHashMap();
        map.put((Object)"Eleven", '\u000b');
        map.put((Object)"Twelve", '\f');
        map.put((Object)"Thirteen", '\r');
        map.put((Object)"Fourteen", '\u000e');
        ArrayList keys = new ArrayList();
        CharArrayList values = new CharArrayList();
        map.pairsSortedByValue(keys, values);
        OpenObjectCharHashMapTest.assertEquals((long)11L, (long)values.get(0));
        OpenObjectCharHashMapTest.assertEquals((Object)"Eleven", keys.get(0));
        OpenObjectCharHashMapTest.assertEquals((long)12L, (long)values.get(1));
        OpenObjectCharHashMapTest.assertEquals((Object)"Twelve", keys.get(1));
        OpenObjectCharHashMapTest.assertEquals((long)13L, (long)values.get(2));
        OpenObjectCharHashMapTest.assertEquals((Object)"Thirteen", keys.get(2));
        OpenObjectCharHashMapTest.assertEquals((long)14L, (long)values.get(3));
        OpenObjectCharHashMapTest.assertEquals((Object)"Fourteen", keys.get(3));
    }

    private static class Pair
    implements Comparable<Pair> {
        char v;
        String k;

        Pair(String k, char v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            return this.k.compareTo(o.k);
        }
    }

    private static class NotComparableKey {
        protected int x;

        public NotComparableKey(int x) {
            this.x = x;
        }

        public String toString() {
            return "[k " + this.x + " ]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.x;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NotComparableKey other = (NotComparableKey)obj;
            return this.x == other.x;
        }
    }
}

