/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.mahout.math.function.ObjectByteProcedure;
import org.apache.mahout.math.function.ObjectProcedure;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.map.OpenObjectByteHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenObjectByteHashMapTest
extends Assert {
    private final NotComparableKey[] ncKeys = new NotComparableKey[]{new NotComparableKey(101), new NotComparableKey(99), new NotComparableKey(2), new NotComparableKey(3), new NotComparableKey(4), new NotComparableKey(5)};

    @Test
    public void testConstructors() {
        OpenObjectByteHashMap map = new OpenObjectByteHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectByteHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenObjectByteHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenObjectByteHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenObjectByteHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectByteHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenObjectByteHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenObjectByteHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenObjectByteHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectByteHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenObjectByteHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenObjectByteHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenObjectByteHashMap map = new OpenObjectByteHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenObjectByteHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenObjectByteHashMap map = new OpenObjectByteHashMap();
        map.put((Object)"Eleven", (byte)11);
        OpenObjectByteHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenObjectByteHashMapTest.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testClone() {
        OpenObjectByteHashMap map = new OpenObjectByteHashMap();
        map.put((Object)"Eleven", (byte)11);
        OpenObjectByteHashMap map2 = (OpenObjectByteHashMap)map.clone();
        map.clear();
        OpenObjectByteHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenObjectByteHashMap map = new OpenObjectByteHashMap();
        map.put((Object)"Eleven", (byte)11);
        OpenObjectByteHashMapTest.assertTrue((boolean)map.containsKey((Object)"Eleven"));
        OpenObjectByteHashMapTest.assertTrue((boolean)map.containsKey((Object)new String("Eleven")));
        OpenObjectByteHashMapTest.assertFalse((boolean)map.containsKey((Object)"Twelve"));
    }

    @Test
    public void testContainValue() {
        OpenObjectByteHashMap map = new OpenObjectByteHashMap();
        map.put((Object)"Eleven", (byte)11);
        OpenObjectByteHashMapTest.assertTrue((boolean)map.containsValue((byte)11));
        OpenObjectByteHashMapTest.assertFalse((boolean)map.containsValue((byte)12));
    }

    @Test
    public void testForEachKey() {
        final ArrayList keys = new ArrayList();
        OpenObjectByteHashMap map = new OpenObjectByteHashMap();
        map.put((Object)"Eleven", (byte)11);
        map.put((Object)"Twelve", (byte)12);
        map.put((Object)"Thirteen", (byte)13);
        map.put((Object)"Fourteen", (byte)14);
        map.removeKey((Object)"Thirteen");
        map.forEachKey((ObjectProcedure)new ObjectProcedure<String>(){

            public boolean apply(String element) {
                keys.add(element);
                return true;
            }
        });
        OpenObjectByteHashMapTest.assertEquals((long)3L, (long)keys.size());
        Collections.sort(keys);
        OpenObjectByteHashMapTest.assertSame((Object)"Fourteen", keys.get(1));
        OpenObjectByteHashMapTest.assertSame((Object)"Twelve", keys.get(2));
        OpenObjectByteHashMapTest.assertSame((Object)"Eleven", keys.get(0));
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenObjectByteHashMap map = new OpenObjectByteHashMap();
        map.put((Object)"Eleven", (byte)11);
        map.put((Object)"Twelve", (byte)12);
        map.put((Object)"Thirteen", (byte)13);
        map.put((Object)"Fourteen", (byte)14);
        map.removeKey((Object)"Thirteen");
        map.forEachPair((ObjectByteProcedure)new ObjectByteProcedure<String>(){

            public boolean apply(String first, byte second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenObjectByteHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenObjectByteHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)1)).v);
        OpenObjectByteHashMapTest.assertSame((Object)"Fourteen", (Object)((Pair)pairs.get((int)1)).k);
        OpenObjectByteHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)2)).v);
        OpenObjectByteHashMapTest.assertSame((Object)"Twelve", (Object)((Pair)pairs.get((int)2)).k);
        OpenObjectByteHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).v);
        OpenObjectByteHashMapTest.assertSame((Object)"Eleven", (Object)((Pair)pairs.get((int)0)).k);
        pairs.clear();
        map.forEachPair((ObjectByteProcedure)new ObjectByteProcedure<String>(){
            int count = 0;

            public boolean apply(String first, byte second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenObjectByteHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenObjectByteHashMap map = new OpenObjectByteHashMap();
        map.put((Object)"Eleven", (byte)11);
        map.put((Object)"Twelve", (byte)12);
        OpenObjectByteHashMapTest.assertEquals((long)11L, (long)map.get((Object)"Eleven"));
    }

    @Test
    public void testKeys() {
        OpenObjectByteHashMap map = new OpenObjectByteHashMap();
        map.put((Object)"Eleven", (byte)11);
        map.put((Object)"Twelve", (byte)12);
        ArrayList keys = new ArrayList();
        map.keys(keys);
        Collections.sort(keys);
        OpenObjectByteHashMapTest.assertSame((Object)"Twelve", keys.get(1));
        OpenObjectByteHashMapTest.assertSame((Object)"Eleven", keys.get(0));
        List k2 = map.keys();
        Collections.sort(k2);
        OpenObjectByteHashMapTest.assertEquals(keys, (Object)k2);
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenObjectByteHashMap map = new OpenObjectByteHashMap();
        map.put((Object)"Eleven", (byte)11);
        map.put((Object)"Twelve", (byte)12);
        map.put((Object)"Thirteen", (byte)13);
        map.put((Object)"Fourteen", (byte)14);
        map.adjustOrPutValue((Object)"Eleven", (byte)1, (byte)3);
        OpenObjectByteHashMapTest.assertEquals((long)14L, (long)map.get((Object)new String("Eleven")));
        map.adjustOrPutValue((Object)"Fifteen", (byte)1, (byte)3);
        OpenObjectByteHashMapTest.assertEquals((long)1L, (long)map.get((Object)"Fifteen"));
    }

    @Test
    public void testPairsMatching() {
        ArrayList keyList = new ArrayList();
        ByteArrayList valueList = new ByteArrayList();
        OpenObjectByteHashMap map = new OpenObjectByteHashMap();
        map.put((Object)"Eleven", (byte)11);
        map.put((Object)"Twelve", (byte)12);
        map.put((Object)"Thirteen", (byte)13);
        map.put((Object)"Fourteen", (byte)14);
        map.removeKey((Object)"Thirteen");
        map.pairsMatching((ObjectByteProcedure)new ObjectByteProcedure<String>(){

            public boolean apply(String first, byte second) {
                return second % 2 == 0;
            }
        }, keyList, valueList);
        Collections.sort(keyList);
        valueList.sort();
        OpenObjectByteHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenObjectByteHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenObjectByteHashMapTest.assertSame((Object)"Fourteen", keyList.get(0));
        OpenObjectByteHashMapTest.assertSame((Object)"Twelve", keyList.get(1));
        OpenObjectByteHashMapTest.assertEquals((long)14L, (long)valueList.get(1));
        OpenObjectByteHashMapTest.assertEquals((long)12L, (long)valueList.get(0));
    }

    @Test
    public void testValues() {
        OpenObjectByteHashMap map = new OpenObjectByteHashMap();
        map.put((Object)"Eleven", (byte)11);
        map.put((Object)"Twelve", (byte)12);
        map.put((Object)"Thirteen", (byte)13);
        map.put((Object)"Fourteen", (byte)14);
        map.removeKey((Object)"Thirteen");
        ByteArrayList values = new ByteArrayList(100);
        map.values(values);
        OpenObjectByteHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenObjectByteHashMapTest.assertEquals((long)11L, (long)values.get(0));
        OpenObjectByteHashMapTest.assertEquals((long)12L, (long)values.get(1));
        OpenObjectByteHashMapTest.assertEquals((long)14L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenObjectByteHashMap map = new OpenObjectByteHashMap();
        map.put((Object)"Eleven", (byte)11);
        OpenObjectByteHashMap map2 = (OpenObjectByteHashMap)map.copy();
        map.clear();
        OpenObjectByteHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenObjectByteHashMap map = new OpenObjectByteHashMap();
        map.put((Object)"Eleven", (byte)11);
        map.put((Object)"Twelve", (byte)12);
        map.put((Object)"Thirteen", (byte)13);
        map.put((Object)"Fourteen", (byte)14);
        map.removeKey((Object)"Thirteen");
        OpenObjectByteHashMap map2 = (OpenObjectByteHashMap)map.copy();
        OpenObjectByteHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenObjectByteHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenObjectByteHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenObjectByteHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey((Object)"Eleven");
        OpenObjectByteHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenObjectByteHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenObjectByteHashMap map = new OpenObjectByteHashMap();
        map.put((Object)"Eleven", (byte)11);
        map.put((Object)"Twelve", (byte)12);
        map.put((Object)"Thirteen", (byte)13);
        map.put((Object)"Fourteen", (byte)14);
        map.removeKey((Object)"Thirteen");
        ArrayList keys = new ArrayList();
        map.keysSortedByValue(keys);
        Object[] keysArray = keys.toArray(new String[keys.size()]);
        OpenObjectByteHashMapTest.assertArrayEquals((Object[])new String[]{"Eleven", "Twelve", "Fourteen"}, (Object[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenObjectByteHashMap map = new OpenObjectByteHashMap();
        map.put((Object)"Eleven", (byte)11);
        map.put((Object)"Twelve", (byte)12);
        map.put((Object)"Thirteen", (byte)13);
        map.put((Object)"Fourteen", (byte)14);
        ByteArrayList values = new ByteArrayList();
        ArrayList keys = new ArrayList();
        map.pairsSortedByKey(keys, values);
        OpenObjectByteHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenObjectByteHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenObjectByteHashMapTest.assertEquals((long)11L, (long)values.get(0));
        OpenObjectByteHashMapTest.assertSame((Object)"Eleven", keys.get(0));
        OpenObjectByteHashMapTest.assertEquals((long)14L, (long)values.get(1));
        OpenObjectByteHashMapTest.assertSame((Object)"Fourteen", keys.get(1));
        OpenObjectByteHashMapTest.assertEquals((long)13L, (long)values.get(2));
        OpenObjectByteHashMapTest.assertSame((Object)"Thirteen", keys.get(2));
        OpenObjectByteHashMapTest.assertEquals((long)12L, (long)values.get(3));
        OpenObjectByteHashMapTest.assertSame((Object)"Twelve", keys.get(3));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPairsSortedByKeyNotComparable() {
        OpenObjectByteHashMap map = new OpenObjectByteHashMap();
        map.put((Object)this.ncKeys[0], (byte)11);
        map.put((Object)this.ncKeys[1], (byte)12);
        map.put((Object)this.ncKeys[2], (byte)13);
        map.put((Object)this.ncKeys[3], (byte)14);
        ByteArrayList values = new ByteArrayList();
        ArrayList keys = new ArrayList();
        map.pairsSortedByKey(keys, values);
    }

    @Test
    public void testPairsSortedByValue() {
        OpenObjectByteHashMap map = new OpenObjectByteHashMap();
        map.put((Object)"Eleven", (byte)11);
        map.put((Object)"Twelve", (byte)12);
        map.put((Object)"Thirteen", (byte)13);
        map.put((Object)"Fourteen", (byte)14);
        ArrayList keys = new ArrayList();
        ByteArrayList values = new ByteArrayList();
        map.pairsSortedByValue(keys, values);
        OpenObjectByteHashMapTest.assertEquals((long)11L, (long)values.get(0));
        OpenObjectByteHashMapTest.assertEquals((Object)"Eleven", keys.get(0));
        OpenObjectByteHashMapTest.assertEquals((long)12L, (long)values.get(1));
        OpenObjectByteHashMapTest.assertEquals((Object)"Twelve", keys.get(1));
        OpenObjectByteHashMapTest.assertEquals((long)13L, (long)values.get(2));
        OpenObjectByteHashMapTest.assertEquals((Object)"Thirteen", keys.get(2));
        OpenObjectByteHashMapTest.assertEquals((long)14L, (long)values.get(3));
        OpenObjectByteHashMapTest.assertEquals((Object)"Fourteen", keys.get(3));
    }

    private static class Pair
    implements Comparable<Pair> {
        byte v;
        String k;

        Pair(String k, byte v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            return this.k.compareTo(o.k);
        }
    }

    private static class NotComparableKey {
        protected int x;

        public NotComparableKey(int x) {
            this.x = x;
        }

        public String toString() {
            return "[k " + this.x + " ]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.x;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NotComparableKey other = (NotComparableKey)obj;
            return this.x == other.x;
        }
    }
}

