/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.LongLongProcedure;
import org.apache.mahout.math.function.LongProcedure;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.map.OpenLongLongHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenLongLongHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenLongLongHashMap map = new OpenLongLongHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongLongHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenLongLongHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenLongLongHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenLongLongHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongLongHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenLongLongHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenLongLongHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenLongLongHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongLongHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenLongLongHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenLongLongHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenLongLongHashMap map = new OpenLongLongHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongLongHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenLongLongHashMap map = new OpenLongLongHashMap();
        map.put(11L, 22L);
        OpenLongLongHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenLongLongHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenLongLongHashMapTest.assertEquals((double)0.0, (double)map.get(11L), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenLongLongHashMap map = new OpenLongLongHashMap();
        map.put(11L, 22L);
        OpenLongLongHashMap map2 = (OpenLongLongHashMap)map.clone();
        map.clear();
        OpenLongLongHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenLongLongHashMap map = new OpenLongLongHashMap();
        map.put(11L, 22L);
        OpenLongLongHashMapTest.assertTrue((boolean)map.containsKey(11L));
        OpenLongLongHashMapTest.assertFalse((boolean)map.containsKey(12L));
    }

    @Test
    public void testContainValue() {
        OpenLongLongHashMap map = new OpenLongLongHashMap();
        map.put(11L, 22L);
        OpenLongLongHashMapTest.assertTrue((boolean)map.containsValue(22L));
        OpenLongLongHashMapTest.assertFalse((boolean)map.containsValue(23L));
    }

    @Test
    public void testForEachKey() {
        final LongArrayList keys = new LongArrayList();
        OpenLongLongHashMap map = new OpenLongLongHashMap();
        map.put(11L, 22L);
        map.put(12L, 23L);
        map.put(13L, 24L);
        map.put(14L, 25L);
        map.removeKey(13L);
        map.forEachKey(new LongProcedure(){

            public boolean apply(long element) {
                keys.add(element);
                return true;
            }
        });
        long[] keysArray = keys.toArray(new long[keys.size()]);
        Arrays.sort(keysArray);
        OpenLongLongHashMapTest.assertArrayEquals((long[])new long[]{11L, 12L, 14L}, (long[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenLongLongHashMap map = new OpenLongLongHashMap();
        map.put(11L, 22L);
        map.put(12L, 23L);
        map.put(13L, 24L);
        map.put(14L, 25L);
        map.removeKey(13L);
        map.forEachPair(new LongLongProcedure(){

            public boolean apply(long first, long second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenLongLongHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenLongLongHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenLongLongHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenLongLongHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenLongLongHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenLongLongHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenLongLongHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new LongLongProcedure(){
            int count = 0;

            public boolean apply(long first, long second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenLongLongHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenLongLongHashMap map = new OpenLongLongHashMap();
        map.put(11L, 22L);
        map.put(12L, 23L);
        OpenLongLongHashMapTest.assertEquals((long)22L, (long)map.get(11L));
        OpenLongLongHashMapTest.assertEquals((long)0L, (long)map.get(0L));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenLongLongHashMap map = new OpenLongLongHashMap();
        map.put(11L, 22L);
        map.put(12L, 23L);
        map.put(13L, 24L);
        map.put(14L, 25L);
        map.adjustOrPutValue(11L, 1L, 3L);
        OpenLongLongHashMapTest.assertEquals((long)25L, (long)map.get(11L));
        map.adjustOrPutValue(15L, 1L, 3L);
        OpenLongLongHashMapTest.assertEquals((long)1L, (long)map.get(15L));
    }

    @Test
    public void testKeys() {
        OpenLongLongHashMap map = new OpenLongLongHashMap();
        map.put(11L, 22L);
        map.put(12L, 22L);
        LongArrayList keys = new LongArrayList();
        map.keys(keys);
        keys.sort();
        OpenLongLongHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenLongLongHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        LongArrayList k2 = map.keys();
        k2.sort();
        OpenLongLongHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        LongArrayList keyList = new LongArrayList();
        LongArrayList valueList = new LongArrayList();
        OpenLongLongHashMap map = new OpenLongLongHashMap();
        map.put(11L, 22L);
        map.put(12L, 23L);
        map.put(13L, 24L);
        map.put(14L, 25L);
        map.removeKey(13L);
        map.pairsMatching(new LongLongProcedure(){

            public boolean apply(long first, long second) {
                return first % 2L == 0L;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenLongLongHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenLongLongHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenLongLongHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenLongLongHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenLongLongHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenLongLongHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenLongLongHashMap map = new OpenLongLongHashMap();
        map.put(11L, 22L);
        map.put(12L, 23L);
        map.put(13L, 24L);
        map.put(14L, 25L);
        map.removeKey(13L);
        LongArrayList values = new LongArrayList(100);
        map.values(values);
        OpenLongLongHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenLongLongHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenLongLongHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenLongLongHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenLongLongHashMap map = new OpenLongLongHashMap();
        map.put(11L, 22L);
        OpenLongLongHashMap map2 = (OpenLongLongHashMap)map.copy();
        map.clear();
        OpenLongLongHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenLongLongHashMap map = new OpenLongLongHashMap();
        map.put(11L, 22L);
        map.put(12L, 23L);
        map.put(13L, 24L);
        map.put(14L, 25L);
        map.removeKey(13L);
        OpenLongLongHashMap map2 = (OpenLongLongHashMap)map.copy();
        OpenLongLongHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenLongLongHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenLongLongHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenLongLongHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11L);
        OpenLongLongHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenLongLongHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenLongLongHashMap map = new OpenLongLongHashMap();
        map.put(11L, 22L);
        map.put(12L, 23L);
        map.put(13L, 24L);
        map.put(14L, 25L);
        map.removeKey(13L);
        LongArrayList keys = new LongArrayList();
        map.keysSortedByValue(keys);
        long[] keysArray = keys.toArray(new long[keys.size()]);
        OpenLongLongHashMapTest.assertArrayEquals((long[])new long[]{11L, 12L, 14L}, (long[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenLongLongHashMap map = new OpenLongLongHashMap();
        map.put(11L, 100L);
        map.put(12L, 70L);
        map.put(13L, 30L);
        map.put(14L, 3L);
        LongArrayList keys = new LongArrayList();
        LongArrayList values = new LongArrayList();
        map.pairsSortedByKey(keys, values);
        OpenLongLongHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenLongLongHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenLongLongHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenLongLongHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenLongLongHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenLongLongHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenLongLongHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenLongLongHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenLongLongHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenLongLongHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenLongLongHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenLongLongHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenLongLongHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenLongLongHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenLongLongHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenLongLongHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenLongLongHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenLongLongHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        long k;
        long v;

        Pair(long k, long v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

