/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.LongFloatProcedure;
import org.apache.mahout.math.function.LongProcedure;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.map.OpenLongFloatHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenLongFloatHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenLongFloatHashMap map = new OpenLongFloatHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongFloatHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenLongFloatHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenLongFloatHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenLongFloatHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongFloatHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenLongFloatHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenLongFloatHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenLongFloatHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongFloatHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenLongFloatHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenLongFloatHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenLongFloatHashMap map = new OpenLongFloatHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongFloatHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenLongFloatHashMap map = new OpenLongFloatHashMap();
        map.put(11L, 22.0f);
        OpenLongFloatHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenLongFloatHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenLongFloatHashMapTest.assertEquals((double)0.0, (double)map.get(11L), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenLongFloatHashMap map = new OpenLongFloatHashMap();
        map.put(11L, 22.0f);
        OpenLongFloatHashMap map2 = (OpenLongFloatHashMap)map.clone();
        map.clear();
        OpenLongFloatHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenLongFloatHashMap map = new OpenLongFloatHashMap();
        map.put(11L, 22.0f);
        OpenLongFloatHashMapTest.assertTrue((boolean)map.containsKey(11L));
        OpenLongFloatHashMapTest.assertFalse((boolean)map.containsKey(12L));
    }

    @Test
    public void testContainValue() {
        OpenLongFloatHashMap map = new OpenLongFloatHashMap();
        map.put(11L, 22.0f);
        OpenLongFloatHashMapTest.assertTrue((boolean)map.containsValue(22.0f));
        OpenLongFloatHashMapTest.assertFalse((boolean)map.containsValue(23.0f));
    }

    @Test
    public void testForEachKey() {
        final LongArrayList keys = new LongArrayList();
        OpenLongFloatHashMap map = new OpenLongFloatHashMap();
        map.put(11L, 22.0f);
        map.put(12L, 23.0f);
        map.put(13L, 24.0f);
        map.put(14L, 25.0f);
        map.removeKey(13L);
        map.forEachKey(new LongProcedure(){

            public boolean apply(long element) {
                keys.add(element);
                return true;
            }
        });
        long[] keysArray = keys.toArray(new long[keys.size()]);
        Arrays.sort(keysArray);
        OpenLongFloatHashMapTest.assertArrayEquals((long[])new long[]{11L, 12L, 14L}, (long[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenLongFloatHashMap map = new OpenLongFloatHashMap();
        map.put(11L, 22.0f);
        map.put(12L, 23.0f);
        map.put(13L, 24.0f);
        map.put(14L, 25.0f);
        map.removeKey(13L);
        map.forEachPair(new LongFloatProcedure(){

            public boolean apply(long first, float second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenLongFloatHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenLongFloatHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenLongFloatHashMapTest.assertEquals((double)22.0, (double)((Pair)pairs.get((int)0)).v, (double)1.0E-6f);
        OpenLongFloatHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenLongFloatHashMapTest.assertEquals((double)23.0, (double)((Pair)pairs.get((int)1)).v, (double)1.0E-6f);
        OpenLongFloatHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenLongFloatHashMapTest.assertEquals((double)25.0, (double)((Pair)pairs.get((int)2)).v, (double)1.0E-6f);
        pairs.clear();
        map.forEachPair(new LongFloatProcedure(){
            int count = 0;

            public boolean apply(long first, float second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenLongFloatHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenLongFloatHashMap map = new OpenLongFloatHashMap();
        map.put(11L, 22.0f);
        map.put(12L, 23.0f);
        OpenLongFloatHashMapTest.assertEquals((double)22.0, (double)map.get(11L), (double)1.0E-6f);
        OpenLongFloatHashMapTest.assertEquals((double)0.0, (double)map.get(0L), (double)1.0E-6f);
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenLongFloatHashMap map = new OpenLongFloatHashMap();
        map.put(11L, 22.0f);
        map.put(12L, 23.0f);
        map.put(13L, 24.0f);
        map.put(14L, 25.0f);
        map.adjustOrPutValue(11L, 1.0f, 3.0f);
        OpenLongFloatHashMapTest.assertEquals((double)25.0, (double)map.get(11L), (double)1.0E-6f);
        map.adjustOrPutValue(15L, 1.0f, 3.0f);
        OpenLongFloatHashMapTest.assertEquals((double)1.0, (double)map.get(15L), (double)1.0E-6f);
    }

    @Test
    public void testKeys() {
        OpenLongFloatHashMap map = new OpenLongFloatHashMap();
        map.put(11L, 22.0f);
        map.put(12L, 22.0f);
        LongArrayList keys = new LongArrayList();
        map.keys(keys);
        keys.sort();
        OpenLongFloatHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenLongFloatHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        LongArrayList k2 = map.keys();
        k2.sort();
        OpenLongFloatHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        LongArrayList keyList = new LongArrayList();
        FloatArrayList valueList = new FloatArrayList();
        OpenLongFloatHashMap map = new OpenLongFloatHashMap();
        map.put(11L, 22.0f);
        map.put(12L, 23.0f);
        map.put(13L, 24.0f);
        map.put(14L, 25.0f);
        map.removeKey(13L);
        map.pairsMatching(new LongFloatProcedure(){

            public boolean apply(long first, float second) {
                return first % 2L == 0L;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenLongFloatHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenLongFloatHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenLongFloatHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenLongFloatHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenLongFloatHashMapTest.assertEquals((double)23.0, (double)valueList.get(0), (double)1.0E-6f);
        OpenLongFloatHashMapTest.assertEquals((double)25.0, (double)valueList.get(1), (double)1.0E-6f);
    }

    @Test
    public void testValues() {
        OpenLongFloatHashMap map = new OpenLongFloatHashMap();
        map.put(11L, 22.0f);
        map.put(12L, 23.0f);
        map.put(13L, 24.0f);
        map.put(14L, 25.0f);
        map.removeKey(13L);
        FloatArrayList values = new FloatArrayList(100);
        map.values(values);
        OpenLongFloatHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenLongFloatHashMapTest.assertEquals((double)22.0, (double)values.get(0), (double)1.0E-6f);
        OpenLongFloatHashMapTest.assertEquals((double)23.0, (double)values.get(1), (double)1.0E-6f);
        OpenLongFloatHashMapTest.assertEquals((double)25.0, (double)values.get(2), (double)1.0E-6f);
    }

    @Test
    public void testCopy() {
        OpenLongFloatHashMap map = new OpenLongFloatHashMap();
        map.put(11L, 22.0f);
        OpenLongFloatHashMap map2 = (OpenLongFloatHashMap)map.copy();
        map.clear();
        OpenLongFloatHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenLongFloatHashMap map = new OpenLongFloatHashMap();
        map.put(11L, 22.0f);
        map.put(12L, 23.0f);
        map.put(13L, 24.0f);
        map.put(14L, 25.0f);
        map.removeKey(13L);
        OpenLongFloatHashMap map2 = (OpenLongFloatHashMap)map.copy();
        OpenLongFloatHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenLongFloatHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenLongFloatHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenLongFloatHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11L);
        OpenLongFloatHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenLongFloatHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenLongFloatHashMap map = new OpenLongFloatHashMap();
        map.put(11L, 22.0f);
        map.put(12L, 23.0f);
        map.put(13L, 24.0f);
        map.put(14L, 25.0f);
        map.removeKey(13L);
        LongArrayList keys = new LongArrayList();
        map.keysSortedByValue(keys);
        long[] keysArray = keys.toArray(new long[keys.size()]);
        OpenLongFloatHashMapTest.assertArrayEquals((long[])new long[]{11L, 12L, 14L}, (long[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenLongFloatHashMap map = new OpenLongFloatHashMap();
        map.put(11L, 100.0f);
        map.put(12L, 70.0f);
        map.put(13L, 30.0f);
        map.put(14L, 3.0f);
        LongArrayList keys = new LongArrayList();
        FloatArrayList values = new FloatArrayList();
        map.pairsSortedByKey(keys, values);
        OpenLongFloatHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenLongFloatHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenLongFloatHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenLongFloatHashMapTest.assertEquals((double)100.0, (double)values.get(0), (double)1.0E-6f);
        OpenLongFloatHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenLongFloatHashMapTest.assertEquals((double)70.0, (double)values.get(1), (double)1.0E-6f);
        OpenLongFloatHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenLongFloatHashMapTest.assertEquals((double)30.0, (double)values.get(2), (double)1.0E-6f);
        OpenLongFloatHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenLongFloatHashMapTest.assertEquals((double)3.0, (double)values.get(3), (double)1.0E-6f);
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenLongFloatHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenLongFloatHashMapTest.assertEquals((double)100.0, (double)values.get(3), (double)1.0E-6f);
        OpenLongFloatHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenLongFloatHashMapTest.assertEquals((double)70.0, (double)values.get(2), (double)1.0E-6f);
        OpenLongFloatHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenLongFloatHashMapTest.assertEquals((double)30.0, (double)values.get(1), (double)1.0E-6f);
        OpenLongFloatHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenLongFloatHashMapTest.assertEquals((double)3.0, (double)values.get(0), (double)1.0E-6f);
    }

    private static class Pair
    implements Comparable<Pair> {
        long k;
        float v;

        Pair(long k, float v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

