/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.IntIntProcedure;
import org.apache.mahout.math.function.IntProcedure;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.map.OpenIntIntHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenIntIntHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenIntIntHashMap map = new OpenIntIntHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntIntHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenIntIntHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenIntIntHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenIntIntHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntIntHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenIntIntHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenIntIntHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenIntIntHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntIntHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenIntIntHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenIntIntHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenIntIntHashMap map = new OpenIntIntHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenIntIntHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenIntIntHashMap map = new OpenIntIntHashMap();
        map.put(11, 22);
        OpenIntIntHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenIntIntHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenIntIntHashMapTest.assertEquals((double)0.0, (double)map.get(11), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenIntIntHashMap map = new OpenIntIntHashMap();
        map.put(11, 22);
        OpenIntIntHashMap map2 = (OpenIntIntHashMap)map.clone();
        map.clear();
        OpenIntIntHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenIntIntHashMap map = new OpenIntIntHashMap();
        map.put(11, 22);
        OpenIntIntHashMapTest.assertTrue((boolean)map.containsKey(11));
        OpenIntIntHashMapTest.assertFalse((boolean)map.containsKey(12));
    }

    @Test
    public void testContainValue() {
        OpenIntIntHashMap map = new OpenIntIntHashMap();
        map.put(11, 22);
        OpenIntIntHashMapTest.assertTrue((boolean)map.containsValue(22));
        OpenIntIntHashMapTest.assertFalse((boolean)map.containsValue(23));
    }

    @Test
    public void testForEachKey() {
        final IntArrayList keys = new IntArrayList();
        OpenIntIntHashMap map = new OpenIntIntHashMap();
        map.put(11, 22);
        map.put(12, 23);
        map.put(13, 24);
        map.put(14, 25);
        map.removeKey(13);
        map.forEachKey(new IntProcedure(){

            public boolean apply(int element) {
                keys.add(element);
                return true;
            }
        });
        int[] keysArray = keys.toArray(new int[keys.size()]);
        Arrays.sort(keysArray);
        OpenIntIntHashMapTest.assertArrayEquals((int[])new int[]{11, 12, 14}, (int[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenIntIntHashMap map = new OpenIntIntHashMap();
        map.put(11, 22);
        map.put(12, 23);
        map.put(13, 24);
        map.put(14, 25);
        map.removeKey(13);
        map.forEachPair(new IntIntProcedure(){

            public boolean apply(int first, int second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenIntIntHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenIntIntHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenIntIntHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenIntIntHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenIntIntHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenIntIntHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenIntIntHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new IntIntProcedure(){
            int count = 0;

            public boolean apply(int first, int second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenIntIntHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenIntIntHashMap map = new OpenIntIntHashMap();
        map.put(11, 22);
        map.put(12, 23);
        OpenIntIntHashMapTest.assertEquals((long)22L, (long)map.get(11));
        OpenIntIntHashMapTest.assertEquals((long)0L, (long)map.get(0));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenIntIntHashMap map = new OpenIntIntHashMap();
        map.put(11, 22);
        map.put(12, 23);
        map.put(13, 24);
        map.put(14, 25);
        map.adjustOrPutValue(11, 1, 3);
        OpenIntIntHashMapTest.assertEquals((long)25L, (long)map.get(11));
        map.adjustOrPutValue(15, 1, 3);
        OpenIntIntHashMapTest.assertEquals((long)1L, (long)map.get(15));
    }

    @Test
    public void testKeys() {
        OpenIntIntHashMap map = new OpenIntIntHashMap();
        map.put(11, 22);
        map.put(12, 22);
        IntArrayList keys = new IntArrayList();
        map.keys(keys);
        keys.sort();
        OpenIntIntHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenIntIntHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        IntArrayList k2 = map.keys();
        k2.sort();
        OpenIntIntHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        IntArrayList keyList = new IntArrayList();
        IntArrayList valueList = new IntArrayList();
        OpenIntIntHashMap map = new OpenIntIntHashMap();
        map.put(11, 22);
        map.put(12, 23);
        map.put(13, 24);
        map.put(14, 25);
        map.removeKey(13);
        map.pairsMatching(new IntIntProcedure(){

            public boolean apply(int first, int second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenIntIntHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenIntIntHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenIntIntHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenIntIntHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenIntIntHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenIntIntHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenIntIntHashMap map = new OpenIntIntHashMap();
        map.put(11, 22);
        map.put(12, 23);
        map.put(13, 24);
        map.put(14, 25);
        map.removeKey(13);
        IntArrayList values = new IntArrayList(100);
        map.values(values);
        OpenIntIntHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenIntIntHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenIntIntHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenIntIntHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenIntIntHashMap map = new OpenIntIntHashMap();
        map.put(11, 22);
        OpenIntIntHashMap map2 = (OpenIntIntHashMap)map.copy();
        map.clear();
        OpenIntIntHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenIntIntHashMap map = new OpenIntIntHashMap();
        map.put(11, 22);
        map.put(12, 23);
        map.put(13, 24);
        map.put(14, 25);
        map.removeKey(13);
        OpenIntIntHashMap map2 = (OpenIntIntHashMap)map.copy();
        OpenIntIntHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenIntIntHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenIntIntHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenIntIntHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11);
        OpenIntIntHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenIntIntHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenIntIntHashMap map = new OpenIntIntHashMap();
        map.put(11, 22);
        map.put(12, 23);
        map.put(13, 24);
        map.put(14, 25);
        map.removeKey(13);
        IntArrayList keys = new IntArrayList();
        map.keysSortedByValue(keys);
        int[] keysArray = keys.toArray(new int[keys.size()]);
        OpenIntIntHashMapTest.assertArrayEquals((int[])new int[]{11, 12, 14}, (int[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenIntIntHashMap map = new OpenIntIntHashMap();
        map.put(11, 100);
        map.put(12, 70);
        map.put(13, 30);
        map.put(14, 3);
        IntArrayList keys = new IntArrayList();
        IntArrayList values = new IntArrayList();
        map.pairsSortedByKey(keys, values);
        OpenIntIntHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenIntIntHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenIntIntHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenIntIntHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenIntIntHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenIntIntHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenIntIntHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenIntIntHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenIntIntHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenIntIntHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenIntIntHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenIntIntHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenIntIntHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenIntIntHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenIntIntHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenIntIntHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenIntIntHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenIntIntHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        int k;
        int v;

        Pair(int k, int v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

