/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.FloatObjectProcedure;
import org.apache.mahout.math.function.FloatProcedure;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.map.OpenFloatObjectHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OpenFloatObjectHashMapTest
extends Assert {
    private TestClass item;
    private TestClass anotherItem;
    private TestClass anotherItem2;
    private TestClass anotherItem3;
    private TestClass anotherItem4;
    private TestClass anotherItem5;

    @Before
    public void before() {
        this.item = new TestClass(101.0f);
        this.anotherItem = new TestClass(99.0f);
        this.anotherItem2 = new TestClass(2.0f);
        this.anotherItem3 = new TestClass(3.0f);
        this.anotherItem4 = new TestClass(4.0f);
        this.anotherItem5 = new TestClass(5.0f);
    }

    @Test
    public void testConstructors() {
        OpenFloatObjectHashMap map = new OpenFloatObjectHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatObjectHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenFloatObjectHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenFloatObjectHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenFloatObjectHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatObjectHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenFloatObjectHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenFloatObjectHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenFloatObjectHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatObjectHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenFloatObjectHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenFloatObjectHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenFloatObjectHashMap map = new OpenFloatObjectHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenFloatObjectHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenFloatObjectHashMap map = new OpenFloatObjectHashMap();
        map.put(11.0f, (Object)this.item);
        OpenFloatObjectHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenFloatObjectHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenFloatObjectHashMapTest.assertSame(null, (Object)map.get(11.0f));
    }

    @Test
    public void testClone() {
        OpenFloatObjectHashMap map = new OpenFloatObjectHashMap();
        map.put(11.0f, (Object)this.item);
        OpenFloatObjectHashMap map2 = map.clone();
        map.clear();
        OpenFloatObjectHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenFloatObjectHashMap map = new OpenFloatObjectHashMap();
        map.put(11.0f, (Object)this.item);
        OpenFloatObjectHashMapTest.assertTrue((boolean)map.containsKey(11.0f));
        OpenFloatObjectHashMapTest.assertFalse((boolean)map.containsKey(12.0f));
    }

    @Test
    public void testContainValue() {
        OpenFloatObjectHashMap map = new OpenFloatObjectHashMap();
        map.put(11.0f, (Object)this.item);
        OpenFloatObjectHashMapTest.assertTrue((boolean)map.containsValue((Object)this.item));
        OpenFloatObjectHashMapTest.assertFalse((boolean)map.containsValue((Object)this.anotherItem));
    }

    @Test
    public void testForEachKey() {
        final FloatArrayList keys = new FloatArrayList();
        OpenFloatObjectHashMap map = new OpenFloatObjectHashMap();
        map.put(11.0f, (Object)this.anotherItem);
        map.put(12.0f, (Object)this.anotherItem2);
        map.put(13.0f, (Object)this.anotherItem3);
        map.put(14.0f, (Object)this.anotherItem4);
        map.removeKey(13.0f);
        map.forEachKey(new FloatProcedure(){

            public boolean apply(float element) {
                keys.add(element);
                return true;
            }
        });
        float[] keysArray = keys.toArray(new float[keys.size()]);
        Arrays.sort(keysArray);
        OpenFloatObjectHashMapTest.assertArrayEquals((float[])new float[]{11.0f, 12.0f, 14.0f}, (float[])keysArray, (float)1.0E-6f);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenFloatObjectHashMap map = new OpenFloatObjectHashMap();
        map.put(11.0f, (Object)this.anotherItem);
        map.put(12.0f, (Object)this.anotherItem2);
        map.put(13.0f, (Object)this.anotherItem3);
        map.put(14.0f, (Object)this.anotherItem4);
        map.removeKey(13.0f);
        map.forEachPair((FloatObjectProcedure)new FloatObjectProcedure<TestClass>(){

            public boolean apply(float first, TestClass second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenFloatObjectHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenFloatObjectHashMapTest.assertEquals((double)11.0, (double)((Pair)pairs.get((int)0)).k, (double)1.0E-6f);
        OpenFloatObjectHashMapTest.assertSame((Object)this.anotherItem, (Object)((Pair)pairs.get((int)0)).v);
        OpenFloatObjectHashMapTest.assertEquals((double)12.0, (double)((Pair)pairs.get((int)1)).k, (double)1.0E-6f);
        OpenFloatObjectHashMapTest.assertSame((Object)this.anotherItem2, (Object)((Pair)pairs.get((int)1)).v);
        OpenFloatObjectHashMapTest.assertEquals((double)14.0, (double)((Pair)pairs.get((int)2)).k, (double)1.0E-6f);
        OpenFloatObjectHashMapTest.assertSame((Object)this.anotherItem4, (Object)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair((FloatObjectProcedure)new FloatObjectProcedure<TestClass>(){
            int count = 0;

            public boolean apply(float first, TestClass second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenFloatObjectHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenFloatObjectHashMap map = new OpenFloatObjectHashMap();
        map.put(11.0f, (Object)this.item);
        map.put(12.0f, (Object)this.anotherItem);
        OpenFloatObjectHashMapTest.assertSame((Object)this.item, (Object)map.get(11.0f));
        OpenFloatObjectHashMapTest.assertSame(null, (Object)map.get(0.0f));
    }

    @Test
    public void testKeys() {
        OpenFloatObjectHashMap map = new OpenFloatObjectHashMap();
        map.put(11.0f, (Object)this.item);
        map.put(12.0f, (Object)this.item);
        FloatArrayList keys = new FloatArrayList();
        map.keys(keys);
        keys.sort();
        OpenFloatObjectHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6f);
        OpenFloatObjectHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6f);
        FloatArrayList k2 = map.keys();
        k2.sort();
        OpenFloatObjectHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        FloatArrayList keyList = new FloatArrayList();
        ArrayList valueList = new ArrayList();
        OpenFloatObjectHashMap map = new OpenFloatObjectHashMap();
        map.put(11.0f, (Object)this.anotherItem2);
        map.put(12.0f, (Object)this.anotherItem3);
        map.put(13.0f, (Object)this.anotherItem4);
        map.put(14.0f, (Object)this.anotherItem5);
        map.removeKey(13.0f);
        map.pairsMatching((FloatObjectProcedure)new FloatObjectProcedure<TestClass>(){

            public boolean apply(float first, TestClass second) {
                return first % 2.0f == 0.0f;
            }
        }, keyList, valueList);
        keyList.sort();
        Collections.sort(valueList);
        OpenFloatObjectHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenFloatObjectHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenFloatObjectHashMapTest.assertEquals((double)12.0, (double)keyList.get(0), (double)1.0E-6f);
        OpenFloatObjectHashMapTest.assertEquals((double)14.0, (double)keyList.get(1), (double)1.0E-6f);
        OpenFloatObjectHashMapTest.assertSame((Object)this.anotherItem3, valueList.get(0));
        OpenFloatObjectHashMapTest.assertSame((Object)this.anotherItem5, valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenFloatObjectHashMap map = new OpenFloatObjectHashMap();
        map.put(11.0f, (Object)this.anotherItem);
        map.put(12.0f, (Object)this.anotherItem2);
        map.put(13.0f, (Object)this.anotherItem3);
        map.put(14.0f, (Object)this.anotherItem4);
        map.removeKey(13.0f);
        ArrayList values = new ArrayList(100);
        map.values(values);
        OpenFloatObjectHashMapTest.assertEquals((long)3L, (long)values.size());
        Collections.sort(values);
        OpenFloatObjectHashMapTest.assertEquals((Object)this.anotherItem2, values.get(0));
        OpenFloatObjectHashMapTest.assertEquals((Object)this.anotherItem4, values.get(1));
        OpenFloatObjectHashMapTest.assertEquals((Object)this.anotherItem, values.get(2));
    }

    @Test
    public void testCopy() {
        OpenFloatObjectHashMap map = new OpenFloatObjectHashMap();
        map.put(11.0f, (Object)this.item);
        OpenFloatObjectHashMap map2 = (OpenFloatObjectHashMap)map.copy();
        map.clear();
        OpenFloatObjectHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenFloatObjectHashMap map = new OpenFloatObjectHashMap();
        map.put(11.0f, (Object)this.anotherItem);
        map.put(12.0f, (Object)this.anotherItem2);
        map.put(13.0f, (Object)this.anotherItem3);
        map.put(14.0f, (Object)this.anotherItem4);
        map.removeKey(13.0f);
        OpenFloatObjectHashMap map2 = (OpenFloatObjectHashMap)map.copy();
        OpenFloatObjectHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenFloatObjectHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenFloatObjectHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenFloatObjectHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11.0f);
        OpenFloatObjectHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenFloatObjectHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenFloatObjectHashMap map = new OpenFloatObjectHashMap();
        map.put(11.0f, (Object)this.anotherItem5);
        map.put(12.0f, (Object)this.anotherItem4);
        map.put(13.0f, (Object)this.anotherItem3);
        map.put(14.0f, (Object)this.anotherItem2);
        map.removeKey(13.0f);
        FloatArrayList keys = new FloatArrayList();
        map.keysSortedByValue(keys);
        float[] keysArray = keys.toArray(new float[keys.size()]);
        OpenFloatObjectHashMapTest.assertArrayEquals((float[])new float[]{14.0f, 12.0f, 11.0f}, (float[])keysArray, (float)1.0E-6f);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenFloatObjectHashMap map = new OpenFloatObjectHashMap();
        map.put(11.0f, (Object)this.anotherItem5);
        map.put(12.0f, (Object)this.anotherItem4);
        map.put(13.0f, (Object)this.anotherItem3);
        map.put(14.0f, (Object)this.anotherItem2);
        FloatArrayList keys = new FloatArrayList();
        ArrayList values = new ArrayList();
        map.pairsSortedByKey(keys, values);
        OpenFloatObjectHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenFloatObjectHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenFloatObjectHashMapTest.assertEquals((double)11.0, (double)keys.get(0), (double)1.0E-6f);
        OpenFloatObjectHashMapTest.assertSame((Object)this.anotherItem5, values.get(0));
        OpenFloatObjectHashMapTest.assertEquals((double)12.0, (double)keys.get(1), (double)1.0E-6f);
        OpenFloatObjectHashMapTest.assertSame((Object)this.anotherItem4, values.get(1));
        OpenFloatObjectHashMapTest.assertEquals((double)13.0, (double)keys.get(2), (double)1.0E-6f);
        OpenFloatObjectHashMapTest.assertSame((Object)this.anotherItem3, values.get(2));
        OpenFloatObjectHashMapTest.assertEquals((double)14.0, (double)keys.get(3), (double)1.0E-6f);
        OpenFloatObjectHashMapTest.assertSame((Object)this.anotherItem2, values.get(3));
    }

    @Test
    public void testPairsSortedByValue() {
        OpenFloatObjectHashMap map = new OpenFloatObjectHashMap();
        map.put(11.0f, (Object)this.anotherItem5);
        map.put(12.0f, (Object)this.anotherItem4);
        map.put(13.0f, (Object)this.anotherItem3);
        map.put(14.0f, (Object)this.anotherItem2);
        FloatArrayList keys = new FloatArrayList();
        ArrayList values = new ArrayList();
        map.pairsSortedByValue(keys, values);
        OpenFloatObjectHashMapTest.assertEquals((double)11.0, (double)keys.get(3), (double)1.0E-6f);
        OpenFloatObjectHashMapTest.assertEquals((Object)this.anotherItem5, values.get(3));
        OpenFloatObjectHashMapTest.assertEquals((double)12.0, (double)keys.get(2), (double)1.0E-6f);
        OpenFloatObjectHashMapTest.assertEquals((Object)this.anotherItem4, values.get(2));
        OpenFloatObjectHashMapTest.assertEquals((double)13.0, (double)keys.get(1), (double)1.0E-6f);
        OpenFloatObjectHashMapTest.assertEquals((Object)this.anotherItem3, values.get(1));
        OpenFloatObjectHashMapTest.assertEquals((double)14.0, (double)keys.get(0), (double)1.0E-6f);
        OpenFloatObjectHashMapTest.assertEquals((Object)this.anotherItem2, values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        float k;
        TestClass v;

        Pair(float k, TestClass v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }

    private static class TestClass
    implements Comparable<TestClass> {
        float x;

        TestClass(float x) {
            this.x = x;
        }

        public String toString() {
            return "[ts " + this.x + " ]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Float.valueOf(this.x).hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestClass other = (TestClass)obj;
            return this.x == other.x;
        }

        @Override
        public int compareTo(TestClass o) {
            return Float.compare(this.x, o.x);
        }
    }
}

